#include "demoservicelogic.h"

DemoServiceLogic::DemoServiceLogic()
{
    /// Inizialize network client
    client = new soapclient();

    //TODO: String to connect to database, what service used
    /// Inizialize database
    db = new Mdb();
    tmp_tree = new GoodsTree(db);
}

void DemoServiceLogic::getGoods()
{
    client->getData("GetGoods");
    connect(client, SIGNAL(resultGoodsIsReady(QStandardItemModel*)), this, SLOT(updateGoods(QStandardItemModel*)));
}

void DemoServiceLogic::getContractors()
{
    client->getData("GetContractors");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getContracts()
{
    client->getData("GetContract");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getContractTypes()
{
    client->getData("GetContractTypes");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getDelivery()
{
    client->getData("GetDelivery");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getDiscount()
{
    client->getData("GetDiscount");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getGoodTypes()
{
    client->getData("GetGoodTypes");
    connect(client, SIGNAL(resultGoodTypesIsReady(QStandardItemModel*)), this, SLOT(updateGoodTypes(QStandardItemModel*)));
}

void DemoServiceLogic::getOrders()
{
    client->getData("GetOrders");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getPay()
{
    client->getData("GetPay");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getPrice()
{
    client->getData("GetPrice");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getSampleOrderComment()
{
    client->getData("GetSampleOrderComment");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getSellFirm()
{
    client->getData("GetSellFirm");
    // TODO: Do connect from signal to update slot
}

void DemoServiceLogic::getSellPoints()
{
    client->getData("GetSellPoints");
    connect(client, SIGNAL(resultSellPointsIsReady(QStandardItemModel*)), this, SLOT(updateSellPoints(QStandardItemModel*)));
}

void DemoServiceLogic::getAll()
{
    /// Update all objects
    this->getContractors();
    this->getContracts();
    this->getContractTypes();
    this->getDelivery();
    this->getDiscount();
    this->getGoods();
    this->getGoodTypes();
    this->getOrders();
    this->getPay();
    this->getPrice();
    this->getSampleOrderComment();
    this->getSellPoints();
}

void DemoServiceLogic::updateGoods(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    db->dirty_hacked_exec("delete from tblGoods;");

#ifdef DEBUG
    qDebug() << "ALERT: Get goods start";
#endif

    /// Processing all goods

#ifdef DEBUG
    qDebug() << " IN FUNCTION: Processing all goods";
#endif
    for (int i=0;i<model->rowCount();i++)
    {
        ///TODO: Check for NULL
        /// Create new good
        Good* tmp_good = new Good();

        /// Set good values from
        tmp_good->setName(model->item(i,1)->text());
        tmp_good->setQuantity(model->item(i,2)->text().toInt());
        tmp_good->setPrice(model->item(i,3)->text().toDouble());
        tmp_good->setType(model->item(i,4)->text().toInt());
        tmp_good->setRemains(model->item(i,6)->text().toInt());
        tmp_good->setDescription(model->item(i,7)->text());
        /// Add good to database
        tmp_good->set(this->db);
    }

#ifdef DEBUG
    qDebug() << "ALERT: Get goods finished";
#endif
}

void DemoServiceLogic::updateGoodTypes(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    db->dirty_hacked_exec("delete from tblGoodsType;");

#ifdef DEBUG
    qDebug() << "ALERT: Get good types start";
#endif

    /// Processing all goods

#ifdef DEBUG
    qDebug() << " IN FUNCTION: Processing all good types";
#endif
    for (int i=0;i<model->rowCount();i++)
    {
        ///TODO: Check for NULL
        /// Create new good type
        GoodsType *tmp_types = new GoodsType();

        /// Set good type values from
        tmp_types->setId(model->item(i,0)->text().toInt());
        tmp_types->setName(model->item(i,1)->text());
        tmp_types->setParentId(model->item(i,2)->text().toInt());

        /// Add good to database
        tmp_types->set(this->db);
    }

#ifdef DEBUG
    qDebug() << "ALERT: Get good types finished";
#endif
    disconnect(client, SIGNAL(resultGoodTypesIsReady(QStandardItemModel*)), this, SLOT(updateGoodTypes(QStandardItemModel*)));
}

void DemoServiceLogic::updateContractors(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    this->db->dirty_hacked_exec("delete from tblContractor;");

#ifdef DEBUG
    qDebug() << "ALERT: Get contractors start";
#endif
    /// Processing all contractors
    for(int i = 0; i < model->rowCount(); i++)
    {
        /// Create and initialize object
        Contractor *tmp_contractor = new Contractor(
                model->item(i,0)->text().toInt(),
                model->item(i,1)->text(),
                model->item(i,2)->text(),
                model->item(i,3)->text());
        /// Add object to database
        tmp_contractor->set(this->db);
    }
#ifdef DEBUG
    qDebug() << "ALERT: Get contractors finished";
#endif
}

void DemoServiceLogic::updateOrders(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    this->db->dirty_hacked_exec("delete from tblOrder;");

#ifdef DEBUG
    qDebug() << "ALERT: Get orders start";
#endif
    /// Processing all orders
    for(int i = 0; i < model->rowCount(); i++)
    {
        /// Create and initialize object
        Order *tmp_order = new Order();

        /// Structure of data
        /**
                id          ID
                contrid     Contractor ID
                sellpointid SellPoint ID
                payid       Pay ID
                priceid     Price ID
                delivid     Delivery ID
                post        Post(bool)
                discount    Discount(real)
                date        Date of processing(date)
                payupto     Last date(date)
                alt_address Address
                sellfirmid  Sell firm ID
                comment     Commentary
                contractid  Contract ID
        */

        /// Add data to object

        /// Create temp contractor and get from database by ID
        Contractor *tmp_contractor = new Contractor(this->db, model->item(i,1)->text().toInt());
        tmp_order->setContractor(tmp_contractor);

        /// Create temp sell point and get from database by ID
        SellPoint *tmp_sellpoint = new SellPoint(this->db, model->item(i,2)->text().toInt());
        tmp_order->setSellPoint(tmp_sellpoint);

        /// Create temp pay type and get from database by ID
        PayType *tmp_paytype = new PayType();
        ///TODO: Initialize object from database
        tmp_order->setPayType(NULL);

        /// Create temp price type and get from database by ID
        PriceType *tmp_pricetype = new PriceType();
        ///TODO: Initialize object from database
        tmp_order->setPriceType(NULL);

        /// Create temp delivery type and get from database by ID
        DeliveryType *tmp_delivery = new DeliveryType();
        ///TODO: Initialize object from database
        tmp_order->setDeliveryType(NULL);

        /// If order is posted, set post
        if(model->item(i,6)->text().toInt())
            tmp_order->setPosted();;

        /// Set discount
        tmp_order->setDiscount(model->item(i,7)->text().toDouble());

        /// Set date

        /// Get date in string
        QString tmp_date_str = model->item(i,8)->text();

        /// Parse date
        ///TODO: Wait interface of GetOrder in demo web-service

        /// Create tmp_date object
        QDate *tmp_date = new QDate();
        tmp_order->setDate(tmp_date);

        /// Set PayUpTo date
        QString tmp_payuptodate_str = model->item(i,9)->text();

        /// Parse date
        ///TODO: Wait interface of GetOrder in demo web-service

        /// Create tmp_date object
        QDate *tmp_payuptodate = new QDate();
        tmp_order->setDate(tmp_payuptodate);

        /// Set alternative address
        tmp_order->setAltAddress(model->item(i,10)->text());

        /// Create temp sell firm and get from database by ID
        SellFirm *tmp_sellfirm = new SellFirm();
        ///TODO: Initialize object from database
        tmp_order->setSellFirm(tmp_sellfirm);

        /// Create temp sell firm and get from database by ID
        Contract *tmp_contract = new Contract();
        ///TODO: Initialize object from database
        tmp_order->setContract(tmp_contract);

        /// Set commentary
        tmp_order->setComment(model->item(i, 13)->text());

        /// Add object to database
        tmp_order->set(this->db);
    }

#ifdef DEBUG
    qDebug() << "ALERT: Get contractors finished";
#endif

}

void DemoServiceLogic::updateContracts(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    this->db->dirty_hacked_exec("delete from tblContract;");

#ifdef DEBUG
    qDebug() << "ALERT: Get contracts start";
#endif

    /// Processing all goods

#ifdef DEBUG
    qDebug() << " IN FUNCTION: Processing all contracts";
#endif
    for (int i=0;i<model->rowCount();i++)
    {
        ///TODO: Check for NULL
        /// Create new contract
        Contract *tmp_contract = new Contract();

        /// Set contract values from
        ///TODO: Add fields: after solve #167 ticket

        /// Add good to database
        //TODO: method set for Contract
        //tmp_contract->
    }

#ifdef DEBUG
    qDebug() << "ALERT: Get contracts finished";
#endif

}

void DemoServiceLogic::updateDelivery(QStandardItemModel *model)
{
    ///TODO: After solve #167 ticket
}

void DemoServiceLogic::updateContractTypes(QStandardItemModel *model)
{
    ///TODO: After solve #167 ticket

}

void DemoServiceLogic::updatePay(QStandardItemModel *model)
{
    ///TODO: After solve #167 ticket
}

void DemoServiceLogic::updateDiscount(QStandardItemModel *model)
{
    ///TODO: After solve #167 ticket
}

void DemoServiceLogic::updatePrice(QStandardItemModel *)
{
    ///TODO: After solve #167 ticket
}

void DemoServiceLogic::updateSellFirm(QStandardItemModel *model)
{
    ///TODO: After solve #167 ticket
}

void DemoServiceLogic::updateSellPoints(QStandardItemModel *model)
{
    //TODO: Not availible method
    /// Cleare data in database
    this->db->dirty_hacked_exec("delete from tblSellPoints;");

#ifdef DEBUG
    qDebug() << "ALERT: Get sell points start";
#endif

    /// Processing all goods

#ifdef DEBUG
    qDebug() << " IN FUNCTION: Processing all sell points";
#endif
    for (int i=0;i<model->rowCount();i++)
    {
        ///TODO: Check for NULL
        /// Create new sell point
        SellPoint *tmp_sellpoint = new SellPoint();

        /// Set sell point values from
        tmp_sellpoint->setId(model->item(i,0)->text().toInt());
        tmp_sellpoint->setName(model->item(i,1)->text());
        tmp_sellpoint->setAddress(model->item(i,5)->text());

        /// Add sell point to database
        tmp_sellpoint->set(this->db);
    }

#ifdef DEBUG
    qDebug() << "ALERT: Get sell points finished";
#endif
    disconnect(client, SIGNAL(resultSellPointsIsReady(QStandardItemModel*)), this, SLOT(updateSellPoints(QStandardItemModel*)));
}

void DemoServiceLogic::updateSampleOrderComment(QStandardItemModel *model)
{
    ///TODO: When will be creating object SampleOrderComment
}

void DemoServiceLogic::goodsView()
{

#ifdef DEBUG
    qDebug() << "IN FUNCTION: goodsView()";
#endif
    /// Create goods tree
    //GoodsTree *tmp_tree = new GoodsTree(this->db);

    /// Start filter is ""
    tmp_tree->setFilter("");

#ifdef DEBUG
    qDebug() << "SIGNAL: pathReady connect";
#endif
    /// Start path is root
    emit pathReady(tmp_tree->getPath(tmp_tree->getRoot()));

#ifdef DEBUG
    qDebug() << "SIGNAL: goodsReady connect";
#endif
    /// Send start path goods
    emit goodsReady(tmp_tree->getGoods(tmp_tree->getRoot()));

#ifdef DEBUG
    qDebug() << "SIGNAL: typesReady connect";
#endif
    /// Send start path subcategories
    emit typesReady(tmp_tree->getTypes(tmp_tree->getRoot()));
}

void DemoServiceLogic::goodSelected(int id)
{

#ifdef DEBUG
    qDebug() << "IN FUNCTION: goodSelected(" << id << ")";
#endif

    /// Create good and initialize from database by id
    Good* good = new Good(this->db, id);

#ifdef DEBUG
    qDebug() << "SIGNAL: goods detail signals are connect";
#endif
    /// Send signals about goods detail
    emit goodDetailName(QString::QString("%1").arg(good->getName()));
    emit goodDetailQuantity(QString::QString("%1").arg(good->getQuantity()));
    emit goodDetailPrice(QString::QString("%1").arg(good->getPrice()));

    // TODO: >>>>
    //emit goodDetailTypeName(good->getType());

    emit goodDetailRemain(QString::QString("%1").arg(good->getRemains()));
    emit goodDetailCurrency(QString::QString("RU"));

    // TODO: >>>> getPlan()
    //emit goodDetailPlan(good->getPlan());
    /// End signals about goods detail
}

void DemoServiceLogic::goodsFiltered(QString filter)
{

#ifdef DEBUG
    qDebug() << "IN FUNCTION: goodsFiltered(" + filter + ")";
#endif

    /// Create good tree
    //GoodsTree *tmp_tree = new GoodsTree(this->db);

#ifdef DEBUG
    qDebug() << "New filter setted: " << filter;
#endif

    /// Set filter
    tmp_tree->setFilter(filter);

    /// Create good type and initialize from database by id = 0
    GoodsType* type = new GoodsType(this->db, 0);

#ifdef DEBUG
    qDebug() << "SIGNAL: pathReady connect";
#endif
    /// Start path is root
    emit pathReady(tmp_tree->getPath(type));

#ifdef DEBUG
    qDebug() << "Number of subtypes:: " << tmp_tree->getTypes(type)->rowCount();
#endif

#ifdef DEBUG
    qDebug() << "SIGNAL: goodsReady connect";
#endif
    /// Send signal goods Ready
    emit goodsReady(tmp_tree->getGoods(type));

#ifdef DEBUG
    qDebug() << "SIGNAL: typesReady connect";
#endif
    /// Send start path subcategories
    emit typesReady(tmp_tree->getTypes(type));

#ifdef DEBUG
    qDebug() << "SIGNAL: dataReady connect to two tables:";
#endif
    emit dataReady(tmp_tree->getTypes(type),tmp_tree->getGoods(type));
}

void DemoServiceLogic::typeSelected(int id)
{

#ifdef DEBUG
    qDebug() << "IN FUNCTION: typeSelected(" << id << ")";
#endif

    // TODO: when refactoring, make all methods in goodstree using type use typeid (less memory used)
    /// Create good tree
    //GoodsTree *tmp_tree = new GoodsTree(this->db);

    /// Create good type
    GoodsType *tmp_type = new GoodsType(this->db, id);

#ifdef DEBUG
    qDebug() << "SIGNAL: pathReady connect";
#endif
    /// Start path is root
    emit pathReady(tmp_tree->getPath(tmp_type));

#ifdef DEBUG
    qDebug() << "SIGNAL: goodsReady connect";
#endif

    /// Send start path goods

    emit goodsReady(tmp_tree->getGoods(tmp_type));
#ifdef DEBUG
    qDebug() << "SIGNAL: typesReady connect";
#endif
    /// Send start path subcategories
    emit typesReady(tmp_tree->getTypes(tmp_type));

#ifdef DEBUG
    qDebug() << "SIGNAL: dataReady connect to two tables:";
#endif
    /// Send data ready
    emit dataReady(tmp_tree->getTypes(tmp_type),tmp_tree->getGoods(tmp_type));
}

void DemoServiceLogic::getInfoSource()
{
    ///TODO: Change to signal to signal connect
    emit dataSourceNameReady("");
}
void DemoServiceLogic::sendOrder(int id, int contractorId, int sellpointId, QVector<Good> *goods)
{

}
