#!/usr/bin/env python2.5

#
# mTodos
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net

import hildon
import gtk
import osso
import pango
import os
from portrait import FremantleRotation
import mnotes_window
import mnotes_main_window
import sys

class mNotes:
  def __init__(self):
    self.app = hildon.Program()
    self.context = osso.Context('net.khertan.mnotes','2.0.0', False)
    self.app.set_can_hibernate(True)
    self.window_list = None
    self.noteslist = []
    self._manage_theme()

    self.main_window()
    
  def onAbout(self, widget):                                                   
    dialog = gtk.AboutDialog()                                                 
    dialog.set_name("mNotes")                                             
    dialog.set_logo_icon_name("mNotes")                                   
    dialog.set_comments('A Notes Pim Application for Maemo')                      
    dialog.set_version("2.0.0")                                                
    dialog.set_copyright("By Benoit HERVIER (aka Khertan)")                    
    dialog.set_website("http://khertan.net/")                                  
    dialog.connect ("response", lambda d, r: d.destroy())                      
    dialog.show()     

  def _manage_theme(self):
    icons = (( gtk.STOCK_ADD,   "general_add" ),
        ( gtk.STOCK_BOLD,       "general_bold" ),
        ( gtk.STOCK_CLOSE,      "general_close_b" ),
        ( gtk.STOCK_DELETE,     "general_delete" ),
        ( gtk.STOCK_DIRECTORY,  "general_toolbar_folder" ),
        ( gtk.STOCK_FIND,       "general_search" ),
        ( gtk.STOCK_FULLSCREEN, "general_fullsize_b" ),
        ( gtk.STOCK_GO_BACK,    "general_back" ),
        ( gtk.STOCK_GO_FORWARD, "general_forward" ),
        ( gtk.STOCK_GO_UP,      "filemanager_folder_up" ),
        ( gtk.STOCK_GOTO_FIRST, "pdf_viewer_first_page" ),
        ( gtk.STOCK_GOTO_LAST,  "pdf_viewer_last_page" ),
        ( gtk.STOCK_INFO,       "general_information" ),
        ( gtk.STOCK_ITALIC,     "general_italic" ),
        ( gtk.STOCK_JUMP_TO,    "general_move_to_folder" ),
        ( gtk.STOCK_PREFERENCES,"general_settings" ),
        ( gtk.STOCK_REFRESH,    "general_refresh" ),
        ( gtk.STOCK_SAVE,       "notes_save" ),
        ( gtk.STOCK_STOP,       "general_stop" ),
        ( gtk.STOCK_UNDERLINE,  "notes_underline" ),
        ( gtk.STOCK_ZOOM_IN,    "pdf_zoomin" ),
        ( gtk.STOCK_ZOOM_OUT,   "pdf_zoomout" ),
        ( gtk.STOCK_UNDERLINE,  "general_tag"),)
  
    iconfactory = gtk.IconFactory()

    for stock_id, name in icons:
      iconset = gtk.IconSet()
      iconsource = gtk.IconSource()
      iconsource.set_icon_name(name)
      iconset.add_source(iconsource)
      iconfactory.add(stock_id, iconset)
    
    iconset = gtk.IconSet(gtk.gdk.pixbuf_new_from_file('/usr/share/icons/hicolor/48x48/hildon/mnotes-increase_indent.png'))
    iconfactory.add(gtk.STOCK_INDENT,iconset)
    iconfactory.add_default()  
    iconset = gtk.IconSet(gtk.gdk.pixbuf_new_from_file('/usr/share/icons/hicolor/48x48/hildon/mnotes-decrease_indent.png'))
    iconfactory.add(gtk.STOCK_UNINDENT,iconset)
    iconfactory.add_default()  
    iconset = gtk.IconSet(gtk.gdk.pixbuf_new_from_file('/usr/share/icons/hicolor/48x48/hildon/mnotes-link.png'))
    iconfactory.add(gtk.STOCK_EDIT,iconset)
    iconfactory.add_default()  
        
  def destroy_win(self,widget,*data):
    self.window_list.remove(widget)
    if len(self.window_list)==0:
      gtk.main_quit()

  def destroy_and_update_win(self,widget,*data):
    self.main_win.load_notes()
    self.destroy_win(widget)
    self.main_win.hide()
    self.main_win.show()
    
  def main_window(self):
    self.main_win = mnotes_main_window.Window(self)
    self.main_win.connect("destroy", self.destroy_win)
    if self.window_list==None:
      self.window_list = []
    self.window_list.append(self.main_win)
    self.app.add_window(self.main_win)
    
  def note_window(self,uid):
    #Test if already open
    do_open = True
    for win in self.window_list:
      if type(win)==mnotes_window.Window:
        if win.note.uid == uid:
          do_open = False
          break
    if do_open==True:
      w1 = mnotes_window.Window(uid,self)
      w1.connect("destroy", self.destroy_and_update_win)
      if self.window_list==None:
        self.window_list = []
      self.window_list.append(w1)
      self.app.add_window(w1)
    else:
      win.hide()
      win.show()

  
  def apply_prefs(self):
    for w in self.window_list:
      w.apply_prefs()

#  def create_window(self,filepath=None):
#    w1 = mnotes_window.Window(self)
#    w1.connect("destroy", self.destroy_win)
#    if self.window_list==None:
#      self.window_list = []
#    self.window_list.append(w1)
#    self.app.add_window(w1)

if __name__ == "__main__":
  mNotes()
  gtk.gdk.threads_enter()
  gtk.main()
  gtk.gdk.threads_leave()
