#!/usr/bin/env python2.5

#
# mNotes
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net

import os
import icalendar
import uuid
import datetime
import dateutil.tz
import urllib
import urllib2
import mnotes_preferences
import hildon
import gtk
import gobject

NOTES_FOLDER = os.path.expanduser("~")+'/.mnotes/notes/'

class List():    
  def get(self,searched_text=None):
    notes = []
    for d,r,files in os.walk(NOTES_FOLDER):
      for name in files:
        n = Note(name)
        n.load()
        if n.status!='CANCELLED':
          if searched_text==None:
            notes.append((n.updated,n.title,n.uid))
          elif searched_text.lower() in n.content.lower():
            notes.append((n.updated,n.title,n.uid))
             
    notes.sort()
    notes.reverse()
    return notes
  

class Note():
  def __init__(self,uid=None):
    self.title = 'Untitled'
    now = datetime.datetime.now()
    now = now.replace(tzinfo=dateutil.tz.tzlocal())
    self.updated = now
    self.created = now
    self.content = 'Untitled\n'
    self.status = 'NEEDS-ACTION'
    if uid != None:
      self.uid = uid
    else:
      self.uid = str(uuid.uuid4())
    
  def load(self):
    try:
      note = icalendar.Journal()
      #print self.uid
      f = open(NOTES_FOLDER+str(self.uid),'rb')
      note = note.from_string(f.read())
      f.close()
      self.uid = note.get('uid')
      self.created = note.decoded('created')
      self.content = note.decoded('description')
      self.updated = note.decoded('dtstamp')
      self.status = note.decoded('status')
      self.title = self.content.split('\n')[0]
    except StandardError,e:
      print e
      
  def as_string(self):
    note = icalendar.Journal()
    note.set('uid',self.uid)
    note.set('dtstamp',self.updated)
    note.set('created',self.created)
    note.set('summary',self.content.split('\n')[0])    
    note.set('description',self.content)
    note.set('status',self.status)
    return note.as_string()
    
  def from_string(self,s):
    note = icalendar.Journal()
    note = note.from_string(s)
    self.uid = note.get('uid')
    self.created = note.decoded('created')
    self.content = note.decoded('description')
    self.updated = note.decoded('dtstamp')
    self.status = note.decoded('status')
    self.title = self.content.split('\n')[0]
      
  def save(self):
    note = icalendar.Journal()
    note.set('uid',self.uid)
    now = datetime.datetime.now()
    now = now.replace(tzinfo=dateutil.tz.tzlocal())
    note.set('dtstamp',now)
    note.set('created',self.created)
    note.set('summary',self.content.split('\n')[0])    
    note.set('description',self.content)
    note.set('status',self.status)
    try:
      f = open(NOTES_FOLDER+self.uid,'wb')
      f.write(note.as_string())
      f.close()
    except StandardError,e:
      print e
