/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINEVIEW_H
#define TIMELINEVIEW_H

#include <QtCore/QAbstractAnimation>
#include <QtCore/QEasingCurve>
#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QParallelAnimationGroup>
#include <QtCore/QPointF>
#include <QtCore/QPropertyAnimation>
#include <QtCore/QRectF>
#include <QtCore/QRegExp>
#include <QtCore/QSequentialAnimationGroup>
#include <QtCore/QString>
#include <QtCore/QStringList>

#include <QtGui/QFont>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsRectItem>
#include <QtGui/QGraphicsTextItem>

#include <QtDBus>

#include <QMaemo5InformationBox>
#include <location/maemo5gps.h>

#include "backend.h"
#include "applicationItems/lineedit.h"
#include "applicationItems/loader.h"
#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittercheckbox.h"
#include "applicationItems/twittertopbar.h"
#include "applicationItems/twittertweetinfo.h"
#include "urlshortener.h"
#include "location/getiplocation.h"
#include "applicationItems/statuslist.h"

#include "twitpic.h"

/*!
 * \class TimelineView
 *
 * \brief Timeline window with customized widgets.
 */
class TimelineView : public QGraphicsWidget
{
    Q_OBJECT

public:
    TimelineView(void);
    ~TimelineView();  
    void createUi(void);
    void setUpdateMessage(const QString &message);
    void updateTopBar(void);
    int containsUrl(QString message);
    QString getUpdateMessage(void);
    bool getHome(void);

public slots:
    void connectionError(void);
    void urlShorteningError(QString);
    void endLoader(void);
    void startLoader(void);
    void getIPCoordinates(void);
    void getGPSCoordinates(void);
    void setLocationCheckboxFalse(void);
    void changeToTimeline(void);

signals:
    void postUpdate(void);
    void shorteningError(QString);
    void favorite(QString, bool);
    void deleteTweet(QString, int);
    void logout(void);
    void unfollow(QString, bool);
    void done(void);
    void coordinatesOk(void);
    void changeAvatar(QString);
    void showLocationDialog(void);
    void gotGPS(void);
    void addHomeTimelineToScene(StatusList *homeTimeline);
    void addMentionsTimelineToScene(StatusList *mentionsTimeline);
//    void addDMTimelineToScene(StatusList *dmTimeline);
    void removeHomeTimelineFromScene(StatusList *homeTimeline);
    void removeMentionsTimelineFromScene(StatusList *mentionsTimeline);
//    void removeDMTimelineFromScene(StatusList *dmTimeline);
    void moreButtonHome(StatusList *homeTimeline);
    void moreButtonMentions(StatusList *mentionsTimeline);
    void loadMap(void);

private slots:
    void _deleteLoader(void);
    void _emitPostUpdate(void);
    void _exitAnimationFinished(void);
    void _handleNewMessage(QString newMessage);
    void _handleReply(QString newMessage, QString statusId);
    void _emitExposeSignal(void);
    void _createTweetInfo(Tweet*);
    void _backToLogin(void);
    void _emitUnfollow(QString, bool);
    void _emitDelete(QString, int);
    void _emitFavorite(QString, bool);
    void _emitChangeAvatar(QString);
    void _createTimeline(void);

    void _animateHome(void);
    void _animateMentions(void);
//    void _animateDm(void);
    void _animationFinished(void);

    void _changeToTweetInfo(void);

    void _moreButtonHome(void);
    void _moreButtonMentions(void);

    void _showIpLocationInfo(double latitude, double longitude);

    void _openTwitPic();
    void _closeTwitPic(void);
    void _deleteTwitPic(void);

private:
    QAbstractAnimation *_createEntryAnimation(void);
    QAbstractAnimation *_createExitAnimation();
    void _createEntry(void);
    void _createButtons(void);
    void _createTopBar(void);
    void _addOpacityAnim(QParallelAnimationGroup *anim,
                         TwitterApplicationItem *item,
                         int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     TwitterApplicationItem *item,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     QGraphicsView *view,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);

    void _scaleInAnim(TwitterApplicationItem *item);
    void _scaleOutAnim(TwitterApplicationItem *item);
    void _opacityInAnim(TwitterApplicationItem *item);
    void _opacityOutAnim(TwitterApplicationItem *item);

private:
    QAbstractAnimation *_exitAnim;
    QAbstractAnimation *_entryAnim;
    QGraphicsRectItem *_background;
    TwitterButton *_exposeButton;
    Loader *_loader;
    LineEdit *_entryUpdate;

    TwitterButton *_homeButton;
    TwitterButton *_mentionsButton;
//    TwitterButton *_dmButton;

    QGraphicsPixmapItem *_tabShadow;
    bool m_animating;
    bool m_home;
    bool m_mentions;
//    bool m_dm;
    bool m_atHomeTimeline;

    QPointF homePos;
    QPointF mentionsPos;
//    QPointF dmPos;

public:
    TwitterTopBar *_topBar;
    TwitterTweetInfo *_tweetInfo;
    TwitterButton *_updateButton;
    TwitterButton *_logoutButton;
    TwitterButton *_backButton;
    TwitterCheckBox *_locationCheckBox;
    UrlShortener *_urlShortener;
    IpLocation *_ipLocation;
    StatusList *m_homeTimeline;
    StatusList *m_mentionsTimeline;

    TwitPic *m_twitPic;

    QGraphicsView *view2;

    bool isReply;
    QString m_statusId;

    Maemo5GPS *_gpsLocation;
};

#endif // TIMELINEVIEW_H
