
IF( DEFINED CSYNC_BUILD_PATH )
  SET(CSYNC_LIBRARY_PATH ${CSYNC_BUILD_PATH})
  SET(CSYNC_BINARY_DIR ${CSYNC_BUILD_PATH})

  IF(WIN32)
    SET(CSYNC_LIBRARY ${CSYNC_BUILD_PATH}/src/libocsync.dll)
  ELSEIF( APPLE )
    SET(CSYNC_LIBRARY ${CSYNC_BUILD_PATH}/src/libocsync.dylib)
  ELSE()
    SET(CSYNC_LIBRARY ${CSYNC_BUILD_PATH}/src/libocsync.so)
  ENDIF()
ELSE()
  FIND_LIBRARY(CSYNC_LIBRARY NAMES ocsync HINTS $ENV{CSYNC_DIR} /usr/lib)
  message("found ${CSYNC_LIBRARY}")
ENDIF()

#IF(NOT DEFINED CSYNC_INCLUDE_PATH)
  FIND_PATH(CSYNC_INCLUDE_PATH NAMES csync.h HINTS $ENV{CSYNC_DIR} /usr/include/ocsync)
  message("found ${CSYNC_INCLUDE_PATH}")
#ENDIF()


SET(CSYNC_INCLUDE_DIR ${CSYNC_INCLUDE_PATH})

# handle the QUIETLY and REQUIRED arguments and set CSYNC_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Csync DEFAULT_MSG CSYNC_LIBRARY CSYNC_INCLUDE_PATH)

MARK_AS_ADVANCED( CSYNC_INCLUDE_PATH CSYNC_LIBRARY )
