#ifndef CAMERA_THREAD_H
#define CAMERA_THREAD_H

/** \file */

#include <QThread>
#include <string>
#include <iostream>
#include <QTextEdit>
#include <QGraphicsView>
#include <QPushButton>
#include "ocrrequest.h"
#include <FCam/N900.h>
#include "cameraui.h"

class OverlayWidget;
class InfoWidget;

using namespace std;

class CameraThread : public QThread {
    Q_OBJECT;

public:
    string filename;
    CameraThread(OverlayWidget *o, QObject * parent = 0) : QThread(parent) {
        overlay = o;
        keepGoing = true;
    }

public slots:
    void stop() {
        printf("Stopping!\n");
        keepGoing = false;
    }
signals:
    void image_saving(QString filename);
    void image_saved(QString filename);

protected:
    void run();

private:
    bool keepGoing;
    OverlayWidget *overlay;
};

#endif
