#include "minigpsd.h"

static unsigned short odolast = 0, fuellast = 0;

extern struct harley hstat;

static int crc(int *data, int len)
{
    unsigned char crc, dimg;
    unsigned char poly;
    int i;

    crc = 0xff;
    while (len--) {
        dimg = *data++;
        //      printf("%02x ", dimg);
        for (i = 0; i < 8; i++) {
            if (0x80 & dimg) {
                poly = 0x1C;
                if (crc & 0x80)
                    poly = 0x01;
                crc = ((crc << 1) | 1) ^ poly;
            } else {
                poly = 0x00;
                if (crc & 0x80)
                    poly = 0x1D;
                crc = (crc << 1) ^ poly;
            }
            dimg <<= 1;
        }
    }
    //printf("= %02x\n", crc);
    return crc;
}

void calcobd(char *outb, int mstime)
{
    int i, j, x;
    unsigned short y;
    int hex[8];

    i = sscanf(outb, "%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x",
      &hex[0], &hex[1], &hex[2], &hex[3], &hex[4], &hex[5], &hex[6], &hex[7]);

    if (i < 5 || 0xc4 != crc(hex, i))
        return;

    i--;
    x = hex[0] << 24;
    x |= hex[1] << 16;
    x |= hex[2] << 8;
    x |= hex[3];

    y = hex[4] << 8 | hex[5];

    if (x == 0x281b1002) {
        hstat.rpm = y * 250;
    } else if (x == 0x48291002) {
        hstat.vspd = y * 5;
    } else if (x == 0xa8491010) {
        hstat.engtemp = hex[4];
    } else if (x == 0xa83b1003) {
        y = hex[4];
        j = 0;
        if (y)
            while (y >>= 1)
                j++;
        else
            j = -1;
        hstat.gear = j;
    } else if (x == 0x48da4039 && (hex[4] & 0xfc) == 0) {
        hstat.turnsig = hex[4];
    } else if ((x & 0xffffff7f) == 0xa8691006) {
        if (!(x & 0x80)) {
            hstat.odolastval = y;
            hstat.odolastval -= odolast;
	    if( hstat.odolastval < 0 )
	        hstat.odolastval += 65536;
            hstat.odoaccum += hstat.odolastval;
            if (mstime >= hstat.odolastms)
                hstat.odolastms = mstime - hstat.odolastms;
            else
                hstat.odolastms = 100000 + mstime - hstat.odolastms;
            odolast = y;
            hstat.odolastms = mstime;
        } else {
            odolast = 0;
            hstat.odolastms = mstime;
            hstat.odoaccum = 0;
        }
    } else if ((x & 0xffffff7f) == 0xa883100a) {
        if (!(x & 0x80)) {
            hstat.fuellastval = y;
            hstat.fuellastval -= fuellast;
	    if( hstat.fuellastval < 0 )
	        hstat.fuellastval += 65536;
            hstat.fuelaccum += hstat.fuellastval;
            if (mstime >= hstat.fuellastms)
                hstat.fuellastms = mstime - hstat.fuellastms;
            else
                hstat.fuellastms = 100000 + mstime - hstat.fuellastms;
            fuellast = y;
            hstat.fuellastms = mstime;
        } else {
            fuellast = 0;
            hstat.fuellastms = mstime;
            hstat.fuelaccum = 0;
        }
    } else if ((x & 0xffffffff) == 0xa8836112 && (hex[4] & 0xd0) == 0xd0) {
        hstat.full = hex[4] & 0x0f;
    } else if ((x & 0xffffff5d) == 0x483b4000) {
        hstat.neutral = !!(hex[3] & 0x20);    // ! & 0x02
        hstat.clutch = !!(hex[3] & 0x80);
    }

}
