//  Copyright  2011    Karl Wintermmann
//  E-Mail:             karl@rx-51.de
//  Sourcecode is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)


#ifndef MINIDLNA_H
#define MINIDLNA_H

#include <QObject>
#include <QFile>
#include <QTextStream>
#include <QList>
#include <QProcess>
#include "minidlnashare.h"

class MiniDLNA : public QObject
{
    Q_OBJECT
public:
    explicit MiniDLNA(QObject *parent = 0);

    void SetPathToConfFile(QString path);
    //void SetPort(int p);
    //void SetNetworkInterface(QString netint);
    //void SetFriendlyName(QString name);
    //void EnableTiVo(bool choice);
    void AddShare(MiniDLNAShare share);
    void AddShare(QList<MiniDLNAShare> shares);
    void SetShares(QList<MiniDLNAShare> shares);
    QList<MiniDLNAShare> GetShares();
    bool SettingsChanged();
    void AcceptChanges();
    void RollbackChanges();
    void UpdateFromConfFile();

    bool GetServerStatus();
    void StartServer();
    void StopServer();
    void RestartServer();



signals:
    void ServerStatus(bool);
    void settingsChanged(bool);

public slots:

private:
    bool settings_changed;

    QString port;
    QString pathToConfFile;
    QString network_interface;
    QString friendly_name;
    QString db_dir;
    QString log_dir;
    QString album_art_names;
    QString inotify;
    QString enable_tivo;
    QString strict_dlna;
    QString presentation_url;
    QString notify_interval;
    QString serial;
    QString model_number;
    QList<QString> media_dir;

    void ServerCommand(QString cmd);




    bool ReadConfFile();
    bool WriteConfFile();


private slots:


};

#endif // MINIDLNA_H
