/* Miniature - A chess board that goes always with you, ready to let
 * you play and learn wherever you go.
 *
 * Copyright (C) 2009 Dennis Stötzel <kore@meeQ.de>
 *
 *
 * Miniature is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Miniature is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Miniature. If not, see <http://www.gnu.org/licenses/>.
 */

#include "rook.h"
#include <position.h>

namespace Miniature
{

bool MRook::hasFinishedLoading = false;
QSvgRenderer MRook::blackRenderer;
QSvgRenderer MRook::whiteRenderer;

MRook::MRook(MColour colour)
: MPiece(colour, ROOK),
  castle(true)
{
    loadFromSvgFile();
}

MRook::~MRook()
{}

QList<QPoint> MRook::getPossibleSquares(const MPosition &pos, const QPoint &origin) const
{
    QList<QPoint> possibleSquares;

    // north
    int i = 1;
    while (origin.y() + i < pos.getHeight())
    {
        possibleSquares.append(QPoint(origin.x(), origin.y() + i));
        ++i;
    }

    // east
    i = 1;
    while (origin.x() + i < pos.getWidth())
    {
        possibleSquares.append(QPoint(origin.x() + i, origin.y()));
        ++i;
    }

    // south
    i = 1;
    while (origin.y() - i >= 0)
    {
        possibleSquares.append(QPoint(origin.x(), origin.y() - i));
        ++i;
    }

    // west
    i = 1;
    while (origin.x() - i >= 0)
    {
        possibleSquares.append(QPoint(origin.x() - i, origin.y()));
        ++i;
    }

    for (QList<QPoint>::iterator iter = possibleSquares.begin();
         iter != possibleSquares.end();
         ++iter)
    {
        //std::cout << "    (" << (*iter).x() << ", " << (*iter).y() << "), " << std::endl;
    }

    return possibleSquares;
}

void MRook::hasMoved()
{
    castle = false;
}

bool MRook::canCastle() const
{
    return castle;
}

void MRook::loadFromSvgFile(int pieceSize)
{
    if (!MRook::hasFinishedLoading)
    {
        MRook::blackRenderer.load(QString(":pieces/black/rook.svg"));
        MRook::whiteRenderer.load(QString(":pieces/white/rook.svg"));
        MRook::hasFinishedLoading = true;
    }

    applyRenderer((MRook::BLACK == getColour() ? MRook::blackRenderer
                                               : MRook::whiteRenderer), pieceSize);
}

QChar MRook::getLetter() const
{
    return QChar('R');
}

}
