/*
 * MidiJ - Remote MIDI controller for DJs
 * Copyright (C) 2010  Amilcar Santos <amilcar.santos@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "SettingsDialog.h"
#include "gui/GuiUtils.h"
#include <QtGui>

SettingsDialog::SettingsDialog()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
#endif // Q_WS_MAEMO_5

	ui.setupUi(this);
	m_schemeSelector = NULL;
	if (true) // TODO zzzz; auto-detect orientation
	{
		// switch to portrait mode
		QHBoxLayout* buttonBoxLayout = new QHBoxLayout();
		ui.buttonBoxSpacer->changeSize(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
		ui.buttonBoxLayout->removeItem(ui.buttonBoxSpacer);
#ifdef BUTTONBOXSPACER
		buttonBoxLayout->addItem(ui.buttonBoxSpacer);
#else
		_delete(ui.buttonBoxSpacer);
#endif
		ui.verticalLayout->removeWidget(ui.buttonBox);
		buttonBoxLayout->addWidget(ui.buttonBox);

		ui.gridLayout->removeItem(ui.buttonBoxLayout);
		_delete(ui.buttonBoxLayout);
		ui.gridLayout->addItem(buttonBoxLayout, 1, 0, 1, 1);
	}
}

SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::initScheme(QIcon icon, const QList<SchemeGuiHeader*>& schemeList, const QString& currentScheme)
{
	m_defaultIcon = icon;
	QStandardItemModel *model = new QStandardItemModel(0, 1, this);
	QStandardItem* selectedItem = NULL;
	foreach(SchemeGuiHeader* scheme, schemeList)
	{
    	QStandardItem *item = new QStandardItem(scheme->description());
    	item->setIcon(scheme->icon48(m_defaultIcon));
    	item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
    	item->setData(scheme->id(), Qt::UserRole);
    	model->appendRow(item);
    	if (scheme->id() == currentScheme)
    		selectedItem = item;
	}
	model->sort(0);
	m_schemeSelector = new QMaemo5ListPickSelector();
	m_schemeSelector->setModel(model);
	m_schemeSelector->setCurrentIndex(selectedItem == NULL? 0: selectedItem->row());
    ui.schemeButton->setPickSelector(m_schemeSelector);
}

void SettingsDialog::initMidiConnection(const QStringList& connections, const QString& currentConnection)
{
	QStandardItemModel* model = new QStandardItemModel(0, 1, this);
	int currentIndex = 0;
    foreach (QString midiConnection, connections)
    {
    	QStandardItem *item = new QStandardItem(midiConnection);
    	item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
    	item->setEditable(false); // prevent editing of the item
    	model->appendRow(item);
    	if (currentConnection == midiConnection)
    		currentIndex = item->row();
    }

    QMaemo5ListPickSelector *selector1 = new QMaemo5ListPickSelector();
    selector1->setModel(model);
    selector1->setCurrentIndex(currentIndex);
    // not setting the current index means that the value is empty.
    ui.midiConnButton->setPickSelector(selector1);
}

void SettingsDialog::launchHomepage()
{
	QDesktopServices::openUrl(QUrl(ui.homepageButton->valueText()));
	reject();
}

QString SettingsDialog::selectedScheme()
{
	if (m_schemeSelector)
	{
		QModelIndex currentIndex = m_schemeSelector->model()->index(m_schemeSelector->currentIndex(), 0);
		if (currentIndex.isValid())
			return m_schemeSelector->model()->data(currentIndex, Qt::UserRole).toString();
	}
	return QString();
}

QString SettingsDialog::midiConnection()
{
	return ui.midiConnButton->valueText();
}
