/****************************************************************/
/*      Router-scripts MIDI controller script v1.00             */
/*          Copyright (C) 2011, Amilcar Santos                  */
/*      but feel free to tweak this to your heart's content!    */
/*      For MidiJ version 0.1.x                                 */
/****************************************************************/
function Router() {}

//    <Control name="Internal Mode Button A" channel="8" event_type="Note On" control="4" />
//    <Control name="Relative Mode Button A" channel="8" event_type="Note On" control="5" />
//    <Control name="Key Lock Button A" channel="8" event_type="Note On" control="6" />

//    <Control name="Add To Prepare Button" channel="8" event_type="Note On" control="68" />
//    <Control name="Recently Played Button" channel="8" event_type="Note On" control="70" />
//    <Control name="Scroll Left Button" channel="8" event_type="Note On" control="74" />
//    <Control name="Scroll Right Button" channel="8" event_type="Note On" control="75" />



    //<Control name="Auto Loop Save or Lock Container A" channel="8" event_type="Note On" control="83" />
//    <Control name="Clear Loop Button A" channel="8" event_type="Note On" control="84" />
 //   <Control name="Prev Loop Button A" channel="8" event_type="Note On" control="85" />
 //   <Control name="Next Loop Button A" channel="8" event_type="Note On" control="86" />
   // <Control name="Previous Track A" channel="8" event_type="Note On" control="96" />
  //  <Control name="Autoplay Button A" channel="8" event_type="Note On" control="97" />
  //  <Control name="Next Track A" channel="8" event_type="Note On" control="98" />
   // <Control name="Config Button" channel="8" event_type="Note On" control="107" />
   // <Control name="Set Temp Cue Left Button" channel="8" event_type="Note On" control="108" />
   // <Control name="Jump Temp Cue Left Button" channel="8" event_type="Note On" control="109" />
    // <Control name="Censor Button A" channel="8" event_type="Note On" control="110" />
    // <Control name="Master Gain Knob" channel="8" event_type="Control Change" control="3" />
    // <Control name="Internal Mode Button B" channel="9" event_type="Note On" control="4" />
    // <Control name="Relative Mode Button B" channel="9" event_type="Note On" control="5" />
    // <Control name="Key Lock Button B" channel="9" event_type="Note On" control="6" />
    // <Control name="Play Reverse B" channel="9" event_type="Note On" control="20" />
    // <Control name="Tap Tempo B" channel="9" event_type="Note On" control="21" />
    // <Control name="Play Forward B" channel="9" event_type="Note On" control="22" />

    //<Control name="Auto Loop Save or Lock Container B" channel="9" event_type="Note On" control="83" />
    // <Control name="Clear Loop Button B" channel="9" event_type="Note On" control="84" />
    // <Control name="Prev Loop Button B" channel="9" event_type="Note On" control="85" />
    // <Control name="Next Loop Button B" channel="9" event_type="Note On" control="86" />
    // <Control name="Previous Track B" channel="9" event_type="Note On" control="96" />
    // <Control name="Autoplay Button B" channel="9" event_type="Note On" control="97" />
    // <Control name="Next Track B" channel="9" event_type="Note On" control="98" />
    // <Control name="Set Temp Cue Right Button" channel="9" event_type="Note On" control="108" />
    // <Control name="Jump Temp Cue Right Button" channel="9" event_type="Note On" control="109" />
    // <Control name="Censor Button B" channel="9" event_type="Note On" control="110" />



//----------   Customization variables ----------
Router.debug = false;
/*Router.loopModeControls = {   1:{ 0x48:"Auto Loop Half Button ", 0x4A:"Auto Loop Half Button ", 0x4C:"Auto Loop Two Button ", 0x4E:"Auto Loop Two Button ",
                                  0x4F:"Auto Loop Fourth Button ", 0x51:"Auto Loop Fourth Button ", 0x53:"Auto Loop One Button ", 0x55:"Auto Loop One Button " }, // Auto loop mode
                              2:{ 0x48:"Loop In Adjust Button ", 0x4A:"Loop In Adjust Button ", 0x4C:"Loop In Adjust Button ", 0x4E:"Loop In Adjust Button ",
                                  0x4F:"Loop Out Adjust Button ", 0x51:"Loop Out Adjust Button ", 0x53:"Loop Out Adjust Button ", 0x55:"Loop Out Adjust Button " }, // Manual loop mode
                              3:{ 0x48:"Auto Loop Eight Button ", 0x4A:"Auto Loop Eight Button ", 0x4C:"Auto Loop ThirtyTwo Button ", 0x4E:"Auto Loop ThirtyTwo Button ",
                                  0x4F:"Auto Loop One Button ", 0x51:"Auto Loop One Button ", 0x53:"Auto Loop Sixteen Button ", 0x55:"Auto Loop Sixteen Button " } };
*/
Router.loopModeControls = {   1:{ 0x48:"Auto Loop Half Button ###",  0x4A:"Auto Loop Half Button ###",  0x4C:"Auto Loop Fourth Button ###", 0x4E:"Auto Loop Fourth Button ###",
                                  0x4F:"Auto Loop Two Button ###",   0x51:"Auto Loop Two Button ###",   0x53:"Auto Loop One Button ###",    0x55:"Auto Loop One Button ###" }, // Auto loop mode
                              2:{ 0x48:"Auto Loop Eight Button ###", 0x4A:"Auto Loop Eight Button ###", 0x4C:"Auto Loop One Button ###",    0x4E:"Auto Loop One Button ###",
                                  0x4F:"Auto Loop ThirtyTwo Button ###", 0x51:"Auto Loop ThirtyTwo Button ###", 0x53:"Auto Loop Sixteen Button ###", 0x55:"Auto Loop Sixteen Button ###" }, 
                              3:{ 0x48:"Loop In Adjust Button ###",  0x4A:"Loop In Adjust Button ###",  0x4C:"Loop In Adjust Button ###",   0x4E:"Loop In Adjust Button ###",
                                  0x4F:"Loop Out Adjust Button ###", 0x51:"Loop Out Adjust Button ###", 0x53:"Loop Out Adjust Button ###",  0x55:"Loop Out Adjust Button ###" } }; // Manual loop mode

Router.trigModeControls = {   1:{ 0x48:"Trigger Cue Point Button ###0", 0x4A:"Trigger Cue Point Button ###0", 0x4C:"Trigger Cue Point Button ###2", 0x4E:"Trigger Cue Point Button ###2",
                                  0x4F:"Trigger Cue Point Button ###1", 0x51:"Trigger Cue Point Button ###1", 0x53:"Trigger Cue Point Button ###4", 0x55:"Trigger Cue Point Button ###4" }, // Auto loop mode
                              2:{ 0x48:"Set Cue Point Button ###0",     0x4A:"Set Cue Point Button ###0",     0x4C:"Set Cue Point Button ###2",     0x4E:"Set Cue Point Button ###2",
                                  0x4F:"Set Cue Point Button ###1",     0x51:"Set Cue Point Button ###1",     0x53:"Set Cue Point Button ###4",     0x55:"Set Cue Point Button ###4" }, 
                              3:{ 0x48:"Trigger Cue Point Button ###0", 0x4A:"Trigger Cue Point Button ###0", 0x4C:"Trigger Cue Point Button ###2", 0x4E:"Trigger Cue Point Button ###2",
                                  0x4F:"Trigger Cue Point Button ###1", 0x51:"Trigger Cue Point Button ###1", 0x53:"Trigger Cue Point Button ###4", 0x55:"Trigger Cue Point Button ###4" } }; // Manual loop mode

Router.vinylB14Mode = 4; // 0 = BROWSE, 1 = IMPORT, 2 = REVIEW, 3 = PREPARE, 4 = (off)

Router.vinylScrollButton = "";


Router.init = function(device) {
	if (Router.debug) print("Router.init() - MidiJ Version", engine.getValue("[MidiJ]", "version"));
}


//get channel id from mappings
Router.channelFromMap = function(control) {
	return Number(gateway.mapping.getValue("midi/Control["+control+"]", "channel")) - 1;
}

//get control id from mappings
Router.controlFromMap = function(control) {
	return Number(gateway.mapping.getValue("midi/Control["+control+"]", "control"));
}


Router.noteOnOff = function (status, value, controlDeck) {
	var channel = 0;
	var channel = Router.channelFromMap(controlDeck);
	var byte2 = Router.controlFromMap(controlDeck);
	var byte1 = 0;
	if ((status & 0xF0) == 0x90)
		byte1 = 0x90 + channel;
	else
		byte1 = 0x80 + channel;
	// send to PC
	gateway.midi.sendShortMsg(byte1, byte2, value);
}

Router.noteOnOffDeck = function (status, value, controlDeckA, controlDeckB) {
	var byte2 = 0;
	var channel = 0;
	if (StantonSCS3d.deck == 1) {
		if (Router.debug) print("Router.noteOnDeck: processing deck A");
		channel = Router.channelFromMap(controlDeckA);
		byte2 = Router.controlFromMap(controlDeckA);
	} else {
		if (Router.debug) print("Router.noteOnDeck: processing deck B");
		channel = Router.channelFromMap(controlDeckB);
		byte2 = Router.controlFromMap(controlDeckB);
	}
	var byte1 = 0;
	if ((status & 0xF0) == 0x90)
		byte1 = 0x90 + channel;
	else
		byte1 = 0x80 + channel;
	// send to PC
	gateway.midi.sendShortMsg(byte1, byte2, value);
}

Router.controlChange = function (validMode, value, controlDeck) {
	if (validMode != "") {
	    if (StantonSCS3d.currentDeckMode() != validMode)
	    	return;
	}

	var channel = Router.channelFromMap(controlDeck);
	var byte2 = Router.controlFromMap(controlDeck);
	var byte1 = 0xB0 + channel;
	// send to PC
	gateway.midi.sendShortMsg(byte1, byte2, value);
}

Router.B11 = function (channel, control, value, status) {
	var currentMode = StantonSCS3d.mode_store["[Channel"+StantonSCS3d.deck+"]"];
	if (currentMode == "vinyl" ) {
		Router.noteOnOff(status, value, "Load Left Button");
	}
}

Router.B12 = function (channel, control, value, status) {
	var currentMode = StantonSCS3d.mode_store["[Channel"+StantonSCS3d.deck+"]"];
	if (currentMode == "vinyl" ) {
		Router.noteOnOff(status, value, "Load Right Button");
	}
}


Router.playButton = function (channel, control, value, status) {
	Router.noteOnOffDeck(status, value, "Play Forward A", "Play Forward B");
//	Router.noteOnOffDeck(status, value, "Set Temp Cue Left Button", "Set Temp Cue Right Button");
}

Router.cueButton = function (channel, control, value, status) {
	Router.noteOnOffDeck(status, value, "Jump Temp Cue Left Button", "Jump Temp Cue Right Button");
}

Router.syncButton = function (channel, control, value, status) {
	Router.noteOnOffDeck(status, value, "Censor Button A", "Censor Button B");
}

Router.tapButton = function (channel, control, value, status) {
	Router.noteOnOffDeck(status, value, "Instant Double Right Button", "Instant Double Left Button");
}


Router.gain = function (channel, control, value, status) {
	var channel = 0;
	var controlDeck = "";
	if (StantonSCS3d.deck == 1) {
		if (Router.debug) print("Router.gain: processing deck A");
		controlDeck = "Song Gain Knob A";
	} else {
		if (Router.debug) print("Router.gain: processing deck B");
		controlDeck = "Song Gain Knob B";
	}
//	channel = Router.channelFromMap(controlDeck);
//	byte2 = Router.controlFromMap(controlDeck);
//	var byte1 = 0xB0 + channel;
//	// send to PC
//	gateway.midi.sendShortMsg(byte1, byte2, value);
	Router.controlChange("", value, controlDeck);
}

/*
Router.syncButton = function (channel, control, value, status) {
	if ((status & 0xF0) == 0x90) {    // If button down
		var byte2 = 0;
		if (StantonSCS3d.deck == 1) {
			if (Router.debug) print("Router.playButton: processing deck A");
			channel = Router.channelFromMap("Play Forward A");
			byte2 = Router.controlFromMap("Play Forward A");
		} else {
			if (Router.debug) print("Router.playButton: processing deck B");
			channel = Router.channelFromMap("Play Forward B");
			byte2 = Router.controlFromMap("Play Forward B");
//			channel = eval(sink.mapping.getValue("midi/Control[Play Forward B]", "channel")) - 1;
//			byte2 = sink.mapping.getValue("midi/Control[Play Forward B]", "control");
		}
		var byte1 = 0x90 + channel;
		// send to PC
		gateway.midi.sendShortMsg(byte1, byte2, value);
	}
}

*/

Router.S3absolute = function (channel, control, value, status) {
	// FX mode
	Router.controlChange("fx", value, "Song Gain Knob A");
}

Router.S4absolute = function (channel, control, value, status) {
	// FX mode
	Router.controlChange("fx", value, "Master Gain Knob");
	
	if (StantonSCS3d.currentDeckMode() == "vinyl") {
		var loopControl = "";
		// button Up or Down....
		if (Router.debug) print("Router.SurfaceButtonB5: B5 touch value = " + value);
		if (value > 70)
			loopControl = "Scroll Up Button";
		if (value < 50)
			loopControl = "Scroll Down Button";
		if (loopControl != Router.vinylScrollButton)
		{
			if (loopControl == "") {
				// release button
				status = 0x80;
				value = 0;
				loopControl = Router.vinylScrollButton;
				Router.vinylScrollButton = "";
			} else {
				// press button
				status = 0x90;
				value = 0x7f;
				Router.vinylScrollButton = loopControl;
			}
			Router.noteOnOff(status, value, loopControl);
		}
	}
}

Router.S5absolute = function (channel, control, value, status) {
	// FX mode
	Router.controlChange("fx", value, "Song Gain Knob B");
}



Router.B1touch = function (channel, control, value, status) {
	if (StantonSCS3d.currentDeckMode() == "eq") {
		// EQ mode
		Router.noteOnOffDeck(status, value, "Play Reverse A", "Play Reverse B");
	}
}

Router.B2touch = function (channel, control, value, status) {
	var loopControl = "";
	switch (StantonSCS3d.currentDeckMode()) {
		case "loop3": //XXX 2":
			// manual loop
			loopControl = "Reloop Button ";
			break;
		case "loop":
		case "loop2": //XXX 3":
			// Auto loop
			loopControl = "Auto Loop Four Button ";
			break;
		case "eq":
			// EQ mode
			Router.noteOnOffDeck(status, value, "Tap Tempo A", "Tap Tempo B");
			return;
		case "vinyl":
			// button Up or Down....
			if (Router.debug) print("Router.SurfaceButtonB5: B5 touch value = " + value);
			if (value > 70)
				loopControl = "Scroll Up Button";
			if (value < 50)
				loopControl = "Scroll Down Button";
			if (loopControl != "")
			{
				if ((status & 0xF0) == 0x90) {
					value = 0x7f;
					Router.vinylScrollButton = loopControl;
				} else {
					value = 0;
					Router.vinylScrollButton = "";
				}
					
				Router.noteOnOff(status, value, loopControl);
			}
			return;
		default:
			// Mode not supported
			if (Router.debug) print("Router.SurfaceButtonB5: Mode not supported [" + currentMode + "]");
			return;
	}
	// add the deck
	if (StantonSCS3d.deck == 1) {
		loopControl = loopControl + "A";
	} else {
		loopControl = loopControl + "B";
	}
	if (Router.debug) print("Router.SurfaceButton: processing " + loopControl);
	var channel = Router.channelFromMap(loopControl);
	var byte1 = (status & 0xF0) + channel;
	var byte2 = Router.controlFromMap(loopControl);
	// send to PC
	gateway.midi.sendShortMsg(byte1, byte2, value);
}


Router.B3touch = function (channel, control, value, status) {
	if (StantonSCS3d.currentDeckMode() == "eq") {
		// EQ mode
		Router.noteOnOffDeck(status, value, "Play Forward A", "Play Forward B");
	}
}



Router.SurfaceButton = function (channel, control, value, status) {
/*XXX	if ((status & 0xF0) == 0x90) {    // If button down
		var byte2 = control;
		if (StantonSCS3d.deck == 1) {
			if (Router.debug) print("Router.SurfaceButton: processing deck A");
			channel = Router.channelFromMap("Play Forward A");
		} else {
			if (Router.debug) print("Router.SurfaceButton: processing deck B");
			channel = Router.channelFromMap("Play Forward B");
		}
		var byte1 = 0x90 + channel;
		// send to PC
		gateway.midi.sendShortMsg(byte1, byte2, value);
	}*/
	var currentMode = StantonSCS3d.mode_store["[Channel"+StantonSCS3d.deck+"]"];
	if (currentMode.substring(0,4) != "loop" &&
		currentMode.substring(0,4) != "trig")
		return;

	var index = currentMode.charAt(currentMode.length-1);
	if (index != "2" && index != "3") index = "1";
	// get the loop control name
	var modeControl;
	if (currentMode.substring(0,4) == "loop")
		modeControl = Router.loopModeControls[index][control];
	else
		modeControl = Router.trigModeControls[index][control];
	// add the deck
	if (StantonSCS3d.deck == 1) {
		modeControl = modeControl.replace("###", "A");
	} else {
		modeControl = modeControl.replace("###", "B");
	}
	if (Router.debug) print("Router.SurfaceButton: processing " + modeControl);
	var channel = Router.channelFromMap(modeControl);
	var byte1 = (status & 0xF0) + channel;
	var byte2 = Router.controlFromMap(modeControl);
	// send to PC
	gateway.midi.sendShortMsg(byte1, byte2, value);
}


Router.B13 = function (channel, control, value, status) {
	switch(StantonSCS3d.currentDeckMode())
	{
	case "loop": // FIXME "loop2" ??
		// Auto Loop Mode (change from either short to long loop lengths)
		Router.noteOnOffDeck(status, value, "Prev Loop Button A", "Prev Loop Button B");
		break;
	case "vinyl":
		Router.noteOnOff(status, value, "Tab Focus Button");
		break;
	}
}

Router.B14 = function (channel, control, value, status) {
	switch(StantonSCS3d.currentDeckMode())
	{
	case "loop": // FIXME "loop2" ??
		// Auto Loop Mode (change from either short to long loop lengths)
		Router.noteOnOffDeck(status, value, "Next Loop Button A", "Next Loop Button B");
		break;
	case "vinyl":
		if ((status & 0xF0) == 0x90) // Button press
		{
			// loop vinylB14Mode
			if (Router.vinylB14Mode >= 4)
				Router.vinylB14Mode = 0;
			else
				Router.vinylB14Mode = Router.vinylB14Mode + 1;
		}
		switch (Router.vinylB14Mode)
		{
		case 0:
			Router.noteOnOff(status, value, "Import Button");
			break;
		case 1:
			Router.noteOnOff(status, value, "Browse Button");
			break;
		case 2:
			Router.noteOnOff(status, value, "Recently Played Button");
			break;
		case 3:
			Router.noteOnOff(status, value, "Prepare Button");
			break;
		case 4:
			// send "prepare" again to turn off
			Router.noteOnOff(status, value, "Prepare Button");
			break;
		default:
			// what tha hell??
			Router.noteOnOff(status, value, "Browse Button");
			Router.vinylB14Mode = 1; 
			break;
		}
		
		break;
	}
}


Router.C1touch = function (channel, control, value, status) {
	if (Router.debug) print("Router.C1touch value: " + value);
	if (value < 50 && value > 15)
		Router.noteOnOff(status, 0x7f, "Scroll Left Button");
	else if (value < 110 && value > 80)
		Router.noteOnOff(status, value, "Scroll Right Button");
	
}
