/*
 *  Microfeed - Backend for accessing feed-based services (unstable providers)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#define _XOPEN_SOURCE
#define _BSD_SOURCE
#define _GNU_SOURCE

#include <microfeed-provider/microfeedfeed.h>
#include <microfeed-common/microfeedmisc.h>
#include <microfeed-common/microfeedprotocol.h>
#include <microfeed-provider/microfeedhttp.h>
#include <microfeed-provider/microfeedjson.h>

#include "dummy.h"

#include <stdio.h>
#include <string.h>

static MicrofeedError* update_feed(MicrofeedFeed* feed, int user_initiated, void* user_data);

MicrofeedFeedCallbacks contacts_callbacks = {
	NULL, /* destroy */
	update_feed,
	NULL, /* modify_item */
	NULL /* download_item_data */
};

static MicrofeedError* update_feed(MicrofeedFeed* feed, int user_initiated, void* user_data) {
	static int number = 1;
	
	char nick[1024];
	char name[1024];
	MicrofeedItem* item;
	
	snprintf(nick, 1024, "friend-%d", number);
	snprintf(name, 1024, "Friend %d", number++);
	item = microfeed_item_new_with_status(nick, time(NULL), MICROFEED_ITEM_STATUS_NEW);
	microfeed_item_set_property(item, MICROFEED_ITEM_PROPERTY_NAME_USER_NICK, nick);
	microfeed_item_set_property(item, MICROFEED_ITEM_PROPERTY_NAME_USER_NAME, name);

	microfeed_feed_replace_item(feed, item);
	microfeed_item_free(item);
	
	return NULL;
}
