/*
 *  Microfeed - Backend for accessing feed-based services (unstable providers)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef TWITTER_H
#define TWITTER_H

#include <microfeed-common/microfeedmisc.h>
#include <microfeed-provider/microfeedpublisher.h>
#include <microfeed-provider/microfeedhttp.h>
#include <microfeed-provider/microfeederror.h>

#define PROVIDER_ID_TWITTER "org.microfeed.Provider.Twitter"

/* contacts.c */
extern MicrofeedFeedCallbacks contacts_callbacks;

/* feed.c */
extern MicrofeedFeedCallbacks overview_feed_callbacks;
extern MicrofeedFeedCallbacks feed_callbacks;

/* common.c */
void do_authentication(MicrofeedPublisher* publisher, MicrofeedHttp* http);
MicrofeedError* check_if_error(MicrofeedJson* json);

#endif /*TWITTER_H_*/
