/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.midp.examples.simpledemo;

import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import org.microemu.midp.examples.simpledemo.BaseExamplesForm;
import org.microemu.midp.examples.simpledemo.HasRunnable;
import org.microemu.midp.examples.simpledemo.SimpleDemoMIDlet;

public final class GameCanvasPanel
extends GameCanvas
implements CommandListener,
HasRunnable {
    private static final Command neCommand = new Command("3 NE Move", 8, 1);
    private static final Command nwCommand = new Command("1 NW Move", 8, 2);
    private static final Command seCommand = new Command("9 SE Move", 8, 3);
    private static final Command swCommand = new Command("7 SW Move", 8, 4);
    private boolean cancel = false;
    private boolean moving = true;
    private int moveX = 2;
    private int moveY = 2;
    private int posX = 0;
    private int posY = 0;
    private int ballMoveX = 2;
    private int ballMoveY = -3;
    private int ballPosX = 15;
    private int ballPosY = 15;
    private int ballColor = 5673456;
    private Random ballRandom = new Random();
    private Runnable timerTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!GameCanvasPanel.this.cancel) {
                if (GameCanvasPanel.this.moving && GameCanvasPanel.this.isShown()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (GameCanvasPanel.this.moveX > 0) {
                            if (GameCanvasPanel.this.posX >= 20) {
                                GameCanvasPanel.this.posX = 0;
                            }
                        } else if (GameCanvasPanel.this.posX < 0) {
                            GameCanvasPanel.this.posX = 20;
                        }
                        if (GameCanvasPanel.this.moveY > 0) {
                            if (GameCanvasPanel.this.posY >= 20) {
                                GameCanvasPanel.this.posY = 0;
                            }
                        } else if (GameCanvasPanel.this.posY < 0) {
                            GameCanvasPanel.this.posY = 20;
                        }
                        GameCanvasPanel.this.posX += GameCanvasPanel.this.moveX;
                        GameCanvasPanel.this.posY += GameCanvasPanel.this.moveY;
                    }
                    GameCanvasPanel.this.paintScreen();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
    };
    protected boolean fullScreenMode = false;
    protected static final Command fullScreenModeCommand = new Command("Full Screen", 8, 5);

    public GameCanvasPanel() {
        super(false);
        super.setTitle("Game Canvas Panel");
        this.addCommand(BaseExamplesForm.backCommand);
        this.addCommand(fullScreenModeCommand);
        this.setCommandListener(this);
        this.addCommand(neCommand);
        this.addCommand(nwCommand);
        this.addCommand(seCommand);
        this.addCommand(swCommand);
    }

    public void startRunnable() {
        this.cancel = false;
        Thread thread = new Thread(this.timerTask, "CanvasPanelThread");
        thread.start();
    }

    public void stopRunnable() {
        this.cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command c, Displayable d) {
        if (d == this) {
            GameCanvasPanel gameCanvasPanel = this;
            synchronized (gameCanvasPanel) {
                if (c == nwCommand) {
                    this.moveX = -1;
                    this.moveY = -1;
                    this.moving = true;
                } else if (c == neCommand) {
                    this.moveX = 1;
                    this.moveY = -1;
                    this.moving = true;
                } else if (c == swCommand) {
                    this.moveX = -1;
                    this.moveY = 1;
                    this.moving = true;
                } else if (c == seCommand) {
                    this.moveX = 1;
                    this.moveY = 1;
                    this.moving = true;
                }
            }
        }
        if (d == this) {
            if (c == BaseExamplesForm.backCommand) {
                SimpleDemoMIDlet.showMenu();
            } else if (c == fullScreenModeCommand) {
                this.setFullScreenMode(!this.fullScreenMode);
                this.repaint();
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int actionCode = this.getGameAction(keyCode);
        if (keyCode == 49) {
            this.moveX = -1;
            this.moveY = -1;
            this.moving = true;
        } else if (keyCode == 50) {
            this.moveX = 0;
            this.moveY = -1;
            this.moving = true;
        } else if (keyCode == 51) {
            this.moveX = 1;
            this.moveY = -1;
            this.moving = true;
        } else if (keyCode == 52) {
            this.moveX = -1;
            this.moveY = 0;
            this.moving = true;
        } else if (keyCode == 54) {
            this.moveX = 1;
            this.moveY = 0;
            this.moving = true;
        } else if (keyCode == 55) {
            this.moveX = -1;
            this.moveY = 1;
            this.moving = true;
        } else if (keyCode == 56) {
            this.moveX = 0;
            this.moveY = 1;
            this.moving = true;
        } else if (keyCode == 57) {
            this.moveX = 1;
            this.moveY = 1;
            this.moving = true;
        } else if (keyCode == 53) {
            this.setFullScreenMode(!this.fullScreenMode);
            this.repaint();
        } else if (keyCode == 35) {
            this.moving = !this.moving;
        } else if (actionCode == 1) {
            if (this.ballMoveY > 0) {
                this.ballMoveY = -this.ballMoveY;
            }
        } else if (actionCode == 6) {
            if (this.ballMoveY < 0) {
                this.ballMoveY = -this.ballMoveY;
            }
        } else if (actionCode == 2) {
            if (this.ballMoveX > 0) {
                this.ballMoveX = -this.ballMoveX;
            }
        } else if (actionCode == 5) {
            if (this.ballMoveX < 0) {
                this.ballMoveX = -this.ballMoveX;
            }
        } else if (keyCode == 48) {
            SimpleDemoMIDlet.showMenu();
        } else if (this.fullScreenMode) {
            this.setFullScreenMode(false);
        }
    }

    private void paintScreen() {
        int pos;
        Graphics g = this.getGraphics();
        int width = this.getWidth();
        int height = this.getHeight();
        g.setGrayScale(255);
        g.fillRect(0, 0, width, height);
        g.setColor(5673456);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setGrayScale(0);
        g.drawRect(2, 2, width - 5, height - 5);
        for (pos = this.posX; pos < width - 5; pos += 20) {
            g.drawLine(3 + pos, 3, 3 + pos, height - 4);
        }
        for (pos = this.posY; pos < height - 5; pos += 20) {
            g.drawLine(3, 3 + pos, width - 4, 3 + pos);
        }
        String text = width + " x " + height;
        Font f = g.getFont();
        int w = f.stringWidth(text) + 4;
        int h = 2 * f.getHeight() + 4;
        int arcWidth = w;
        int arcHeight = h;
        g.setColor(0xFFCC11);
        g.drawRoundRect((width - w) / 2, (height - h) / 2, w, h, arcWidth, arcHeight);
        g.setColor(0xFFEE99);
        g.fillRoundRect((width - w) / 2, (height - h) / 2, w, h, arcWidth, arcHeight);
        g.setColor(0xBB5500);
        g.drawString(text, width / 2, (height - f.getHeight()) / 2, 17);
        g.setColor(this.ballColor);
        g.fillRoundRect(this.ballPosX - 4, this.ballPosY - 4, 8, 8, 8, 8);
        this.ballPosX += this.ballMoveX;
        this.ballPosY += this.ballMoveY;
        boolean changeColor = false;
        if (this.ballPosX < 4 || this.ballPosX > width - 4) {
            this.ballMoveX = -this.ballMoveX;
            changeColor = true;
        }
        if (this.ballPosY < 4 || this.ballPosY > height - 4) {
            this.ballMoveY = -this.ballMoveY;
            changeColor = true;
        }
        if (changeColor) {
            this.ballColor = this.ballRandom.nextInt(255) + (this.ballRandom.nextInt(255) << 8) + (this.ballRandom.nextInt(255) << 16);
        }
        this.flushGraphics();
    }

    public void setFullScreenMode(boolean mode) {
        this.fullScreenMode = mode;
        super.setFullScreenMode(mode);
    }
}

