#include <QtCore>
#include <QtGui>
#include "miano.h"
#include "math.h"
#include "gst/gst.h"




Miano::Miano(QMainWindow *parent) {
	octave = 0;
	setupUi(this);
	setupEffect();
	sink = gst_element_factory_make("autoaudiosink", "sink");	
	pipeline = gst_pipeline_new("player");
	source = gst_element_factory_make("filesrc", "source");
	decode = gst_element_factory_make("ffdec_mp3", "decoder");
	convert = gst_element_factory_make("audioconvert", "convert1");
	convert2 = gst_element_factory_make("audioconvert", "convert2");
	speed = gst_element_factory_make("speed", "efekti");
	parse = gst_element_factory_make("mp3parse", "parse");
	
	gst_bin_add_many(GST_BIN(pipeline), source, parse, decode, convert, speed, convert2, sink, NULL);
	gst_element_link(source, parse);
	gst_element_link_many(parse, decode, convert, speed, convert2, sink, NULL); 	
	setPiano();	

	connect (upperb, SIGNAL(clicked()), this, SLOT(octaveUp()));
	connect (lowerb, SIGNAL(clicked()), this, SLOT(octaveDown()));
	connect (ab, SIGNAL(released()), this, SLOT(stopSound()));
	connect (ab, SIGNAL(pressed()), this, SLOT(playab()));
	connect (abb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (abb, SIGNAL(pressed()), this, SLOT(playabb()));
	connect (hb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (hb, SIGNAL(pressed()), this, SLOT(playhb()));
	connect (cb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (cb, SIGNAL(pressed()), this, SLOT(playcb()));
	connect (cbb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (cbb, SIGNAL(pressed()), this, SLOT(playcbb()));
	connect (db, SIGNAL(released()), this, SLOT(stopSound()));
	connect (db, SIGNAL(pressed()), this, SLOT(playdb()));
	connect (dbb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (dbb, SIGNAL(pressed()), this, SLOT(playdbb()));
	connect (eb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (eb, SIGNAL(pressed()), this, SLOT(playeb()));
	connect (fb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (fb, SIGNAL(pressed()), this, SLOT(playfb()));
	connect (fbb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (fbb, SIGNAL(pressed()), this, SLOT(playfbb()));
	connect (gb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (gb, SIGNAL(pressed()), this, SLOT(playgb()));
	connect (gbb, SIGNAL(released()), this, SLOT(stopSound()));
	connect (gbb, SIGNAL(pressed()), this, SLOT(playgbb()));
	connect (ab2, SIGNAL(released()), this, SLOT(stopSound()));
	connect (ab2, SIGNAL(pressed()), this, SLOT(playab2()));
	connect (abb2, SIGNAL(released()), this, SLOT(stopSound()));
	connect (abb2, SIGNAL(pressed()), this, SLOT(playabb2()));
	connect (hb2, SIGNAL(released()), this, SLOT(stopSound()));
	connect (hb2, SIGNAL(pressed()), this, SLOT(playhb2()));

	pianoAct = new QAction("Piano", this);
	organAct = new QAction("Organ", this);
	sampleAct = new QAction("Open Sample", this);
	menubar->addAction(pianoAct);
	menubar->addAction(organAct);
	menubar->addAction(sampleAct);

	connect (pianoAct, SIGNAL(triggered()), this, SLOT(setPiano()));
	connect (organAct, SIGNAL(triggered()), this, SLOT(setOrgan()));
	connect (sampleAct, SIGNAL(triggered()), this, SLOT(setSample()));
	
}

void Miano::setupEffect() {
         
}
void Miano::setPiano() {
	g_object_set(G_OBJECT(source), "location", "/opt/miano/sounds/piano.mp3", NULL);
}
void Miano::setOrgan() {
	g_object_set(G_OBJECT(source), "location", "/opt/miano/sounds/organ.mp3", NULL);
}

void Miano::setSample() {
	QString filen = QFileDialog::getOpenFileName(this, tr("Open Audio"), "/home", tr("Audio Files (*.mp3)"));
	if(!filen.isNull()) {	
		g_object_set(G_OBJECT(source), "location", static_cast<const char*>(filen.toUtf8()), NULL);
	}
}




double Miano::getSpeed(int note) {
    double freq = pow(2.000, ((this->octave*12+note)/12.000));
    return freq;
}


void Miano::octaveUp() {
	octave++;
}

void Miano::octaveDown() {
	octave--;
}

void Miano::stopSound() {
	gst_element_set_state (pipeline, GST_STATE_READY);

}

void Miano::playab() {
	g_object_set(G_OBJECT(speed), "speed", getSpeed(0), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}
void Miano::playabb() {
	g_object_set(G_OBJECT(speed), "speed", getSpeed(1), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playhb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(2), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playcb() {
	g_object_set(G_OBJECT(speed), "speed", getSpeed(3), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playcbb() {
	g_object_set(G_OBJECT(speed), "speed", getSpeed(4), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playdb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(5), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playdbb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(6), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playeb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(7), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playfb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(8), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playfbb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(9), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playgb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(10), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playgbb(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(11), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playab2(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(12), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playabb2(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(13), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}

void Miano::playhb2(){
	g_object_set(G_OBJECT(speed), "speed", getSpeed(14), NULL);
	gst_element_set_state (pipeline, GST_STATE_PLAYING);		
}


