#ifndef VIEW_H
#define VIEW_H

#include <QGraphicsView>
#include <QGraphicsScene>
#include <iostream>
#include <QMouseEvent>
#include <node.h>
#include <graph.h>
#include <finger.h>
#include <bonus.h>
#include <dbus/dbus.h>
#include <button.h>
#include <editgraph.h>
#include <icon.h>
#include <QTime>
#include <string>
#include <fstream>
#include <dirent.h>
#include <QListWidget>
#include <QAbstractKineticScroller> 
#include <QCoreApplication>
#include <QApplication>

#include "json/JSON_parser.h"
#include <assert.h>
#include <locale.h>
#include <validator.h>
#include <QNetworkAccessManager>

#include <networkhandler.h>
#include <user.h>
#include <QGridLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QFileDialog>
#include <string>
#include <QTimer>
#include <stdlib.h>
#include <libosso.h>
#include <stdlib.h>

class Finger;
class Button;
class EditGraph;
class Icon;
class Validator;
class NetworkHandler;
class User;
class Someone;


class View: public QGraphicsView
{

	Q_OBJECT
	
	public:

		View(QGraphicsScene* scene_, int validationMode_=0, Validator* validator_=NULL);

		std::string levelId;

	
		std::vector<Someone*> someones;
		int won;
		
		 static osso_context_t* _osso;
		
		void mousePressEvent(QMouseEvent * event);
		void mouseMoveEvent(QMouseEvent* event);
		void mouseReleaseEvent(QMouseEvent* event);
		
		static QApplication* app;
		
		Validator* validator;
		int validationMode;
		
		int firstSelection;
		
		QGraphicsScene* scene;

		void readLevels(const char* subDir);
		std::string currentMode;
		
		std::vector<std::string> levels;

		qreal scale;
		int offsetX;
		int offsetY;
		

		User* user;
		QGridLayout* infoLayout;
		QLineEdit* username;
		QLineEdit* password;
		QLineEdit* email;

		QPushButton* ok;
		QPushButton* anon;
		QPushButton* reg;
		
		QPushButton* newest;
		QPushButton* left;
		QPushButton* right;
		QPushButton* mine;
		
		QFileDialog fileDialog;

		NetworkHandler* networkHandler;
		
		int solutionReading;
		int graphChosen;
		
		void loadLevel(std::string name_);
		int pageNum;
		int maxPageNum;

		void getLevelsList(const char* type_);
		std::vector<int> levelsIds;
		
		int mode;
		
		std::string currentGraphId;
		
		Graph* graph;
		EditGraph* editGraph;
		
		Node* nodePressed;

		Node* nodeA;
		Node* nodeB;
		
		Finger* finger;

		Icon* iconMove;
		Icon* iconTrash;
		Icon* iconRecord;
		Icon* iconBonus;
		Icon* iconSave;
		Icon* iconSubmit;
		
		
		Icon* iconBack;
		Icon* iconCreator;
		Icon* iconTimer;


		void fail();

		int readyToSave;
		int readyToSubmit;
		
		int lastX;
		int lastY;
		
		int moveMode;
		int modeChanged;
		qreal d;

		int bonusAdd;
		int bonusConsumed;
		

		int getNodeIndex(Node* node_);
		void init();
		void reset();
		int toReset;
		void start();

		 Button* gameButton;
		 Button* editorButton;
		Button* registerButton;	
	
		int draw;
	
		void writeSolution();
		void writeLevel();
		
		int submitSolution();
		int submitLevel();
		
		std::vector<std::string> levelsPosted;

		int requestingLevelID;
		
		std::vector<int> levelsToGet;
		int levelsListComplete;
		int levelsNumber;
		
		void submissionFinished();
		int submissionFinishedCounter;
		
		int solutionSuccess;
		int levelSuccess;
		
		void removeFinger();	


		 QListWidget *listWidget;
		

		void vibrate(int type);
		void connectToDbusVibra();
		
		int connectedVib;
		DBusMessage* msgVib;
		DBusMessageIter argsVib;
		DBusConnection* connVib;
		DBusError errVib;
		DBusPendingCall* pendingVib;
		int retVib;
		const char* paramVib;


		void editNodesReset();
		
		std::string levelDir;
		std::string validatorDir;
		std::string avatarDir;
		
		static View* me;
		
		//json stuff
		FILE* input;
		JSON_config config;
		struct JSON_parser_struct* jc;
		static int handleResult(void* ctx, int type, const JSON_value* value);
		int s_IsKey;		
		int count;
		std::string key;
		void setInt(int value_);
		void setString(std::string value_);
			
		 int readConfig();


		 int creatingNodeX;
		 int creatingNodeY;
		 int creatingNodeValue;

		 int creatingEdgeNodeA;
		 int creatingEdgeNodeB;
		 int creatingEdgeBonuses;
	

		void win();
		int firstCheck;
	

		void replyFinished(const char* data,int option=0);	
		int registrationFailed;
		QGraphicsTextItem* replyText;
		std::string serverReply;

		void getUserName(int userID);
		int usernameRequested;
		
		
		QPixmap creatorPix;
		QPixmap tempPix;
		std::vector<int> pixIDs;
		
		void getUserAvatar(int userID);
		int avatarRequested;
		
		void login();
		int readLoginFile();
		std::string loginLine;
		
		QTimer timerTick;
		
		 public slots:
			void levelChosen(const QModelIndex & index);
			void registerOk();
			void loginOk();

			void toRegister();
			void anonLogin();
 
			void checkSubmittedLevels();

			void newestClicked();
			void mineClicked();
			void levelTick();
			void leftClicked();
			void rightClicked();
			void resetScreen();
};

class Someone
{

	public:
		Someone(int id_, std::string name_);
		int id;
		std::string name;


};


#endif
