#ifndef NODE_H
#define NODE_H

#include <QGraphicsItem>
#include <QPainter>
#include <baseobject.h>
#include <iostream>
#include <view.h>

class View;

class Node: public QGraphicsItem,BaseObject
{

	public:
		Node(int x_, int y_, int nodeValue_);
		QRectF boundingRect() const;
		void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

		static View* myView;
		
		int x;
		int y;
		
		qreal size;
	
		void reset();
		
		qreal centerX;
		qreal centerY;
		
		void advance(int step);
			
		int startingPoint;	
		int endingPoint;

		~Node();

		int nodeValue;
		int currentValue;
		void hit();
		

		int touched;

		qreal jD;

		
		
};

#endif
