#include <networkhandler.h>

using namespace std;

NetworkHandler::NetworkHandler(View* myView_):QObject(0),myView(myView_)
{

	network = new QNetworkAccessManager();
	connect(network, SIGNAL(finished(QNetworkReply*)), this,
			SLOT(replyFinished(QNetworkReply*))); 

	fileToSave=0;

//	get("http://mgg.skomialek.com/");
//	post("http://mgg.skomialek.com/","/home/user/config");
//	getFile("http://mgg.skomialek.com/","/home/user/fileSaved");
}


void NetworkHandler::get(const char* url)
{
	network->get(QNetworkRequest(QUrl(url)));

}

void NetworkHandler::post(const char* url, const char* file)
{
	network->post(QNetworkRequest(QUrl(url)),QByteArray(readFileBytes(file)));
	fileToSave=0;

}


QByteArray NetworkHandler::readFileBytes(const char *name)
{

	QByteArray array;
	
	ifstream fl(name);
	fl.seekg( 0, ios::end );
	size_t len = fl.tellg();
	fl.seekg( 0, ios::beg );
	
	for (int i=0;i<len;++i)
	{
		array.append(fl.get());
	}
	fl.close();

	 
	return array;
}

	
void NetworkHandler::replyFinished(QNetworkReply* reply)
{

	
	if (fileToSave)
	{

		
		
		if (myView->avatarRequested)
		{
 			int size=reply->size();

 			char data[reply->size()];

 			char temp[1];
	

 

 			for (int i=0;i<size;++i)
 			{
				 reply->getChar(temp);
				 data[i]=temp[0];
			 }       
			ofstream myFile;
			myFile.open(fileName.c_str());
			myFile.write (data,size);
			myFile.close();
		
			fileToSave=0;
			myView->replyFinished(data,1);
		}
		else if (!myView->avatarRequested)
		{
			std::cout<<"saving level"<<std::endl;
			std::string data(reply->readAll().data());
			int size=data.size();
			ofstream myFile;
			myFile.open(fileName.c_str());
			myFile.write (data.c_str(),size);
			myFile.close();
		
			std::cout<<"saving level 2"<<std::endl;
			fileToSave=0;
			myView->replyFinished(data.c_str(),1);

		}		
		
	}
	else
	{
		std::string data(reply->readAll().data());
		myView->replyFinished(data.c_str());
	}
	reply->deleteLater();
}


int NetworkHandler::getFile(const char* url, const char* fileName_)
{
	fileToSave=1;
	fileName.erase();
	fileName.append(fileName_);
	get(url);
}

