#include <icon.h>

View* Icon::myView=NULL;

Icon::Icon(int x_,int y_, int type_):QGraphicsItem(0), x(x_),y(y_),type(type_)
{
	setPos(x,y);

	objectType=icon;

	if (type==0)
		backPix.load("/home/opt/mgraph/images/back.png");
	if (type==1)
		movePix.load("/home/opt/mgraph/images/move.png");
	if (type==3)
		recordPix.load("/home/opt/mgraph/images/record.png");
	if (type==4)
		bonusPix.load("/home/opt/mgraph/images/bonus.png");
	if (type==5)
		savePix.load("/home/opt/mgraph/images/save.png");
	if (type==7)
		uploadPix.load("/home/opt/mgraph/images/upload.png");
}


QRectF Icon::boundingRect() const
{
	if (type==2)
	        return QRectF(0,0,800,20);
	        
	return QRectF(0,0,60,60);
}


void Icon::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
	if (type==0)//back icon
	{
 		painter->save();
		

		painter->drawPixmap(0,0,backPix);	
       
		painter->setBrush(Qt::black);
		 painter->setPen(Qt::black);
		 QFont serifFont("Times", 20, QFont::Bold);
		 painter->setFont(serifFont);
		 painter->setOpacity(1);
		 painter->drawText(-30,85,QString(myView->user->username.c_str()));
							 
		
		painter->restore();
	}

	if (type==1)//move icon
	{
 		painter->save();
		
	//	painter->setPen(Qt::white);
		
		if (myView->moveMode)
			painter->setOpacity(1);
		else
			painter->setOpacity(0.4);

		painter->setBrush(Qt::green);
	//	painter->drawEllipse(boundingRect());
		painter->drawPixmap(0,0,movePix);
		painter->restore();
	}
	else if (type==2)//deleting area
	{

 		painter->save();
	
		painter->setOpacity(0.4);
		painter->setBrush(Qt::red);
		painter->setPen(Qt::red);
		painter->drawRect(boundingRect());
		
		if (myView->mode==1)
		{
			painter->setOpacity(1);
			painter->setBrush(Qt::green);
			painter->setPen(Qt::green);
			painter->drawRect(0,0,800*myView->graph->currentTime/myView->graph->time,20);
		}
		
		painter->restore();

	}
	else if (type==3)//record icon
	{
 		painter->save();
		painter->setPen(Qt::white);
		if (myView->mode==3)
			painter->setOpacity(1);
		else
			painter->setOpacity(0.4);
			
		//painter->setBrush(Qt::blue);
		//painter->drawEllipse(boundingRect());
		painter->drawPixmap(0,0,recordPix);
		painter->restore();
	}
	
	else if (type==4)//bonus icon
	{
 		painter->save();
		painter->setPen(Qt::white);
		if (myView->bonusAdd)
			painter->setOpacity(1);
		else
			painter->setOpacity(0.4);
			
		painter->setBrush(Qt::cyan);
		//painter->drawEllipse(boundingRect());
		painter->drawPixmap(0,0,bonusPix);
		painter->restore();
	}
	
	else if (type==5)//save icon
	{
 		painter->save();
		painter->setPen(Qt::white);
		if (myView->readyToSave)
			painter->setOpacity(1);
		else
			painter->setOpacity(0.4);
			
		painter->setBrush(Qt::red);
//		painter->drawEllipse(boundingRect());
		painter->drawPixmap(0,0,savePix);
		painter->restore();
	}
	else if (type==6)//creator
	{
		painter->save();
		 painter->setBrush(Qt::red);
        	 painter->setPen(Qt::red);
	         QFont serifFont("Times", 20*myView->scale, QFont::Bold);
		 painter->setFont(serifFont);
		 painter->setOpacity(0.8);
	//	painter->drawText(0,0,QString::number(myView->graph->creatorID));
		 painter->drawText(0,0,QString(myView->graph->creatorName.c_str()));
		 painter->drawPixmap(-65,-50,60,80,myView->creatorPix);
	 	 painter->restore();


	}
	else if (type==7)//level submission
	{
 		painter->save();
		painter->setPen(Qt::white);
		if (myView->readyToSubmit)
			painter->setOpacity(1);
		else
			painter->setOpacity(0.4);
			
		painter->setBrush(Qt::yellow);
	//	painter->drawEllipse(boundingRect());
		painter->drawPixmap(0,0,uploadPix);
		painter->restore();



	}
	else if (type==8)//timer
	{
		painter->save();
		 painter->setBrush(Qt::red);
        	 painter->setPen(Qt::red);
	         QFont serifFont("Times", 30*myView->scale, QFont::Bold);
		 painter->setFont(serifFont);
		 painter->setOpacity(0.8);
		painter->drawText(0,0,QString::number(myView->graph->currentTime));
		painter->restore();


	}
	
}


void Icon::advance(int step)
{
	if (!step)
		return;

	setPos(x,y);



}
