#include <finger.h>
#include <iostream>


Finger::Finger(int x_, int y_, View* view_):QGraphicsItem(0),x(x_),y(y_), myView(view_)
{

	objectType=finger;
	setPos(x,y);
	edgeActive=NULL;
	canChange=1;  //here
	starting=1;
	reseted=1;
	draw=1;
	nodeActive=NULL;
	lastNode=NULL;
	previousNode=NULL;
	tempDist=0;
	edgeActive=0;
}

Finger::~Finger()
{
	
	if (edgeActive!=NULL)
		edgeActive->inProgress=0;
}

QRectF Finger::boundingRect() const
{
	return QRectF(-20,-20,40,40);
}

QPainterPath Finger::shape() const
{

	       
       	QPainterPath path;
	path.addEllipse(boundingRect());
	return path;

}



void Finger::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

	if (!draw)
		return;

	painter->save();
	painter->setOpacity(0.4);
	painter->setBrush(Qt::magenta);
	painter->setPen(Qt::magenta);
	painter->drawEllipse(boundingRect());

	for (int i=0;i<xx.size(); ++i)
	{
		painter->drawEllipse(-3*(x-xx[i])-10,-3*(y-yy[i])-10,20.0,20.0);
	}
	
	painter->restore();
}

void Finger::advance(int step)
{
	if (myView->mode==-2)
		return;

	if (!step && !myView->validationMode)
		return;

	

	
	
	if (myView->validationMode)
	{
		
		qreal dx=myView->graph->nodes[myView->validator->solution[myView->validator->currentNode]]->centerX-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerX;

		qreal dy=myView->graph->nodes[myView->validator->solution[myView->validator->currentNode]]->centerY-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerY;
		
		
		
		
	//	qreal distance=sqrt(pow(dx,2)+pow(dy,2));
	
		qreal distance=sqrt(pow(x-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerX,2)+pow(y-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerY,2));
		
		qreal factor;	
		if (dy!=0)
			factor=dx/dy;
		else
			factor=1;
	

		
	
		qreal a=myView->validator->step;
		
		if (distance<12)
			a=1;
	
		
		
		if (factor*a<-20)
			a=a/10;
	
		if (factor*a>20)
			a=a/10;
		
		
		if (dy>0)
			y-=1*a;
		else if (dy<0)
			y+=1*a;
		
		if (dx>0 && dy>=0)
			x-=factor*a;
		else if (dx<0 && dy<=0)
			x+=factor*a;
		else if (dx>0 && dy<=0)
			x+=factor*a;
		else if (dx<0 && dy>=0)
			x-=factor*a;

		distance=sqrt(pow(x-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerX,2)+pow(y-myView->graph->nodes[myView->validator->solution[myView->validator->currentNode+1]]->centerY,2));
		
		tempDist=distance;
	

		if (tempDist<2)
			++myView->validator->currentNode;

	}

	setPos(x,y);

	int collEdges=0;
	int collNodes=0;
	
	if (scene()->collidingItems(this).count()==0)
	{
	
		canChange=0;

		starting=1;
		if (edgeActive!=NULL)
		{
			edgeActive->inProgress=0;
			edgeActive=NULL;
		}
		
		if (!reseted)
		{
		
			myView->reset();
			myView->vibrate(2);
			reseted=1;
			return;
		}
	}
	else
	{

		reseted=0;
		myView->toReset=1;
		
		for (int i=0;i<scene()->collidingItems(this).count();++i)
		{
			if (((Finger*)scene()->collidingItems(this)[i])->objectType==edge)
			{
				++collEdges;
			}
			if (((Finger*)scene()->collidingItems(this)[i])->objectType==node)
				++collNodes;
		}
	}
	
	
	if(collNodes==0 && nodeActive!=NULL)
	{
		nodeActive=NULL;
	}
	
	int inEdge=0;


	 for (int i=0;i<scene()->collidingItems(this).count();++i)
	 {


		if (((Finger*)scene()->collidingItems(this)[i])->objectType==edge)
		{

		
	 		if (myView->bonusAdd && !myView->bonusConsumed)
			{
				
				((Edge*)scene()->collidingItems(this)[i])->addBonus(10);
				myView->bonusConsumed=1;
				scene()->addItem(((Edge*)scene()->collidingItems(this)[i])->bonuses.back());
				return;
			}


			
			if (canChange && collEdges==1)
			{
		 
				
				if (!edgeActive==NULL)
					edgeActive->inProgress=0;
				
				edgeActive=((Edge*)scene()->collidingItems(this)[i]);
				edgeActive->inProgress=1;
				canChange=0;
				inEdge=1;
				return;
			}

			if (edgeActive==((Edge*)scene()->collidingItems(this)[i]))
			{
				edgeActive->inProgress=1;
				inEdge=1;
			}

		
			
		}

		if (((Finger*)scene()->collidingItems(this)[i])->objectType==node )
		{


			
			
			if (starting)
			{	
		//		if (((Node*)scene()->collidingItems(this)[i])->startingPoint==1)
				{
					canChange=1;
					starting=0;
					nodeActive=((Node*)scene()->collidingItems(this)[i]);
					nodeActive->hit();
					lastNode=nodeActive;
				}
				return;
				
			}


			
			if (edgeActive!=NULL && (edgeActive->nodeB==((Node*)scene()->collidingItems(this)[i]) || edgeActive->nodeA==((Node*)scene()->collidingItems(this)[i]) )) //two way
			{
				if (((Node*)scene()->collidingItems(this)[i])==previousNode)
				{
					if (!reseted)
					{
		
						nodeActive=NULL;
						previousNode=NULL;
						lastNode=NULL;
						starting=1;
						if (myView->mode==3)
							myView->editNodesReset();
						else
							myView->reset();

						myView->vibrate(2);
						reseted=1;
						return;
					}
				}
				
				canChange=1;
				if (nodeActive==NULL && lastNode!=((Node*)scene()->collidingItems(this)[i]))
				{
					
				
					if (myView->mode==99)
					{
					//	tempDist=sqrt(pow(x-((Node*)scene()->collidingItems(this)[i])->centerX,2)+pow(y-((Node*)scene()->collidingItems(this)[i])->centerY,2));
						
						
						if (tempDist>2)
							return;

	//				++myView->validator->currentNode;
					}
					previousNode=lastNode;
					lastNode=((Node*)scene()->collidingItems(this)[i]);
					nodeActive=((Node*)scene()->collidingItems(this)[i]);
					((Node*)scene()->collidingItems(this)[i])->hit();

				}
			}
			//	return;
			//
		}


		
		if (((Finger*)scene()->collidingItems(this)[i])->objectType==bonus && edgeActive!=NULL && ((Bonus*)scene()->collidingItems(this)[i])->myEdge==edgeActive && myView->mode!=3 && myView->mode!=2) 
		{
	 		((Bonus*)scene()->collidingItems(this)[i])->hit();	

		}
	 }
		
	 	if (inEdge==0) //we are colliding but not with the right edge
		{
			if (edgeActive!=NULL)
			{
				edgeActive->inProgress=0;
				edgeActive=NULL;
			//	myView->reset();
			}
		}
}

