#!/usr/bin/env python

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : mfefolders.py
# Author      : thavoc@gmail.com
# Version     : 0.21
# Description : Toggles MfE sync by folders and renames local folders
# ============================================================================

import gtk
import hildon
import sqlite3
import gconf
import osso
import sys

ctVersion = "V0.21"
folders = []
checkbuttons = []
entries = []
buttons = []

def toggle(widget, data):
    global conn
    global c
    if widget.get_active():
        print checkbuttons[data].get_label(), "activated"
        c.execute("update mailfoldercustom set value=1 where name='Class' and id in (select id from mailfolders where name='" + checkbuttons[data].get_label() + "')")
        conn.commit()        
    else:
        print checkbuttons[data].get_label(), "deactivated"
        c.execute("update mailfoldercustom set value=9 where name='Class' and id in (select id from mailfolders where name='" + checkbuttons[data].get_label() + "')")
        conn.commit()

def save(widget, data):
    global conn
    global c
    print "Updating", folders[data][0],  "to", folders[data][1]
    c.execute("update mailfolders set displayname='" + folders[data][1] + "' where displayname='" + folders[data][0] + "'")
    conn.commit()
    folders[data][0] = folders[data][1]
    entries[data].set_placeholder(folders[data][1])
    entries[data].emit("changed")

def changed(widget,  data):
    folders[data][1] = widget.get_text()
    if folders[data][1] == folders[data][0]  or folders[data][1] =="":
        buttons[data].set_sensitive(0)
    else:
        buttons[data].set_sensitive(1)

def main():
    i = 0 
    global folders
    global conn
    global c
    osso_c = osso.Context("mfefolders", "0.2.1", False)
    program = hildon.Program.get_instance()
    mainwin = hildon.Window()
    mainwin.set_markup("MfEfolders <small>" + ctVersion + "</small>")
    program.add_window(mainwin)
    mainwin.connect("delete_event",gtk.main_quit,None)
    
    client = gconf.client_get_default()
    if client.dir_exists("/apps/activesync/ActiveSyncAccount1") == False:
        note = hildon.hildon_note_new_information(mainwin, "ActiveSync account not found!\n exiting...")
        response = gtk.Dialog.run(note)
        note.destroy()
#        sys.exit()
    
    vbox = gtk.VBox()
    pa = hildon.PannableArea()
    
    conn = sqlite3.connect('/home/user/.qmf/qmailstore.db')
    c = conn.cursor()
    
    c.execute("select f.id,f.name,f.displayname,c.value from mailfolders as f join mailfoldercustom as c on f.id=c.id where c.name='Class' and c.value in ('1','9')")
    for row in c:
#        print row
        folders.append([row[2], ""])
        button = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT) 
        button.set_label(row[1])
        if row[3]=='1': button.set_active(1)
        button.connect("toggled",toggle,i)
        checkbuttons.append(button)
        
        ent = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        ent.set_placeholder(row[2])
        ent.set_text(row[2])
        ent.connect("changed", changed, i)
        entries.append(ent)
        
        butt = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        butt.set_text("Save", "")
        butt.connect("clicked", save, i)
        butt.set_sensitive(0)
        buttons.append(butt)
        
        hbox = gtk.HBox(1, 0)
        hbox2 = gtk.HBox(0, 0)
        hbox.pack_start(button, 1, 1)
        hbox.pack_start(ent, 1, 1)
        hbox2.pack_start(hbox, 1, 1)
        hbox2.pack_start(butt, 0, 0)
        vbox.pack_start(hbox2)
        i = i +1
    
    pa.add_with_viewport(vbox)
    mainwin.add(pa)
    mainwin.show_all()
    gtk.main()

if __name__ == "__main__":
  main()
