#ifndef SINKPLUGIN_H
#define SINKPLUGIN_H

#include <QtCore>

class PluginInterface;
class MainWindow;

// IMPORTANT: For some reason every virtual function must have a "= 0" for the function to be loaded (no const!)
// If anyone knows why, please tell me (dragly)

class SinkPlugin {
public:
    SinkPlugin(const PluginInterface *interface) {this->interface = interface;}
    const PluginInterface* getInterface() {return this->interface;}
    virtual ~SinkPlugin() {}

    // virtuals (all are optional to make sure the plugin loads even though the developer has made a mistake)
    virtual QString getName() {return "Sink plugin name not defined";}; // the name of the sink plugin
    virtual QString getText() {return "Plugin text not defined";}; // the text to show in the list of results (for instance: "Found 300 products online. Lowest price: €200").
    virtual QImage *getImage() {return new QImage;}; // an image to be returned in the results window or history list (might be a logo or basically anything).
    virtual void clickAction(QWidget * /*parentWindow*/) {}; // an action to be performed when the plugin is clicked in the results list
    virtual bool isReady() {return false;}; // set to true if the plugin is ready to be shown in the list of results (i.e. the scanned barcode is handled by this plugin)
    virtual bool hasResultsWindowWidget() {return false;}; // true if the plugin should have a custom widget
    virtual QWidget *resultsWindowWidget() {return new QWidget();}; // the custom widget for the results window
    virtual bool hasHistoryListWidget() {return false;}; // true if the plugin has a custom widget
    virtual QWidget *historyListWidget() {return new QWidget();}; // a custom widget for the history list
private:
    const PluginInterface* interface;
};

#endif // SINKPLUGIN_H
