/*
  MathJinni - A simple formular calculator
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Util.h"

#include <iomanip>
#include <sstream>

#include <Lum/Base/String.h>

std::wstring DoubleToWStringFloat(double value)
{
  std::stringstream buffer;

  buffer.imbue(std::locale(""));

  buffer << std::setprecision(9) << value;

  return Lum::Base::StringToWString(buffer.str());
}

std::wstring DoubleToWStringExp(double value)
{
  std::stringstream buffer;

  buffer.imbue(std::locale(""));

  buffer << std::setprecision(7) << value;

  return Lum::Base::StringToWString(buffer.str());
}

std::wstring GetErrorText(Parser::ReturnCode code)
{
  switch (code) {
  case Parser::OK:
    return L"OK";
  case Parser::NODIGIT:
    return L"Not a number!";
  case Parser::NORBRAC:
    return L"No closing bracket!";
  case Parser::WRONGBRAC:
    return L"Wrongly positioned bracket!";
  case Parser::UNKNOWNIDENT:
    return L"Unknown identifier!";
  case Parser::ILLGVAL:
    return L"Illegal value!";
  case Parser::UNKNOWN:
    return L"Unknown error!";
  case Parser::NOOP:
    return L"Nothing to calculate!";
  case Parser::DIVBYZERO:
    return L"Divide by zero!";
  case Parser::NEGVAL:
    return L"Pasing negative value to function that allows only positive values!";
  }

  return L"Unknown error!";
}

