/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "ConfigDialog.h"

#include <Lum/Base/L10N.h>

#include <Lum/Model/Table.h>

#include <Lum/Combo.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>

#include "Configuration.h"

ConfigDialog::ConfigDialog()
: calcTrigoMode(new Lum::Model::SizeT(::calcTrigoMode->Get()+1)),
  okAction(new Lum::Model::Action())
{
  Observe(okAction);

  SetExitAction(GetClosedAction());
}

Lum::Object* ConfigDialog::GetContent()
{
  Lum::Label                 *label;
  Lum::Panel                 *panel;
  Lum::Model::StringTableRef calcTrigoModes=new Lum::Model::StringTable();

  calcTrigoModes->Append(L"Degree");
  calcTrigoModes->Append(L"Radiant");

  panel=Lum::VPanel::Create(true,false);

  label=Lum::Label::Create(true,false);
  label->AddLabel(L"Calc trigometric mode:",Lum::IndexCombo::Create(calcTrigoMode,
                                                                    calcTrigoModes,true,false));

  panel->Add(label);

  return panel;
}

void ConfigDialog::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  Lum::Dlg::ActionDialog::CreateActionInfosOkCancel(actions,okAction,GetClosedAction());
}

void ConfigDialog::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
 if (model==okAction && okAction->IsFinished()) {
    ::calcTrigoMode->Set(calcTrigoMode->Get()-1);

    Exit();
  }

  Dialog::Resync(model,msg);
}
