#ifndef FUNCTIONINPUT_H
#define FUNCTIONINPUT_H

/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <map>

#include <Lum/Model/Action.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/Table.h>

#include <Lum/Object.h>
#include <Lum/String.h>

struct Shortcut
{
  std::wstring display;
  std::wstring value;

  Shortcut(const std::wstring& display,
           const std::wstring& value)
   : display(display),
     value(value)
  {
    // no code
  }

  Shortcut(const std::wstring& value)
   : display(value),
     value(value)
  {
    // no code
  }
};

typedef Lum::Model::StdTable<Shortcut>       ShortcutsModel;
typedef Lum::Base::Reference<ShortcutsModel> ShortcutsModelRef;

class ShortcutsDataProvider : public ShortcutsModel::DataProvider
{
public:
  std::wstring GetString(const ShortcutsModel::Iterator& iter, size_t column) const
  {
    return iter->display;
  }
};

class FunctionInput : public Lum::Component
{
private:
  Lum::String                                *string;
  std::map<Lum::Model::Action*,std::wstring> actionTextMap;
  ShortcutsModelRef                          constants;
  Lum::Model::SingleLineSelectionRef         constantSelection;
  Lum::Model::ActionRef                      constantAction;
  ShortcutsModelRef                          functions;
  Lum::Model::SingleLineSelectionRef         functionSelection;
  Lum::Model::ActionRef                      functionAction;
  ShortcutsModelRef                          trigometrics;
  Lum::Model::SingleLineSelectionRef         trigometricSelection;
  Lum::Model::ActionRef                      trigometricAction;
  Lum::Model::ActionRef                      backspaceAction;
  Lum::Model::ActionRef                      clearAction;
  Lum::Model::ActionRef                      calculateAction;

private:
  Lum::Object* CreateButton(const std::wstring& label, Lum::Model::Action *action=NULL) const;
  Lum::Object* CreateTextButton(const std::wstring& label, const std::wstring& text=L"");

public:
  FunctionInput();

  void SetString(Lum::String *string);

  void SetCalculateAction(Lum::Model::Action* action);

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
