/*
  sudokusettings.h
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 3.6.2010
*/
#ifndef SUDOKUSETTINGS_H
#define SUDOKUSETTINGS_H
#include <QObject>
#include <QColor>
class QColor;
class CSudokuTable;

class SudokuSettings : public QObject
{
public:
    SudokuSettings();
	bool loadSettings(CSudokuTable* aSudokuTable);
	bool saveSettings(CSudokuTable* aSudokuTable);
	void setBackgroundColor(QColor aColor);
	void setFontColor(QColor aColor);
	void setErrorFontColor(QColor aColor);
	void setWrongNumberFontColor(QColor aColor);
	void setGridColor(QColor aColor);
	void setFullGridColor(QColor aColor);
	void setPractiseMode(bool aMode);
	void setShowSolveButton(bool aMode);
	QColor getBackgroundColor();
	QColor getFontColor();
	QColor getErrorFontColor();
	QColor getWrongNumberFontColor();
	QColor getGridColor();
	QColor getFullGridColor();
	bool getPractiseMode();
	bool getShowSolveButton();

private:
	QColor iBackgroundColor;
	QColor iFontColor;
	QColor iWrongNumberFontColor;
	QColor iGridColor;
	QColor iFullGridColor;
	bool iPracMode;
	bool iShowSolveButton;	
};

#endif 
