/*
sudokusettingsdialog.cpp
Project: masudoku
Platform: Fremantle (maemo5) PR1.2
Author: Petri Kultanen pete@petnetti.net
Last Edit: 3.6.2010
*/
#include "sudokusettingsdialog.h"
#include "sudokusettings.h"
#include <qpushbutton.h>
#include <QDialogButtonBox>
#include <QVBoxLayout>
#include <QScrollArea>
#include <QGroupBox>
#include <QPalette>
#include <QColorDialog>
#include <QCheckBox>

/*
Constructor
*/
SudokuSettingsDialog::SudokuSettingsDialog(QWidget *parent) :
QDialog(parent)
{
	this->setWindowTitle("Settings");
}
/*
Init class.
This must be called after   setSettings(SudokuSettings* aSettings)
*/
void SudokuSettingsDialog::init()
{
	iGridButton = new QPushButton("Grid Color");
	QObject::connect(iGridButton,SIGNAL(clicked()),this,SLOT(setColor()));
	iFontButton = new QPushButton("Font Color");
	QObject::connect(iFontButton,SIGNAL(clicked()),this,SLOT(setColor()));	
	iBackground = new QPushButton("Background Color");
	QObject::connect(iBackground,SIGNAL(clicked()),this,SLOT(setColor()));		
	iFullGrid = new QPushButton("Table Full Color");
	QObject::connect(iFullGrid,SIGNAL(clicked()),this,SLOT(setColor()));		
	iWrongNumberFont = new QPushButton("Wrong Number Font Color");
	QObject::connect(iWrongNumberFont,SIGNAL(clicked()),this,SLOT(setColor()));	
	QPushButton* SaveAndApply = new QPushButton("Save and apply");
	QObject::connect(SaveAndApply,SIGNAL(clicked()),this,SLOT(accept()));
	iPractiseCheckBox = new QCheckBox("Practice Mode");
	QObject::connect(iPractiseCheckBox,SIGNAL(clicked()),this,SLOT(setPractiseMode()));
	iShowSolveButtonCheckBox = new QCheckBox("Show Solve button");	
	QObject::connect(iShowSolveButtonCheckBox,SIGNAL(clicked()),this,SLOT(setShowSolveButton()));		
	
	//Do layout
	QHBoxLayout * layout = new QHBoxLayout;
	QVBoxLayout * itemsLayout = new QVBoxLayout;
	QVBoxLayout * applyButonLayout = new QVBoxLayout;
	itemsLayout->addWidget(iGridButton);
	itemsLayout->addWidget(iFontButton);
	itemsLayout->addWidget(iBackground);
	itemsLayout->addWidget(iFullGrid);
	itemsLayout->addWidget(iWrongNumberFont);
	itemsLayout->addWidget(iPractiseCheckBox);
	itemsLayout->addWidget(iShowSolveButtonCheckBox);
	layout->addLayout(itemsLayout);
	layout->insertSpacing(1,200);
	applyButonLayout->addStretch();
	applyButonLayout->addWidget(SaveAndApply);
	layout->addLayout(applyButonLayout);
	layout->setSizeConstraint(QLayout::SetMinAndMaxSize);
	QScrollArea * area = new QScrollArea(this);
	QGroupBox *groupBox = new QGroupBox(area);
	groupBox->setLayout(layout);
	area->setWidget(groupBox);
	area->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
	QVBoxLayout * mainLayout = new QVBoxLayout;
	mainLayout->addWidget(area);
	this->setLayout(mainLayout);
	
	//Fetch current settings
	iGridColor = iSettings->getGridColor();
	iFontColor = iSettings->getFontColor();
	iBackgroundColor = iSettings->getBackgroundColor();
	iWrongNumberFontColor = iSettings->getWrongNumberFontColor();
	iFullGridColor = iSettings->getFullGridColor();	
	iPractiseMode = iSettings->getPractiseMode();
	iShowSolveButton = iSettings->getShowSolveButton();
	iPractiseCheckBox->setChecked(iPractiseMode);
	iShowSolveButtonCheckBox->setChecked(iShowSolveButton);  
	
}
void SudokuSettingsDialog::setColor()
{	
	QColor color;
	//Fetch current color
	if(QObject::sender ()==iGridButton) color = iGridColor;
	if(QObject::sender ()==iFontButton) color = iFontColor;
	if(QObject::sender ()==iBackground) color = iBackgroundColor;
	if(QObject::sender ()==iFullGrid) color = iFullGridColor;
	if(QObject::sender ()==iWrongNumberFont) color = iWrongNumberFontColor;
	//show dialog and ask new color (old color as default)
	color = QColorDialog::getColor(color);
	if(QObject::sender ()==iGridButton) iGridColor = color;
	if(QObject::sender ()==iFontButton) iFontColor = color;
	if(QObject::sender ()==iBackground) iBackgroundColor = color;
	if(QObject::sender ()==iFullGrid) iFullGridColor = color;
	if(QObject::sender ()==iWrongNumberFont) iWrongNumberFontColor = color;
}
void SudokuSettingsDialog::setPractiseMode()
{
	iPractiseMode = iPractiseCheckBox->isChecked();
}
void SudokuSettingsDialog::setShowSolveButton()
{
	iShowSolveButton = iShowSolveButtonCheckBox->isChecked();
}
//Called after dialog is closed.
void SudokuSettingsDialog::apply()
{
	iSettings->setGridColor(iGridColor);
	iSettings->setFontColor(iFontColor);
	iSettings->setBackgroundColor(iBackgroundColor);
	iSettings->setFullGridColor(iFullGridColor);
	iSettings->setWrongNumberFontColor(iWrongNumberFontColor);
	iSettings->setPractiseMode(iPractiseMode);
	iSettings->setShowSolveButton(iShowSolveButton);
}
