# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


import sqlite3, os

##Return the account names, blogsystem and if it's default of the all accounts
##return a list similar to:
## [['account1', 'Blogger', 'True'], ['account2', 'Wordpress', 'False']]
def get_account_list(sqlite_db):
    account_list = []
    for table in sqlite_db.execute('select * from sqlite_master'):
        for account in sqlite_db.execute('select * from ' + table[1]):
            account_list.append([account[1], table[1], account[7]])

    return account_list

def create_initial_accounts(sqlite_db):

    blogsystems = ["Wordpress", "Blogger", "Livejournal", "Drupal"]

    cursor_sql = sqlite_db.cursor()
    for blog in blogsystems:
        cursor_sql.execute('CREATE TABLE ' + blog + ' (id INTEGER PRIMARY KEY, \
                            accountname text, user text, password text, blogid text, \
                            blogname text, blogurl text, enabled text)')
    sqlite_db.commit()
    cursor_sql.close()

def create_initial_settings(sqlite_db):
    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('CREATE TABLE Settings (id INTEGER PRIMARY KEY,fontsize text, \
                        numpost text, perpage text, picasa_login text, picasa_pass text, \
                        picasa_albums text, autosave text, as_time text, as_path text, \
                        path_post text, path_post_img text, path_add_img text, defalbum text, numcomm text, confirm_on text, choose_on text)')
    sqlite_db.commit()
    cursor_sql.close()

def save_settings(sqlite_db, fontsize, numpost, perpage, picasa_login, picasa_pass, \
                        picasa_albums, autosave, as_time, as_path, path_post, \
                        path_post_img, path_add_img, defalbum, numcomm, confirmon, chooseon):
    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('REPLACE INTO Settings VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)', \
                    (1, fontsize, numpost, perpage, picasa_login, picasa_pass, \
                    picasa_albums, autosave, as_time, as_path, path_post, \
                    path_post_img, path_add_img, defalbum, numcomm, confirmon, chooseon))

    sqlite_db.commit()
    cursor_sql.close()


def new_account(sqlite_db, accountname, blogsystem, user, password, blogid, \
                blogname, blogurl):
    # Look if exists some account
    n_tables = 0
    for table in sqlite_db.execute('select * from sqlite_master'):
        for systems in sqlite_db.execute('select * from ' + table[1]):
            n_tables = n_tables + 1

    # If there is accounts, set the new account to not enabled
    # If there isn't account, set as default account
    if n_tables == 0:
        enabled = 'True'
    else:
        enabled = 'False'

    blogurl = autoput_xmlrpc_url(blogsystem, blogurl)

    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('INSERT INTO ' + blogsystem + ' VALUES (null, ?, ?, ?, ?, \
      ?, ?, ?)', (accountname, user, password, blogid, blogname, blogurl, enabled))

    sqlite_db.commit()
    cursor_sql.close()

    return n_tables

def get_account_settings(sqlite_db, blogsystem, accountname):

    for account in sqlite_db.execute('select * from ' +blogsystem + \
                            ' where accountname="%s"' % accountname):
        setting = account

    account_id = setting[0]
    accountname = setting[1]
    user = setting[2]
    password = setting[3]
    blogid = setting[4]
    blogname = setting[5]
    blogurl = setting[6]
    enabled = setting[7]

    return (account_id, accountname, user, password, blogid, blogname, blogurl, enabled)

def edit_account(sqlite_db, accountname, blogsystem, user, password, blogid, \
                blogname, blogurl, account_id, enabled, oldsystem, oldname):

    blogurl = autoput_xmlrpc_url(blogsystem, blogurl)

    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('REPLACE INTO ' + blogsystem + ' VALUES (?, ?, ?, ?, ?, ?,\
     ?, ?)', (account_id, accountname, user, password, blogid, blogname, blogurl, enabled))

    if oldsystem != blogsystem:
        sqlite_db.execute('delete from ' + oldsystem + ' where accountname="%s"' % oldname)

    sqlite_db.commit()
    cursor_sql.close()

def autoput_xmlrpc_url(blogsystem, blogurl):
    if blogsystem == 'Wordpress' or blogsystem == 'Drupal':
        if not 'xmlrpc.php' in blogurl:
            if not 'xmlrpc.xml' in blogurl:
                if blogurl == "":
                    return blogurl
                elif blogurl[len(blogurl)-1] == "/":
                    blogurl += 'xmlrpc.php'
                else:
                    blogurl += '/xmlrpc.php'

    return blogurl

def delete_account(sqlite_db, blogsystem, accountname):
    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('delete from ' + blogsystem + ' where accountname="%s"' \
                        % accountname)
    sqlite_db.commit()
    cursor_sql.close()

def make_default(sqlite_db, blogsystem, accountname, default):
    cursor_sql = sqlite_db.cursor()

    setting = get_account_settings(sqlite_db, blogsystem, accountname)

    account_id = setting[0]
    accountname = setting[1]
    user = setting[2]
    password = setting[3]
    blogid = setting[4]
    blogname = setting[5]
    blogurl = setting[6]
    enabled = setting[7]

    if default:
        cursor_sql.execute('REPLACE INTO ' + blogsystem + ' VALUES (?, ?, ?, ?, \
        ?, ?, ?, ?)', (account_id, accountname, user, password, blogid, blogname, \
        blogurl, "True"))
    else:
        cursor_sql.execute('REPLACE INTO ' + blogsystem  + ' VALUES (?, ?, ?, ?, \
        ?, ?, ?, ?)', (account_id, accountname, user, password, blogid, blogname, \
        blogurl, "False"))
    sqlite_db.commit()
    cursor_sql.close()

def get_default_settings(accounts_db, settings_db):
    def_account = []
    for table in accounts_db.execute('select * from sqlite_master'):
        for account in accounts_db.execute('select * from ' + table[1]):
            if account[7] == 'True':
                def_account.append([account[1], table[1], account[2], \
                        account[3], account[4], account[5], account[6], \
                        account[7]])

    def_settings = []
    for setting in settings_db.execute('select * from Settings'):
        def_settings.append(setting)

    return def_account, def_settings

def define_paths(scratchbox, HOME):
    configdir = HOME + '/.maemowordpy/'
    logfile = configdir + 'log.txt'
    cacheimgdir = configdir + 'images/'

    if not os.path.exists(configdir):
        os.mkdir(configdir)
        os.mkdir(cacheimgdir)

    if os.path.exists(configdir + 'accounts'):
        accounts_db = sqlite3.connect(configdir + 'accounts')
    else:
        accounts_db = sqlite3.connect(configdir + 'accounts')
        create_initial_accounts(accounts_db)

    if os.path.exists(configdir + 'settings'):
        settings_db = sqlite3.connect(configdir + 'settings')
    else:
        settings_db = sqlite3.connect(configdir + 'settings')
        create_initial_settings(settings_db)

    if scratchbox:
        appdir = ''
        imgdir = 'pixmaps/'
    else:
        appdir = '/opt/mastory/'
        imgdir = appdir + 'pixmaps/'

    return accounts_db, settings_db, appdir, imgdir, configdir, logfile
