# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


from wordpy import wordpress, blogger
import os
import logging

logger = logging.getLogger("posting")
logger.setLevel(logging.DEBUG)

def to_wordpress(url, user, password, title, postpassw, tags, \
                pings, comments, posttext, extendedtext, status, \
                slug, cats, tbacks, ttags, edited, postid, \
                rtags, posting_info, sch_time, sch_date, schedule_on):

    wpclient = wordpress.create_wordpress_client(url, user, password)
    if wpclient is None:
        logger.error("Creating Wordpress client")
        return None
    post = wordpress.WordPressPost()
    #Title
    post.title = title
    post.password = postpassw

    post.tags = tags
    if post.tags == '':
        post.tags = rtags
    else:
        if rtags == '':
            post.tags = post.tags
        else:
            post.tags = post.tags + ', ' + rtags

    # Allow Pings
    if pings:
        post.allowPings = 'open'
    else:
        post.allowPings = 'closed'

    # Allow Comments
    if comments:
        post.allowComments = 'open'
    else:
        post.allowComments = 'closed'

    if schedule_on:
        import time
        #sch_time = (17, 8)
        #sch_date = (20, 8, 2008)
        #date = (year, month, day, hour, minutes, seconds, weekday, yearday, dst)
        # dst = -1 --> localtime
        #if time.localtime()[8] == 0:
        #    onehour = - 1
        #else:
        #    onehour = 0
        local = time.localtime()
        gmt = time.gmtime()
        local = (local[3], local[4])
        gmt = (gmt[3], gmt[4])

        diff = (local[0]-gmt[0], local[1]-gmt[1])

        post.date = (int(sch_date[0]), int(sch_date[1])+1, int(sch_date[2]), \
                    int(sch_time[0])-diff[0], int(sch_time[1])-diff[1], 00, 0, 0, -1)

        logger.debug("Date: %s" % str(post.date))

    #Text
    extendedtext = '<br /><br />' + extendedtext

    posting_info.set_label("Uploading images")
    posttext = _local_img_to_server(wpclient, posttext, 'Wordpress')
    extendedtext = _local_img_to_server(wpclient, extendedtext, 'Wordpress')
    posting_info.set_label("Uploading content")

    posttext = set_technorati_tags(ttags, posttext)
    post.trackbacks = get_trackbacks(tbacks)

    postcats = []
    for i in cats:
        postcats.append(i[0])

    post.categories = postcats

    #Excerpt
    #start, end = self.txtBufferExc.get_bounds()
    #post.excerpt = self.txtBufferExc.get_text(start, end)

    #post status = draft, private, publish, pending
    post.status = status
    post.name = slug
    post.description = posttext
    if extendedtext != "<br /><br />":
        post.textMore = extendedtext

    if edited:
        newpostid = wpclient.editPost(postid, post)
    else:
        newpostid = wpclient.newPost(post)

    return newpostid

def get_trackbacks(trackbackURLS):
    trackbacklist = []
    for i in trackbackURLS.split(" "):
        for j in i.split(","):
            for k in j.split(";"):
                if (k != " " and k != ""):
                    trackbacklist.append(k)

    return trackbacklist

def set_technorati_tags(ttags, posttext):
    ttagslist = []
    for i in ttags.split(", "):
        for j in i.split(" ,"):
            for k in j.split(","):
                for l in k.split("; "):
                    for m in l.split(" ;"):
                        for n in m.split(";"):
                            if (n != " " and n != ""):
                                ttagslist.append(n)

    html_ttagslist = []
    for ttag in ttagslist:
        html = '<a href="http://technorati.com/tag/' + ttag + '" rel="tag">' + ttag + '</a>'
        html_ttagslist.append(html)

    final_ttags_text = (', ').join(html_ttagslist)

    #If there aren't tags
    if final_ttags_text == '':
        posttext = posttext
    #If there are tags add the links to main post
    else:
        posttext += '<br /><br />' + \
        '<p style="text-align: right"><small>Technorati Tags: ' + \
        final_ttags_text + '</small><br /></p>'

    return posttext

def _local_img_to_server(client, texto_post, blogsystem):
    ###upload local images, and change its filename for its url###
    if texto_post.find("file://") >= 0:
        import re
        for i in range(texto_post.count('file://')):
            hele = re.compile(r'"file://[^$%]+"')
            a = hele.findall(texto_post)
            if a[0].count('"') == 2:
                b = a[0]
                c = b.replace('"', '')
            else:
                b = a[0].split('"')
                for j in range(len(b)):
                    if b[j].find("file://") >= 0:
                        c = b[j].replace('"', '')

            d = c.replace('file://', '')
            if not os.path.exists(d):
                logger.error("Uploading image: File doesn't exist")

            if blogsystem == 'Wordpress':
                imageSrc = client.newMediaObject(d)
            elif blogsystem == 'Blogger':
                import gdata.photos.service
                service = gdata.photos.service.PhotosService()
                service.ClientLogin(str(client.email), str(client.password))

                ## Some code for MaemoPublishr :) ##
                img = None
                # Get album feed
                albums = service.GetUserFeed().entry
                # See if the album exists
                for a in albums:
                    if a.title.text == 'MaStory':
                        img = service.InsertPhotoSimple(a, 'mastory-image', '', d)
                # The selected album was not found, create new one
                if not img:
                    new_album = service.InsertAlbum(title='MaStory', \
                        summary='Images inserted with MaStory blogging client.')
                    img = service.InsertPhotoSimple(new_album, 'mastory-image', '', d)

                imageSrc = img.content.src

            ####if d is a edited temp image, delete it###
            if d.find('mastory') >= 0:
                os.remove(d)
            texto_post = texto_post.replace(c, imageSrc)
    return texto_post


def to_blogger(user, password, blogid, title, posttext, ttags, tags, status,
                edited, postid, rtags, posting_info, sch_time, sch_date,
                schedule_on):

    import gdata, atom
    try:
        bgclient = blogger.create_blogger_client(user, password)
    except:
        logger.exception("Creating Blogger client")
        return

    post = gdata.GDataEntry()
    post.title = atom.Title(title_type='xhtml', text=title)
    #Text
    posting_info.set_label("Uploading images")
    posttext = _local_img_to_server(bgclient, posttext, 'Blogger')
    posting_info.set_label("Uploading content")
    posttext = set_technorati_tags(ttags, posttext)
    post.content = atom.Content(content_type='html', text=posttext)

    ## Set labels to blogger post
    labels = tags
    if labels == '':
        labels = rtags
    else:
        if rtags == '':
            labels = labels
        else:
            labels = labels + ', ' + rtags

    if labels != '':
        post.category = atom.Category()
        post.category.term = labels
        post.category.scheme = "http://www.blogger.com/atom/ns#"

    # Get publish/draft post
    if status == 'draft':
        control = atom.Control()
        control.draft = atom.Draft(text='yes')
        post.control = control

    if schedule_on:
        import time

        post_date = (int(sch_date[0]), int(sch_date[1])+1, int(sch_date[2]), \
                    int(sch_time[0]), int(sch_time[1]), 00, 0, 0, -1)
        post_date = time.strftime("%Y-%m-%dT%H:%M:00.000", post_date)

        local = time.localtime()
        gmt = time.gmtime()
        logger.debug("local date: %s" % str(local))
        logger.debug("gmt date: %s" % str(gmt))
        local = local[3]
        gmt = gmt[3]

        diff = local-gmt

        if diff < 0:
            dst_sign = '-'
        else:
            dst_sign = '+'

        if abs(diff) < 10:
            post_date += '%s0%s:00' % (dst_sign, abs(diff))
        else:
            post_date += '%s%s:00' % (dst_sign, abs(diff))

        logger.debug("schedule date: %s" % str(post_date))

        #Date
        #post_date = '2008-08-11T18:00:00.000+02:00'
        post.published = atom.Published(text=post_date)

    if edited:
        new_post = bgclient.Put(post, postid)
    else:
        new_post = bgclient.Post(post, '/feeds/'+str(blogid)+'/posts/default')

    return new_post


def to_livejournal(user, password, posttext, title, tags, date, edited,
                        postid, rtags, comments, sch_time, sch_date, ttags,
                        schedule_on, status):

    from wordpy import livejournal
    ljclient = livejournal.create_livejournal_client(user, password)

    posttext = set_technorati_tags(ttags, posttext)
    posttext= posttext.replace('\n', '<br />')

    if comments:
        nocomments = 0
    else:
        nocomments = 1

    if tags == '':
        tags = rtags
    else:
        if rtags == '':
            tags = tags
        else:
            tags = tags + ', ' + rtags

    #Doesnt allow schedule post, just it's posted with a determined date
    #eventtime = '2008-08-12 15:05:06'

    if status == 'friends':
        status = 'usemask'
    elif status == 'publish':
        status = 'public'

    if edited:
        date = "%s-%s-%s %s:%s:00" % (date[0], date[1], date[2],
                                 date[3], date[4])
        result = ljclient.edit(postid, date, {'subject': title, 'event': posttext,
                                'taglist': tags, 'opt_nocomments' : nocomments,
                                'security': status})
    else:
        result = ljclient.post({'subject': title, 'event': posttext, 'taglist': tags,
                                'opt_nocomments' : nocomments, 'security': status})
    return result


def edit_post_status_wordpress(url, user, password, postid, status):
    wpclient = wordpress.create_wordpress_client(url, user, password)
    if wpclient is None:
        logger.error("Creating Wordpress client")
        return

    post = wpclient.getPost(postid)
    post.status = status
    #print 'status:', post.status
    ed = wpclient.editPost(postid, post)

def edit_post_status_drupal(url, user, password, postid, status):
    from wordpy import drupal
    dclient = drupal.create_drupal_client(url, user, password)
    if dclient is None:
        logger.error("Creating Drupal client")
        return

    post = dclient.getPost(postid)
    post.status = status
    #print 'status:', post.status
    ed = dclient.editPost(postid, post)

def edit_post_status_blogger(user, password, blogid, posturl, status):
    import gdata, atom
    try:
        bgclient = blogger.create_blogger_client(user, password)
    except:
        logger.exception("Creating Blogger client")
        return

    control = atom.Control()
    feed = bgclient.GetFeed('/feeds/'+str(blogid)+'/posts/default')
    for entry in feed.entry:
        if entry.GetEditLink().href == posturl:
            #print entry.control
            if status == 'draft':
                control.draft = atom.Draft(text='yes')
                entry.control = control
            else:
                control.draft = None
                entry.control = control

            bgclient.Put(entry, posturl)

def edit_post_status_lj(user, password, postid, status):

    from wordpy import livejournal
    ljclient = livejournal.create_livejournal_client(user, password)
    post = ljclient.get_post(postid)

    eventtime = post['eventtime']
    if not post.has_key('subject'):
        post['subject'] = ''
    if not post.has_key('event'):
        post['event'] = ''
    if not post.has_key('taglist'):
        post['taglist'] = ''
    if not post.has_key('opt_nocomments'):
        post['opt_nocomments'] = 0

    if status == 'friends':
        status = 'usemask'
    elif status == 'publish':
        status = 'public'

    post['security'] = status

    ljclient.edit(postid, eventtime, post)


def to_drupal(url, user, password, title, postpassw, tags, \
                pings, comments, posttext, extendedtext, status, \
                slug, cats, tbacks, ttags, edited, postid, \
                rtags, posting_info, sch_time, sch_date, schedule_on):
    from wordpy import drupal
    client = drupal.create_drupal_client(url, user, password)
    if client is None:
        logger.error("Creating Drupal client")
        return None
    post = drupal.DrupalPost()
    #Title
    post.title = title
    #post.password = postpassw

    #post.tags = tags
    #if post.tags == '':
    #    post.tags = rtags
    #else:
    #    if rtags == '':
    #        post.tags = post.tags
    #    else:
    #        post.tags = post.tags + ', ' + rtags

    # Allow Pings
    #if pings:
    #    post.allowPings = 'open'
    #else:
    #    post.allowPings = 'closed'

    # Allow Comments
    if comments:
        post.allowComments = True
    else:
        post.allowComments = False

#    if schedule_on:
#        import time
#        #sch_time = (17, 8)
#        #sch_date = (20, 8, 2008)
#        #date = (year, month, day, hour, minutes, seconds, weekday, yearday, dst)
#        # dst = -1 --> localtime
#        #if time.localtime()[8] == 0:
#        #    onehour = - 1
#        #else:
#        #    onehour = 0
#        local = time.localtime()
#        gmt = time.gmtime()
#        local = (local[3], local[4])
#        gmt = (gmt[3], gmt[4])

#        diff = (local[0]-gmt[0], local[1]-gmt[1])

#        post.date = (int(sch_date[0]), int(sch_date[1])+1, int(sch_date[2]), \
#                    int(sch_time[0])-diff[0], int(sch_time[1])-diff[1], 00, 0, 0, -1)

#        logger.debug("Date: %s" % str(post.date))

    #Text
    #extendedtext = '<br /><br />' + extendedtext

    posting_info.set_label("Uploading images")
    posttext = _local_img_to_server(client, posttext, 'Wordpress')
    #extendedtext = _local_img_to_server(wpclient, extendedtext, 'Wordpress')
    posting_info.set_label("Uploading content")

    if ttags:
        posttext += '\n\n'
    posttext = set_technorati_tags(ttags, posttext)
    #post.trackbacks = get_trackbacks(tbacks)

    #postcats = []
    #for i in cats:
    #    postcats.append(i[0])

    #post.categories = postcats

    #Excerpt
    #start, end = self.txtBufferExc.get_bounds()
    #post.excerpt = self.txtBufferExc.get_text(start, end)

    #post status = draft, private, publish, pending
    post.status = status
    #post.name = slug
    post.description = posttext
    #if extendedtext != "<br /><br />":
    #    post.textMore = extendedtext

    if edited:
        newpostid = client.editPost(postid, post)
    else:
        newpostid = client.newPost(post)

    return newpostid
