# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


## This is a MaStory module for input and output functions
## Very inspired in the original Wordpy's way to open and save posts.

from xml.dom import minidom
import logging

logger = logging.getLogger("io")

##Tag numbers for xml .wpx file
MAIN_TAG = 0
POST_TAG = 1
TITLE_TAG = 2
TEXT_TAG = 3
EXCERPT_TAG = 4
EXTENDED_ENTRY_TAG = 5
TTAGS_TAG = 6
TRACKS_TAG = 7
TAGS = 8
PASSWORD_TAG = 9
SLUG_TAG = 10
STATUS_TAG = 11
DATE_TAG = 12
SCHEDULEON = 13
ALLOWCOMM = 14
ALLOWPINGS = 15
RECTAGS = 16
CATS = 17

_xml_tags = {
    MAIN_TAG : "WordPy"
    , POST_TAG : "Post"
    , TITLE_TAG : "Title"
    , TEXT_TAG : "Text"
    , EXCERPT_TAG : "Excerpt"
    , EXTENDED_ENTRY_TAG : "Entry"
    , TTAGS_TAG : "TechnoratiTags"
    , TRACKS_TAG : "Trackbacks"
    , TAGS : "Tags"
    , PASSWORD_TAG: "Password"
    , SLUG_TAG: "Slug"
    , STATUS_TAG: "Status"
    , DATE_TAG: "Date"
    , SCHEDULEON : "ScheduleOn"
    , ALLOWCOMM: "AllowComments"
    , ALLOWPINGS: "AllowPings"
    , RECTAGS: "RecentTags"
    , CATS: "Categories"



}

def xml_load_from_file(xml_file, widget, utils):
    """Load a post from an xml file
    @param xml_file - string - path to file that we will load.
    @returns boolean - True success. False failure
    """

    #Init return value
    success = False
    #Load the xml_file to a document
    try:
        xml_document = minidom.parse(xml_file)
        if (xml_document):
            success = ((xml_load(xml_document)))
    except IOError, (errno, strerror):
        logger.exception("Loading post file")
        utils.show_info_banner(widget, "Error loading post file(%s): %s" % (errno, strerror))
    except:
        logger.exception("Loading post file")
        utils.show_info_banner(widget, "Error loading post file.")

    return success


def xml_load(xml_document):
    """Load the current blog post from an xml document.
    @param xml_document - xml.dom.minidom.Document object -
    The xml document that we will load the post from.
    @returns boolean True - success.  False - Failure."""

    title = ''
    post = ''
    excerpt = ''
    extended = ''
    technorati = ''
    trackbacks  = ''
    tags = ''
    postpassword = ''
    slug = ''
    status = ''
    date = ''
    scheduleon = ''
    comments = ''
    pings = ''
    rtags = ''
    cats = ''

    for node in xml_document.documentElement.childNodes:
        if (node.nodeName == _xml_tags[POST_TAG]):
            for item_node in node.childNodes:
                if (item_node.nodeName == _xml_tags[TITLE_TAG]):
                    """Set the title, the firstChild in this case is
                    the actual title text that we saved."""
                    #Make sure it's not a blank string
                    if (item_node.firstChild):
                        title = item_node.firstChild.nodeValue
                    else:
                        title = ''
                elif (item_node.nodeName == _xml_tags[TEXT_TAG]):
                    if (item_node.firstChild):
                        post = item_node.firstChild.nodeValue
                    else:
                        post = ''
                elif (item_node.nodeName == _xml_tags[EXCERPT_TAG]):
                    if (item_node.firstChild):
                        excerpt = item_node.firstChild.nodeValue
                    else:
                        excerpt = ''
                elif (item_node.nodeName == _xml_tags[EXTENDED_ENTRY_TAG]):
                    if (item_node.firstChild):
                        extended = item_node.firstChild.nodeValue
                    else:
                        extended = ''
                elif (item_node.nodeName == _xml_tags[TTAGS_TAG]):
                    if (item_node.firstChild):
                        technorati = item_node.firstChild.nodeValue
                    else:
                        technorati = ''
                elif (item_node.nodeName == _xml_tags[TRACKS_TAG]):
                    if (item_node.firstChild):
                        trackbacks = item_node.firstChild.nodeValue
                    else:
                        trackbacks = ""
                elif (item_node.nodeName == _xml_tags[TAGS]):
                    if (item_node.firstChild):
                        tags = item_node.firstChild.nodeValue
                    else:
                        tags = ""
                elif (item_node.nodeName == _xml_tags[PASSWORD_TAG]):
                    if (item_node.firstChild):
                        postpassword = item_node.firstChild.nodeValue
                    else:
                        postpassword = ""
                elif (item_node.nodeName == _xml_tags[SLUG_TAG]):
                    if (item_node.firstChild):
                        slug = item_node.firstChild.nodeValue
                    else:
                        slug = ""
                elif (item_node.nodeName == _xml_tags[STATUS_TAG]):
                    if (item_node.firstChild):
                        status = item_node.firstChild.nodeValue
                    else:
                        status = ""
                elif (item_node.nodeName == _xml_tags[DATE_TAG]):
                    if (item_node.firstChild):
                        date = item_node.firstChild.nodeValue
                    else:
                        date = ""
                elif (item_node.nodeName == _xml_tags[SCHEDULEON]):
                    if (item_node.firstChild):
                        scheduleon = item_node.firstChild.nodeValue
                    else:
                        scheduleon = "False"
                elif (item_node.nodeName == _xml_tags[ALLOWCOMM]):
                    if (item_node.firstChild):
                        comments = item_node.firstChild.nodeValue
                    else:
                        comments = "True"
                elif (item_node.nodeName == _xml_tags[ALLOWPINGS]):
                    if (item_node.firstChild):
                        pings = item_node.firstChild.nodeValue
                    else:
                        pings = "True"
                elif (item_node.nodeName == _xml_tags[RECTAGS]):
                    if (item_node.firstChild):
                        rtags = item_node.firstChild.nodeValue
                    else:
                        rtags = ""
                elif (item_node.nodeName == _xml_tags[CATS]):
                    if (item_node.firstChild):
                        cats = item_node.firstChild.nodeValue
                    else:
                        cats = ""

            #Break out of the topmost for loop
            break

    return (title, post, excerpt, extended, technorati, trackbacks, tags,
            postpassword, slug, status, date, scheduleon, comments, pings,
            rtags, cats)

def xml_save_to_file(xml_file, widget, utils, post):
    """Save the current post to xml_file
    @param xml_file - string - path to file that
    we will save the xml to.
    @returns boolean - True success. False failure
    """
    success = False
    impl = minidom.getDOMImplementation()
    xml_document = impl.createDocument(None, _xml_tags[MAIN_TAG], None)
    xml_save(xml_document, post)

    try:
        save_file = open(xml_file, 'w')
        xml_document.documentElement.writexml(save_file)
        save_file.close()
    except IOError, (errno, strerror):
        logger.exception("Saving post")
        utils.show_info_banner(widget, "Error saving post(%s): %s" % (errno, strerror))
    else:
        success = True

    return success

def xml_save(xml_document, post):
    """Save the current blog post to an xml document.
    @param xml_document - xml.dom.minidom.Document object -
    The xml document that we will save the post to."""

    post_element = xml_document.createElement(_xml_tags[POST_TAG])

    title = post[0]
    text = post[1]
    excerpt = post[2]
    extended_text = post[3]
    ttags_text = post[4]
    tracks_text = post[5]
    tags_text = post[6]
    postpassword_text = post[7]
    slug_text = post[8]
    status_text = post[9]
    date_text = post[10]
    scheduleon =  post[11]
    comments = post[12]
    pings = post[13]
    rtags = post[14]
    cats = post[15]


    # creates <title>title</title>
    title_element = xml_document.createElement(_xml_tags[TITLE_TAG])
    title_element.appendChild(xml_document.createTextNode(title))
    # creates <text>main post</text>
    text_element = xml_document.createElement(_xml_tags[TEXT_TAG])
    text_element.appendChild(xml_document.createTextNode(text))
    #create excerpt: <excerpt>excerpt text</excerpt>
    excerpt_element = xml_document.createElement(_xml_tags[EXCERPT_TAG])
    excerpt_element.appendChild(xml_document.createTextNode(excerpt))
    #create extended entry: <extended>extended text</extended>
    extended_element = xml_document.createElement(_xml_tags[EXTENDED_ENTRY_TAG])
    extended_element.appendChild(xml_document.createTextNode(extended_text))
    #create ttags: <ttags>technorati tags</ttags>
    ttags_element = xml_document.createElement(_xml_tags[TTAGS_TAG])
    ttags_element.appendChild(xml_document.createTextNode(ttags_text))
    #create trackbacks: <trackbacks>trackbacks</trackbacks>
    tracks_element = xml_document.createElement(_xml_tags[TRACKS_TAG])
    tracks_element.appendChild(xml_document.createTextNode(tracks_text))
    #create tags: <tags>tags</tags>
    tags_element = xml_document.createElement(_xml_tags[TAGS])
    tags_element.appendChild(xml_document.createTextNode(tags_text))
    #create password: <password>postpassword</password>
    postpassword_element = xml_document.createElement(_xml_tags[PASSWORD_TAG])
    postpassword_element.appendChild(xml_document.createTextNode(postpassword_text))
    #create slug: <slug>slug</slug>
    slug_element = xml_document.createElement(_xml_tags[SLUG_TAG])
    slug_element.appendChild(xml_document.createTextNode(slug_text))
    #create status: <status>status</status>
    status_element = xml_document.createElement(_xml_tags[STATUS_TAG])
    status_element.appendChild(xml_document.createTextNode(status_text))
    #create date: <date>date</date>
    date_element = xml_document.createElement(_xml_tags[DATE_TAG])
    date_element.appendChild(xml_document.createTextNode(date_text))

    schedule_element = xml_document.createElement(_xml_tags[SCHEDULEON])
    schedule_element.appendChild(xml_document.createTextNode(scheduleon))
    comments_element = xml_document.createElement(_xml_tags[ALLOWCOMM])
    comments_element.appendChild(xml_document.createTextNode(comments))
    pings_element = xml_document.createElement(_xml_tags[ALLOWPINGS])
    pings_element.appendChild(xml_document.createTextNode(pings))
    rtags_element = xml_document.createElement(_xml_tags[RECTAGS])
    rtags_element.appendChild(xml_document.createTextNode(rtags))
    cats_element = xml_document.createElement(_xml_tags[CATS])
    cats_element.appendChild(xml_document.createTextNode(cats))

    post_element.appendChild(title_element)
    post_element.appendChild(text_element)
    post_element.appendChild(excerpt_element)
    post_element.appendChild(extended_element)
    post_element.appendChild(ttags_element)
    post_element.appendChild(tracks_element)
    post_element.appendChild(tags_element)
    post_element.appendChild(postpassword_element)
    post_element.appendChild(slug_element)
    post_element.appendChild(status_element)
    post_element.appendChild(date_element)
    post_element.appendChild(schedule_element)
    post_element.appendChild(comments_element)
    post_element.appendChild(pings_element)
    post_element.appendChild(rtags_element)
    post_element.appendChild(cats_element)

    xml_document.documentElement.appendChild(post_element)
