# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


from wordpy import utils

def insert_htmltag(txtview, tag):
    if tag == 'bold':
        start = '<span style="font-weight: bold">'
        end = "</span>"
    elif tag == 'italic':
        start = '<span style="font-style: italic">'
        end = "</span>"
    elif tag == 'underline':
        start = '<span style="text-decoration:underline">'
        end = '</span>'
    elif tag == 'strikethrough':
        start = '<span style="text-decoration:line-through">'
        end = '</span>'
    elif tag == 'paragraph':
        start = '<p>'
        end = '</p>'
    elif tag == 'left':
        start = '<div style="text-align: left">'
        end = '</div>'
    elif tag == 'right':
        start = '<div style="text-align: right">'
        end = '</div>'
    elif tag == 'center':
        start = '<div style="text-align: center">'
        end = '</div>'
    elif tag == 'justify':
        start = '<div style="text-align: justify">'
        end = '</div>'
    elif tag == 'code':
        start = '<code>'
        end = '</code>'
    elif tag == 'quote':
        start = '<blockquote>'
        end = '</blockquote>'
    elif tag == 'li':
        start = '<li>'
        end = '</li>'
    elif tag == 'ul':
        start = '<ul>'
        end = '</ul>'
    elif tag == 'ol':
        start = '<ol>'
        end = '</ol>'
    elif tag == 'sup':
        start = '<sup>'
        end = '</sup>'
    elif tag == 'sub':
        start = '<sub>'
        end = '</sub>'
    elif tag == 'tt':
        start = '<tt>'
        end = '</tt>'
    elif tag == 'cite':
        start = '<cite>'
        end = '</cite>'
    else:
        return

    utils.wrap_selection(txtview, start, end)

def insert_link_tag(txtview, url, text):
    start = '<a href=\"%s\">' % url
    end = text + '</a>'
    utils.wrap_selection(txtview, start, end)

def insert_abbr_or_acronym_tag(txtview, tag, abbr, text):
    if tag == 'abbr':
        start = '<abbr title="%s">' % abbr
        end = text + '</abbr>'
    elif tag == 'acronym':
        start = '<acronym title="%s">' % abbr
        end = text + '</acronym>'

    utils.wrap_selection(txtview, start, end)

def insert_fontsize(txtview, fontsize, text):
    start = '<span style="font-size:%s">' % fontsize
    end = text + '</span>'
    utils.wrap_selection(txtview, start, end)

def insert_bgcolor_or_fontcolor(txtview, color, tag, text):
    if tag == 'fontcolor':
        start = '<span style="color:%s">' % color
        end = text + '</span>'
        utils.wrap_selection(txtview, start, end)
    elif tag == 'bgcolor':
        start = '<span style="background-color:%s">' % color
        end = text + '</span>'
        utils.wrap_selection(txtview, start, end)
