# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#Some code is from the canola-flickr-plugin
#License: GPL3

import flickrapi
import os
from wordpy import utils

flickr_apikey = 'c5c97bf7c85c7a5351cf9e1a2a433678'
flickr_secret = 'a20834f00befce6a'

pixelpipe_apikey = '95abd1c6b1bba566f76476405c5d2cc9'
pixelpipe_secret = 'f81fb323deef27f4'

def attributesFromDict(d, obj=None, objName="self"):
    '''see http://code.activestate.com/recipes/280381/'''
    if obj is None:
        obj = d.pop(objName)
    for n, v in d.iteritems():
        setattr(obj, n, v)

def authorize_on_flickr(widget, pixelpipe):
    flickr = Flickr('auth', pixelpipe)
    res = flickr.login()
    if not res == True:
        utils.show_info_dialog(widget,
                    "Press after you have given MaStory authorization.")
        res = flickr.login()
        if not res == True:
            utils.show_info_banner(widget,
                    "Error, could not get access to account!")
            return -1
    else:
        utils.show_info_banner(widget,
                    "You already have allowed access to service")

class Flickr:
    def __init__(self, username, pixelpipe):
        attributesFromDict(locals())

        if pixelpipe:
            if username == 'auth':
                flickrapi.FlickrAPI.flickr_host = "m.pixelpipe.com"
            else:
                flickrapi.FlickrAPI.flickr_host = "api.pixelpipe.com"
            self.flickr = flickrapi.FlickrAPI(pixelpipe_apikey, pixelpipe_secret)

        else:
            flickrapi.FlickrAPI.flickr_host = "api.flickr.com"
            self.flickr = flickrapi.FlickrAPI(flickr_apikey, flickr_secret)


        self.logged = False
        self.token  = None
        self.frob   = None

    def login(self):
        if not self.frob and not self.token:
            token, self.frob = self.flickr.get_token_part_one(perms='write')
            if not token:
                self.token = None
                return False
            else: self.token = token

        self.token = self.flickr.get_token_part_two((self.token, self.frob))
        if not self.token:
            self.logged = False
        else: self.logged = True
        return self.logged

    def delete_token(self):
        token = os.path.join(os.path.expanduser("~"), ".flickr", self.api_key, \
                             "auth.token")

        if os.path.exists(token):
            os.unlink(token)
            return True
        else:
            return False

    def get_photolist(self, per_page, page):
        one_size = []
        one_width = []
        one_height = []
        one_url = []
        sizes = []
        urls = []
        photos = []
        widths = []
        heights = []

        lista = self.flickr.photos_Search(user_id='me', per_page=per_page, \
                                          page=page)

        photolist = lista.find('photos')
        photo_xml = photolist.findall('photo')

        if int(photolist.attrib['pages']) < int(page):
            return None
        ## try get more photos than there is, change perpage variable
        if int(photolist.attrib['page']) * \
                    int(per_page) > int(photolist.attrib['total']):
            perpage = int(photolist.attrib['total']) - \
                    ((int(photolist.attrib['page'])-1) * int(per_page))
        else:
            perpage = int(per_page)

        for i in range(perpage):
            del one_size[:]
            del one_width[:]
            del one_height[:]
            del one_url[:]
            photos.append(photo_xml[i].attrib['title'])
            data = self.flickr.photos_getSizes(photo_id=photo_xml[i].attrib['id'])
            sizes_xml = data.find('sizes').findall('size')
            for psize in sizes_xml:
                one_size.append(psize.attrib['label'])
                one_width.append(psize.attrib['width'])
                one_height.append(psize.attrib['height'])
                one_url.append(psize.attrib['source'])
            sizes.append(tuple(one_size))
            widths.append(tuple(one_width))
            heights.append(tuple(one_height))
            urls.append(tuple(one_url))

        return photos, sizes, widths, heights, urls

    def upload(self, photos, filename_lb):
        #photos=[[filename, title, desc, tags, pub, friend, family, [sets_id]]]
        for i in range(len(photos)):
            filename_lb.set_text(os.path.basename(photos[i][0]))
            photo_id = self.flickr.upload(filename = photos[i][0],
                        title = photos[i][1], description = photos[i][2],
                        tags = photos[i][3], is_public = photos[i][4],
                        is_friend = photos[i][5], is_family = photos[i][6])

            upload_id = photo_id.find('photoid').text

            if photos[i][7] != []:
                for j in range(len(photos[i][7])):
                    self.flickr.photosets_addPhoto(photoset_id =
                            photos[i][7][j], photo_id = upload_id)

    def get_set_list(self):
        setlist = []
        lista = self.flickr.photosets_getList()

        sets_xml = lista.find('photosets').findall('photoset')

        for i in sets_xml:
            title = i.find('title').text
            set_id = i.attrib['id']
            one_set = (set_id, title)
            setlist.append(one_set)

        return setlist
