# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


import gdata.service

blogs = []

def create_blogger_client(user, password):
    """Creates a GDataService and provides ClientLogin auth details to it.
    """
    # Authenticate using ClientLogin.
    service = gdata.service.GDataService()
    service.email = user
    service.password = password
    service.source = 'MaStory'
    service.service = 'blogger'
    service.server = 'www.blogger.com'
    service.ProgrammaticLogin()

    return service

def get_blog_list(bgclient):
    del blogs[:]

    feed = bgclient.Get('/feeds/default/blogs')

    for i in range(len(feed.entry)):
        blogs.append([feed.entry[i].title.text, feed.entry[i].id.text.split('-')[-1]])

    return blogs

def get_posts_with_status(user, password, blogid, numposts):
    bgclient = create_blogger_client(user, password)
    # Request the feed.

    feed = bgclient.GetFeed('/feeds/'+str(blogid)+'/posts/default?max-results=' +\
                            str(numposts))
    posts = []
    for entry in feed.entry:
        title = entry.title.text
        url = entry.GetEditLink().href
        if entry.control is not None:
            status = 'draft'
        else:
            status = 'publish'
        post = [title, url, status]
        posts.append(post)

    return posts

def encode_technorati_tags(content_text):
    import re
    techno_tags = []
    hele = re.compile(r'"http://technorati.com/tag/[^$%]+"')
    a = hele.findall(content_text)
    b = a[0].split('"')
    for j in range(len(b)):
        if b[j].find("http://technorati.com/tag/") >=0:
            c = b[j].replace('http://technorati.com/tag/', '')
            techno_tags.append(c)

    tech_tags_entries = (', ').join(techno_tags)

    if content_text.find("<small>Technorati Tags:") >= 0:
        descr = content_text.partition('<br /><br /><p style="text-align: right"><small>Technorati Tags:')
    else:
        descr = content_text.partition('<br /><br /><p style="text-align:right;">Technorati Tags:')

    return descr[0], tech_tags_entries

def get_post_filtered(user, password, postid, blogid):
    bgclient = create_blogger_client(user, password)
    feed = bgclient.GetFeed('/feeds/'+str(blogid)+'/posts/default')

    title = ''
    content = ''
    extended = ''
    excerpt = ''
    ttags = ''
    tracks = ''
    cats = ''
    slug = ''
    pssword = ''
    comments = 1
    pings = 1
    postid = postid

    label_list = []
    for entry in feed.entry:
        if entry.GetEditLink().href == postid:
            if entry.title.text is not None:
                title = entry.title.text
            if entry.content.text is not None:
                if entry.content.text.find("Technorati Tags:") >= 0:
                    content, ttags = encode_technorati_tags(entry.content.text)
                else:
                    content = entry.content.text

            #date=2008-09-15T11:11:00.001-07:00
            postdate = entry.published.text
            year, month, day = postdate.split('T')[0].split('-')
            hour = postdate.split('T')[1].split(':')[0]
            minutes = postdate.split('T')[1].split(':')[1]
            date = [year, month, day, hour, minutes]

            for i in entry.category:
                label_list.append(i.term)
            tags = (', ').join(label_list)
            if entry.control is not None:
                status = 'draft'
            else:
                status = 'publish'

    return (title, content, extended, excerpt, ttags, tracks, tags, cats, date, \
            slug, pssword, comments, pings, status, postid)


def get_comments_filtered(user, password, postid, blogid, numcomm):
    bgclient = create_blogger_client(user, password)

    # Build comment feed URI and request comments on the specified post

    posturl = postid.split('/')
    postid = posturl[len(posturl)-1]

    feed_url = '/feeds/%s/%s/comments/default?max-results=%s' % (str(blogid),
                str(postid),  str(numcomm))

    comments = []

    try:
        feed = bgclient.Get(feed_url)
    except:
        return comments


    for entry in feed.entry:
        comments.append([entry.GetEditLink().href.split("/")[-1],
                        entry.title.text, entry.author[0].name.text,
                        entry.author[0].email.text,
                        entry.author[0].uri.text, 'published'])

    return comments

def delete_comment(user, password, blogid, postid, commid):
    bgclient = create_blogger_client(user, password)
    posturl = postid.split('/')
    postid = posturl[len(posturl)-1]

    feed_uri = '/feeds/%s/%s/comments/default/%s' % (str(blogid),
                                                    str(postid), str(commid))

    bgclient.Delete(feed_uri)

def new_comment(user, password, blogid, postid, text):
    import atom
    bgclient = create_blogger_client(user, password)
    posturl = postid.split('/')
    postid = posturl[len(posturl)-1]

    feed_uri = '/feeds/%s/%s/comments/default' % (str(blogid), str(postid))

    entry = gdata.GDataEntry()
    entry.content = atom.Content(content_type='xhtml', text=text)

    try:
        comment = bgclient.Post(entry, feed_uri)
    except:
        comment = None

    print comment

    return comment
