#!/usr/bin/env python
# -*- coding: UTF8 -*-
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# MaStory: Blogging client for Internet Tablets
# Version 2.0
#


import gtk
import hildon
import gobject
import thread
import os
import logging
import pango
from wordpy import utils, settings, fancy_button

import osso
osso_c = osso.Context("org.maemo.mastory", "2.0", False)

#detect if it runs locally or not
import sys
runningpath = sys.path[0]

if '/opt/' in runningpath:
    locally = False
else:
    locally = True

HOME = os.path.expanduser("~")
accounts_db, settings_db, appdir, imgdir, configdir, \
    logfile = settings.define_paths(locally, HOME)


logger = logging.getLogger('mw2')
logging.basicConfig(filename=logfile, level=logging.ERROR, filemode='w')

DEBUG = True

if DEBUG:
    #set the main logger to DEBUG
    logger.setLevel(logging.DEBUG)

    #Create a handler for console debug
    console = logging.StreamHandler()
    console.setLevel(logging.DEBUG)
    # set a format which is simpler for console use
    formatter = logging.Formatter('%(name)-12s: %(levelname)-8s %(message)s')
    # tell the handler to use this format
    console.setFormatter(formatter)
    logging.getLogger('').addHandler(console)


#Some defines very used in the code
fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
thsize = gtk.HILDON_SIZE_THUMB_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
verbtn = hildon.BUTTON_ARRANGEMENT_VERTICAL
ui_normal = gtk.HILDON_UI_MODE_NORMAL
ui_edit = gtk.HILDON_UI_MODE_EDIT
winprogind = hildon.hildon_gtk_window_set_progress_indicator

all_images = []

gtk.gdk.threads_init()


class WordpyUI:

    def __init__(self):
        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name("MaStory")

        self.window = hildon.StackableWindow()
        self.window.connect("key-press-event", self.on_key_press)
        self.window.set_default_size(800, 480)
        self.window.connect("destroy", self.quit_and_save)
        self.program.add_window(self.window)

        #These are some widgets defined later
        self.entitle = False
        self.txtPost = False
        self.txtPostExt = False
        self.enttags = False
        self.enpostpassw = False
        self.enslug = False
        self.entags = False
        self.imglist_model = False
        self.flickr_photolist = False
        self.picasa_photolist = False

        self.edit_pixbuf = None
        self.account_id = None
        self.imgpath = ''
        self.xml_file = None
        self.imgservice = 'Flickr'
        self.preserve_aspect = True
        self.resize_preserve_aspect = True
        self.ignore_preserve_aspect_callback = False
        self.imgalign = 'none'
        self.alttext = ''
        self.aligntext = False
        self.origimg = True
        self.imgwidth = False
        self.imgheight = False
        #FIXME: cancel uploads working
        #self.cancel_media_upload = False

        self.selecting_text = False

        self.initialize_post_data()

        ## Get the default settings and account
        ##[[name, blogsystem, user, password, blogid, blogname, url, enabled]]
        try:
            self.set_default_settings()
        except:
            logger.exception('Getting the default settings')


        menu = self.make_menu(True)
        self.window.set_app_menu(menu)

        vbox = self.initial_screen()
        self.window.add(vbox)

        self.window.show_all()

        #TODO: when the screenshot cheat is fixed, maybe this is useful
        #self.expose_hid = self.window.connect('expose-event', self.take_screenshot)

        if self.autosave_time != 0:
            self.autosave_timer = gobject.timeout_add \
                        (int(self.autosave_time*60000), self.check_autosave)

    def take_screenshot(self, event = None, data = None):
        self.window.disconnect(self.expose_hid)
        if not os.path.isfile("/home/user/.cache/launch/org.maemo.mastory.pvr"):
            gobject.timeout_add(80, hildon.hildon_gtk_window_take_screenshot,
                                self.window, True)


    def make_menu(self, initial):
        """
        This is the menu for the main windows
        """
        menu = hildon.AppMenu()

        button = gtk.Button("New")
        button.connect("clicked", self.on_new_post, 'menu')
        menu.append(button)

        button = gtk.Button("Open")
        button.connect("clicked", self.on_open_post)
        menu.append(button)

        button = gtk.Button("Save")
        button.connect("clicked", self.on_save_post, '', '')
        menu.append(button)

        button = gtk.Button("Save as")
        button.connect("clicked", self.on_saveas_post)
        menu.append(button)

        if not initial:
            button = hildon.CheckButton(fhsize)
            button.set_label("Select text")
            button.set_active(self.selecting_text)
            menu.append(button)
            button.connect("toggled", self.on_selected_text_menu)

        button = gtk.Button("Log")
        button.connect("clicked", self.on_show_log)
        menu.append(button)

        button = gtk.Button("About")
        button.connect("clicked", About)
        menu.append(button)

        menu.show_all()
        return menu

    #STUPID WORKAROUND FOR BUG #4619:
    #Basically destroy the old textview+parent and create the new ones.
    #It saves the old text, and put it in the new textview.
    def on_selected_text_menu(self, widget):
        if widget.get_active():
            self.selecting_text = True
            self.put_selecting_textview()
        else:
            self.selecting_text = False
            self.put_panning_textview()


    def put_selecting_textview(self):
        if self.txtPost:
            start, end = self.postBuffer.get_bounds()
            self.posttext = self.postBuffer.get_text(start, end)

            parentwidget = self.txtPost.get_parent().get_parent()
            self.txtPost.get_parent().destroy()

            self.txtPost = gtk.TextView()
            textview_menu = self.tapholdmenu()
            self.txtPost.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
            self.txtPost.modify_font(pango.FontDescription("Normal "+self.fontsize))
            self.txtPost.set_wrap_mode(gtk.WRAP_WORD)

            self.postBuffer = self.txtPost.get_buffer()
            self.postBuffer.set_text(self.posttext)

            parea = gtk.ScrolledWindow()
            parea.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
            hildon.hildon_helper_set_thumb_scrollbar(parea, True)
            parea.add(self.txtPost)
            parea.show_all()
            parentwidget.pack_start(parea, True, True, 0)
            parentwidget.reorder_child(parea, 1)
            parentwidget.show()

        if self.txtPostExt:
            start, end = self.extendedBuffer.get_bounds()
            self.extendedtext = self.extendedBuffer.get_text(start, end)

            try:
                parentwidget = self.txtPostExt.get_parent().get_parent()
                self.txtPostExt.get_parent().destroy()

                self.txtPostExt = gtk.TextView()
                textview_menu = self.tapholdmenu()
                self.txtPostExt.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
                self.txtPostExt.modify_font(pango.FontDescription("Normal "+self.fontsize))
                self.txtPostExt.set_wrap_mode(gtk.WRAP_WORD)

                self.extendedBuffer = self.txtPostExt.get_buffer()
                self.extendedBuffer.set_text(self.extendedtext)
                parea = gtk.ScrolledWindow()
                parea.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
                hildon.hildon_helper_set_thumb_scrollbar(parea, True)
                parea.add(self.txtPost)
                parea.show_all()
                parentwidget.pack_start(parea, True, True, 0)
                parentwidget.reorder_child(parea, 1)
                parentwidget.show()
            except:
                pass

    def put_panning_textview(self):
        if self.txtPost:
            start, end = self.postBuffer.get_bounds()
            self.posttext = self.postBuffer.get_text(start, end)

            parentwidget = self.txtPost.get_parent().get_parent()
            self.txtPost.get_parent().destroy()

            self.txtPost = hildon.TextView()
            textview_menu = self.tapholdmenu()
            self.txtPost.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
            self.txtPost.modify_font(pango.FontDescription("Normal "+self.fontsize))
            self.txtPost.set_wrap_mode(gtk.WRAP_WORD)
            self.postBuffer = self.txtPost.get_buffer()
            self.postBuffer.set_text(self.posttext)
            parea = hildon.PannableArea()
            parea.add(self.txtPost)
            parea.show_all()
            parentwidget.pack_start(parea, True, True, 0)
            parentwidget.reorder_child(parea, 1)
            parentwidget.show()
        if self.txtPostExt:
            start, end = self.extendedBuffer.get_bounds()
            self.extendedtext = self.extendedBuffer.get_text(start, end)

            try:
                parentwidget = self.txtPostExt.get_parent().get_parent()
                self.txtPostExt.get_parent().destroy()

                self.txtPostExt = hildon.TextView()
                textview_menu = self.tapholdmenu()
                self.txtPost.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
                self.txtPost.modify_font(pango.FontDescription("Normal "+self.fontsize))
                self.txtPost.set_wrap_mode(gtk.WRAP_WORD)
                self.extendedBuffer = self.txtPostExt.get_buffer()
                self.extendedBuffer.set_text(self.extendedtext)
                parea = hildon.PannableArea()
                parea.add(self.txtPostExt)
                parea.show_all()
                parentwidget.pack_start(parea, True, True, 0)
                parentwidget.reorder_child(parea, 1)
                parentwidget.show()
            except:
                pass

    def initial_screen(self):
        vbox1 = gtk.VBox()

        hbox1 = gtk.HBox()
        hbox2 = gtk.HBox()
        hbox2.set_homogeneous(True)
        hbox3 = gtk.HBox()
        hbox3.set_homogeneous(True)

        vbox2 = gtk.VBox()
        hbox4 = gtk.HBox()

        self.recentposts_title = gtk.Label()
        self.recentposts_title.set_markup("<b>Recent Posts:</b>")
        self.recentposts = gtk.Label()

        self.set_recentposts_to_label()

        label3 = gtk.Label()
        label3.set_markup("<b>Welcome to MaStory</b>")

        hbox4.pack_start(label3, True, True, 0)

        vbox2.pack_start(hbox4, True, True, 0)
        vbox2.pack_start(self.recentposts_title, True, True, 0)
        vbox2.pack_start(self.recentposts, True, True, 0)

        hbox1.pack_start(vbox2, True, True, 0)

        image1 = gtk.Image ()
        image1.set_from_file(imgdir + "newpost.png")
        image1.set_pixel_size (164)

        image2 = gtk.Image ()
        image2.set_from_file(imgdir + "manageposts.png")
        image2.set_pixel_size (164)

        image3 = gtk.Image ()
        image3.set_from_file(imgdir + "settings.png")
        image3.set_pixel_size (164)

        image4 = gtk.Image ()
        image4.set_from_file(imgdir + "upload.png")
        image4.set_pixel_size (164)


        button1 = fancy_button.FancyButton(image1, "Create post")
        button1.connect("clicked", self.post_screen)

        button2 = fancy_button.FancyButton(image2, "Manage posts")
        button2.connect("clicked", self.manageposts_screen)

        button3 = fancy_button.FancyButton(image3, "Manage settings")
        button3.connect("clicked", self.settings_screen)

        button4 = fancy_button.FancyButton(image4, "Upload media")
        button4.connect("clicked", self.media_screen)

        hbox2.pack_start(button1, True, True, 0)
        hbox2.pack_start(button2, True, True, 0)
        hbox2.pack_start(button3, True, True, 0)
        hbox2.pack_start(button4, True, True, 0)

        vbox1.pack_start(hbox1, True, True, 5)
        vbox1.pack_start(hbox2, False, False, 5)

        return vbox1

    def set_recentposts_to_label(self):
        try:
            recentposts = RecentPosts()
            recentposts_txt = recentposts.get()
            self.recentposts_title.set_markup("<b>Recent Posts:</b>")
            self.recentposts.set_markup(recentposts_txt)
        except:
            logger.exception('Getting the recent posts info')


    def post_screen(self, widget):
        if self.entitle:
            self.title = self.entitle.get_text()

        if self.txtPost:
            start, end = self.postBuffer.get_bounds()
            self.posttext = self.postBuffer.get_text(start, end)

        self.set_recentposts_to_label()

        win = hildon.StackableWindow()
        win.connect("key-press-event", self.on_key_press)
        win.set_title("Creating post")
        menu = self.make_menu(False)
        win.set_app_menu(menu)
        vbox1 = gtk.VBox()

        hbox1 = gtk.HBox()

        self.entitle = hildon.Entry(fhsize)
        self.entitle.set_placeholder("Write the title")
        self.entitle.set_text(self.title)

        self.post_edited_btn = hildon.Button(fhsize, horbtn)
        #self.post_edited_btn.set_no_show_all(True)
        self.post_edited_btn.connect("clicked", self.show_is_edited_post)
        img = gtk.Image()
        img.set_from_file(imgdir + 'post_edited.png')
        self.post_edited_btn.set_image(img)

        hbox1.pack_start(self.entitle, True, True, 0)
        hbox1.pack_start(self.post_edited_btn, False, False, 0)

        textview_menu = self.tapholdmenu()

        #FIXME: selection mode? Check bug 4619.
        if self.selecting_text:
            self.txtPost = gtk.TextView()
            parea = gtk.ScrolledWindow()
            parea.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
            hildon.hildon_helper_set_thumb_scrollbar(parea, True)
        else:
            self.txtPost = hildon.TextView()
            self.txtPost.set_placeholder("Write the post here")
            parea = hildon.PannableArea()

        self.txtPost.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
        self.txtPost.modify_font(pango.FontDescription("Normal "+self.fontsize))
        self.txtPost.set_wrap_mode(gtk.WRAP_WORD)
        self.postBuffer = self.txtPost.get_buffer()
        self.postBuffer.set_text(self.posttext)


        parea.add(self.txtPost)

        post_tb = self.post_toolbar(True, "main")

        vbox1.pack_start(hbox1, False, False, 0)
        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(post_tb, False, False, 0)

        win.add(vbox1)
        win.show_all()

        if self.is_edited:
            self.post_edited_btn.show()
        else:
            self.post_edited_btn.hide()

    def tapholdmenu(self):
        menu = gtk.Menu()

        item = gtk.MenuItem("Bigger text")
        event = gtk.gdk.Event(gtk.gdk.KEY_PRESS)
        event.keyval = hildon.KEY_INCREASE
        item.connect('activate', self.on_key_press, event)
        item.set_size_request(-1, 75)
        menu.append(item)
        item.show()

        item = gtk.MenuItem("Smaller text")
        event = gtk.gdk.Event(gtk.gdk.KEY_PRESS)
        event.keyval = hildon.KEY_DECREASE
        item.connect('activate', self.on_key_press, event)
        item.set_size_request(-1, 75)
        menu.append(item)
        item.show()

        menu.show()

        return menu

    def post_toolbar(self, show_adv, screen):
        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "image.png")
        button.set_image(img)
        button.connect("clicked", self.images_screen, screen)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.add_link_dlg, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "link.png")
        button.set_image(img)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "paragraph.png")
        button.set_image(img)
        button.connect("clicked", self.insert_htmltags, 'paragraph',
                        False, screen)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "add.png")
        button.set_image(img)
        button.connect("clicked", self.show_more_tags, screen)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "advanced.png")
        button.set_image(img)
        button.connect("clicked", self.advanced_screen)
        if show_adv:
            hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "tags.png")
        button.set_image(img)
        button.connect("clicked", self.tagscats_screen)
        hbox1.pack_start(button, True, True, 0)
        if self.blogsystem == "Drupal":
            button.set_sensitive(False)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imgdir + "preview.png")
        button.set_image(img)
        button.connect("clicked", self.preview_screen)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.publish_post)
        if not show_adv:
            self.pubimage = gtk.Image()
            self.pubimage.set_from_file(imgdir + "up.png")
            button.set_image(self.pubimage)
        else:
            self.pubimage2 = gtk.Image()
            self.pubimage2.set_from_file(imgdir + "up.png")
            button.set_image(self.pubimage2)
        hbox1.pack_start(button, True, True, 0)

        if self.status == "draft":
            self.set_draft_image()
        else:
            self.set_publish_image()

        return hbox1

    def set_draft_image(self):
        try:
            self.pubimage.set_from_file(imgdir + "draft.png")
        except:
            pass
        try:
            self.pubimage2.set_from_file(imgdir + "draft.png")
        except:
            pass

    def set_publish_image(self):
        try:
            self.pubimage.set_from_file(imgdir + "up.png")
        except:
            pass
        try:
            self.pubimage2.set_from_file(imgdir + "up.png")
        except:
            pass

    def preview_screen(self, widget):
        try:
            import gtkhtml2
        except:
            logger.exception('Preview not available')
            utils.show_info_banner(widget, 'Error previewing post')
            return

        win = hildon.StackableWindow()
        win.set_title("Preview post")

        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()
        parea.set_property("vovershoot-max", 0)
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)

        self.htmlview = gtkhtml2.View()
        self.htmlview.set_sensitive(False)
        parea.add(self.htmlview)

        win.add(parea)
        win.show_all()

        winprogind(win, 1)
        thread.start_new_thread(self.show_preview, (win, gtkhtml2))

    def show_preview(self, win, gtkhtml2):
        document = gtkhtml2.Document()
        document.connect('request-url', self.request_url)
        document.clear()
        document.open_stream('text/html')
        start, end = self.postBuffer.get_bounds()
        texto_buff = self.postBuffer.get_text(start, end)

        if self.txtPostExt:
            ebuffer = self.txtPostExt.get_buffer()
            ext_start, ext_end = ebuffer.get_bounds()
            ext_texto_buff = ebuffer.get_text(ext_start, ext_end)
            if not ext_texto_buff == "":
                texto_buff = texto_buff + \
                            '\n\n<a href="">[READ MORE]</a>\n\n' + \
                            ext_texto_buff

        html_final = texto_buff.replace("\n", "<br />")
        #CSS: <link type="text/css" rel="stylesheet" href="url"></link>
        header = '<html><head>' + \
        '<meta http-equiv=content-type content="text/html; charset=UTF-8">' \
        + '</head>'
        title = "<h1>"+self.entitle.get_text()+"</h1><br /><br />"
        body = "<body>"+title+html_final+"</body></html>"
        htmlpage = header+body
        document.write_stream(htmlpage)
        document.close_stream()
        self.htmlview.set_document(document)
        winprogind(win, 0)

    def request_url(self, doc, url, stream):
        from gnome import gnomevfs
        try:
            f = gnomevfs.open(url, gnomevfs.OPEN_READ)
        except:
            logger.exception('Opening url: %s' % url)
            stream.close()
            return

        while 1:
            try:
                stream.write(f.read(1024))
            except gnomevfs.EOFError:
                break
        f.close()
        stream.close()

    def add_link_dlg(self, widget, screen):
        if screen == "main":
            textview = self.txtPost
        elif screen == "advanced":
            textview = self.txtPostExt

        dialog = gtk.Dialog(title='Add link', parent=None, flags=0)
        dialog.set_has_separator(False)
        dialog.add_button("Add", gtk.RESPONSE_OK)

        entry1 = hildon.Entry(fhsize)
        entry1.set_text("http://")
        entry1.select_region(7, 7)
        entry1.set_placeholder("URL")

        entry2 = hildon.Entry(fhsize)
        entry2.set_placeholder("text")

        start, end = utils.get_selection_iters(textview)
        text = textview.get_buffer().get_text(start, end)
        entry2.set_text(text)
        textview.get_buffer().delete(start, end)

        dialog.vbox.pack_start(entry2, False, False, 0)
        dialog.vbox.pack_start(entry1, False, False, 0)

        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_DELETE_EVENT:
            utils.insert_text(textview, text)
        elif result == gtk.RESPONSE_OK:
            from wordpy import htmltags
            url = entry1.get_text()
            text = entry2.get_text()
            htmltags.insert_link_tag(textview, url, text)

        dialog.destroy()

    def show_more_tags(self, widget, screen):
        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'bold', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "bold.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'italic', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "italic.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.fonttags_dlg, "fontcolor", screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "fontcolor.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.fonttags_dlg, "bgcolor", screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "bgcolor.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.fonttags_dlg, "fontsize", screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "fontsize.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 5)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'underline', \
                        True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "underline.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'strikethrough', \
                        True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "strikethrough.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'li', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "li.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'ul', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "ul.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'ol', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "ol.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 5)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'left', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "left.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'right', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "right.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'center', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "center.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'justify', \
                        True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "fill.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'tt', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "mono.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 5)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'sup', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "sup.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'sub', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "sub.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'cite', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "cite.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'code', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "code.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.insert_htmltags, 'quote', True, screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "quote.png")
        button.set_image(img)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 5)

        win = hildon.StackableWindow()
        win.set_title("Add HTML Tag")
        win.add(vbox1)
        win.show_all()

    def create_color_selector(self):
        selector = hildon.TouchSelector()
        colors = ["blue", "red", "green", "grey", "black", "white",
                    "brown", "yellow"]

        iconlist = []
        for i in colors:
            iconlist.append([i, imgdir + i + ".png"])

        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING)

        for item in iconlist:
            liter = lstore.append()
            lstore.set(liter, 1, item[0], 0, self.set_pix(item[1]))

        renderer = gtk.CellRendererPixbuf()
        column = selector.append_column(lstore, renderer)
        column.add_attribute(renderer, "pixbuf", 0)

        renderer = gtk.CellRendererText()
        column.pack_start(renderer, True)
        column.add_attribute(renderer, "text", 1)
        column.set_property("text-column", 1)

        return selector

    def set_pix(self, filename):
        import gc
        pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        gc.collect()
        return pixbuf

    def fonttags_dlg(self, widget, kind, screen):
        if kind == "fontcolor":
            title = "Select font color"
            data = ["blue", "red", "green", "grey", "black", "white"]
            btntitle = "Font color"
        elif kind == "fontsize":
            title = "Select font size"
            data = ["xx-small", "x-small", "small", "medium", "large", \
                    "x-large", "xx-large"]
            btntitle = "Font size"
        elif kind == "bgcolor":
            title = "Select background color"
            data = ["blue", "red", "green", "grey", "black", "white"]
            btntitle = "Background color"

        if screen == "main":
            textview = self.txtPost
        elif screen == "advanced":
            textview = self.txtPostExt

        dialog = gtk.Dialog(title=title, parent=None, flags=0)
        dialog.set_has_separator(False)
        dialog.add_button("Add", gtk.RESPONSE_OK)

        entry2 = hildon.Entry(fhsize)
        entry2.set_placeholder("text")

        start, end = utils.get_selection_iters(textview)
        text = textview.get_buffer().get_text(start, end)
        entry2.set_text(text)
        textview.get_buffer().delete(start, end)

        button1 = hildon.PickerButton(fhsize, horbtn)
        if kind == "bgcolor" or kind == "fontcolor":
            selector = self.create_color_selector()
        else:
            selector = self.create_selector(data)

        button1.set_selector(selector)
        button1.set_title(btntitle)
        button1.set_value(data[0])
        self.select_default_value(button1, data, selector)


        dialog.vbox.pack_start(entry2, False, False, 0)
        dialog.vbox.pack_start(button1, False, False, 0)

        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_DELETE_EVENT:
            utils.insert_text(textview, text)
        elif result == gtk.RESPONSE_OK:
            from wordpy import htmltags
            fontdata = button1.get_value()
            text = entry2.get_text()
            if kind == "fontsize":
                htmltags.insert_fontsize(textview, fontdata, text)
            else:
                htmltags.insert_bgcolor_or_fontcolor(textview, fontdata, \
                                                    kind, text)

            stack = self.window.get_stack()
            stack.pop_1()

        dialog.destroy()

    def advanced_screen(self, widget):
        spcbs = ["Livejournal", "Blogger", "Drupal"]
        if self.blogsystem in spcbs:
            self.publish_opt_screen(widget)
            return

        if self.txtPostExt:
            start, end = self.extendedBuffer.get_bounds()
            self.extendedtext = self.extendedBuffer.get_text(start, end)

        win = hildon.StackableWindow()
        win.connect("key-press-event", self.on_key_press)
        win.set_title("Creating post - Advanced")
        menu = self.make_menu(True)
        win.set_app_menu(menu)
        vbox1 = gtk.VBox()

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title("Publish Options")
        button1.connect("clicked", self.publish_opt_screen)

        textview_menu = self.tapholdmenu()

        #FIXME: selection mode? Check bug 4619.
        if self.selecting_text:
            self.txtPostExt = gtk.TextView()
            parea = gtk.ScrolledWindow()
            parea.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
            hildon.hildon_helper_set_thumb_scrollbar(parea, True)
        else:
            self.txtPostExt = hildon.TextView()
            self.txtPostExt.set_placeholder("Write the extended text here")
            parea = hildon.PannableArea()

        self.txtPostExt.tap_and_hold_setup(menu=textview_menu, callback=None, data=None)
        self.txtPostExt.modify_font(pango.FontDescription("Normal "
                                                        + self.fontsize))
        self.txtPostExt.set_wrap_mode(gtk.WRAP_WORD)

        self.extendedBuffer = self.txtPostExt.get_buffer()
        self.extendedBuffer.set_text(self.extendedtext)

        parea.add(self.txtPostExt)

        post_tb = self.post_toolbar(False, "advanced")

        vbox1.pack_start(button1, False, False, 0)
        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(post_tb, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def publish_opt_screen(self, widget):
        if self.enttags:
            self.ttags = self.enttags.get_text()
            self.postpassw = self.enpostpassw.get_text()
            self.slug = self.enslug.get_text()

        win = hildon.StackableWindow()
        win.set_title("Creating post - Advanced")
        vbox1 = gtk.VBox()

        self.statusbtn = hildon.PickerButton(fhsize, horbtn)
        if self.blogsystem == "Wordpress":
            data = ["publish", "draft", "pending", "private"]
        elif self.blogsystem == "Blogger" or self.blogsystem == "Drupal":
            data = ["publish", "draft"]
        elif self.blogsystem == "Livejournal":
            data = ["public", "private", "friends"]
        else:
            data = ["publish", "draft", "pending", "private"]
        selector = self.create_selector(data)
        self.statusbtn.set_selector(selector)
        self.statusbtn.set_title("Status")
        self.statusbtn.set_value(self.status)
        self.statusbtn.connect("value-changed", self.statusbtn_changed)
        self.select_default_value(self.statusbtn, data, selector)

        self.commentsbtn = hildon.CheckButton(fhsize)
        self.commentsbtn.connect("toggled", self.cmmbtn_toggled)
        self.commentsbtn.set_label("Allow Comments")
        self.commentsbtn.set_active(self.comments)

        self.pingsbtn = hildon.CheckButton(fhsize)
        self.pingsbtn.connect("toggled", self.pingbtn_toggled)
        self.pingsbtn.set_label("Allow Pings")
        self.pingsbtn.set_active(self.pings)

        hbox = gtk.HBox()
        hbox.pack_start(self.statusbtn, True, True, 5)
        hbox.pack_start(self.commentsbtn, True, True, 5)
        hbox.pack_start(self.pingsbtn, True, True, 5)
        vbox1.pack_start(hbox, False, False, 0)

        self.enttags = hildon.Entry(fhsize)
        self.enttags.set_placeholder("Technorati Tags")
        self.enttags.set_text(self.ttags)

        self.enpostpassw = hildon.Entry(fhsize)
        self.enpostpassw.set_placeholder("Post password")
        self.enpostpassw.set_property('hildon-input-mode', \
                                     gtk.HILDON_GTK_INPUT_MODE_FULL)
        self.enpostpassw.set_visibility(False)
        self.enpostpassw.set_text(self.postpassw)

        self.enslug = hildon.Entry(fhsize)
        self.enslug.set_placeholder("Post slug")
        self.enslug.set_text(self.slug)

        button = hildon.CheckButton(fhsize)
        button.set_label("Activate scheduled post")
        button.connect("toggled", self.schbtn_toggled)
        button.set_active(self.schedule_on)

        vbox1.pack_start(self.enttags, False, False, 0)
        vbox1.pack_start(self.enpostpassw, False, False, 0)
        vbox1.pack_start(self.enslug, False, False, 0)
        vbox1.pack_start(button, False, False, 0)

        self.dateschbtn = hildon.DateButton(fhsize, horbtn)
        self.timeschbtn = hildon.TimeButton(fhsize, horbtn)

        if self.sch_date:
            self.dateschbtn.set_date(self.sch_date[0], self.sch_date[1], \
                                    self.sch_date[2])
            self.timeschbtn.set_time(self.sch_time[0], self.sch_time[1])

        self.dateschbtn.connect("value-changed", self.dateschbtn_changed)
        self.timeschbtn.connect("value-changed", self.timeschbtn_changed)

        self.dateschbtn_changed(self.dateschbtn)
        self.timeschbtn_changed(self.timeschbtn)

        hbox = gtk.HBox()
        hbox.pack_start(self.dateschbtn, True, True, 0)
        hbox.pack_start(self.timeschbtn, True, True, 0)
        vbox1.pack_start(hbox, False, False, 0)

        win.add(vbox1)
        win.show_all()

        if self.blogsystem == "Livejournal":
            widgets = [self.enpostpassw, self.enslug, button, self.dateschbtn,
                        self.timeschbtn, self.pingsbtn]
            for i in widgets:
                i.set_sensitive(False)

        if self.blogsystem == "Blogger":
            widgets = [self.enpostpassw, self.enslug, self.pingsbtn,
                        self.commentsbtn]

            for i in widgets:
                i.set_sensitive(False)

        if self.blogsystem == "Drupal":
            widgets = [self.enpostpassw, self.enslug, button, self.dateschbtn,
                        self.timeschbtn, self.pingsbtn]

            for i in widgets:
                i.set_sensitive(False)

    def timeschbtn_changed(self, button):
        self.sch_time = button.get_time()
        logger.debug("time: %s" % str(self.sch_time))

    def dateschbtn_changed(self, button):
        self.sch_date = button.get_date()
        logger.debug("date: %s" % str(self.sch_date))

    def statusbtn_changed(self, button):
        self.status = button.get_value()

        if self.status == "draft":
            self.set_draft_image()
        else:
            self.set_publish_image()

        logger.debug("status: %s" % self.status)

    def cmmbtn_toggled(self, button):
        self.comments = button.get_active()
        logger.debug("comments: %s" % self.comments)

    def pingbtn_toggled(self, button):
        self.pings = button.get_active()
        logger.debug("pings: %s" % self.pings)

    def schbtn_toggled(self, button):
        self.schedule_on = button.get_active()
        logger.debug("schedule_on: %s" % self.schedule_on)

    def tagscats_screen(self, widget):
        if self.blogsystem == "Livejournal" or self.blogsystem == "Blogger":
            self.tags_screen(widget, None)
            return

        dialog = gtk.Dialog(title='Set categories or tags', parent=None)
        dialog.set_has_separator(False)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Categories')
        button.connect("clicked", self.cats_screen, dialog)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Tags')
        button.connect("clicked", self.tags_screen, dialog)
        hbox.pack_start(button, True, True, 0)

        dialog.vbox.pack_start(hbox, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def cats_screen(self, widget, dialog):
        dialog.destroy()
        win = hildon.StackableWindow()
        win.set_title("Select Categories")

        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_edit)
        selection = tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
        if self.cats == []:
            self.cats_model = self.__create_cats_model('')
        else:
            print self.cats
            #self.cats_model = self.__create_cats_model(self.cats)
        tv.set_model(self.cats_model)
        self._cats_tv_columns(tv)
        self.on_select_cats_tv(selection)
        selection.connect("changed", self.set_categories)
        parea.add(tv)

        hbox1 = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Get from server')
        button.connect("clicked", self.on_get_cats, win, tv)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Create new')
        button.connect("clicked", self.newcat_screen, win)
        hbox1.pack_start(button, True, True, 0)

        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(hbox1, False, False, 0)

        win.add(vbox1)
        win.show_all()


    def on_select_cats_tv(self, selection):
        for i in range(len(self.cats_model)):
            if [self.cats_model[i][0], self.cats_model[i][1]] in self.cats:
                seliter = self.cats_model.get_iter(i)
                selection.select_iter(seliter)

    def set_categories(self, selection):
        self.cats = []

        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        for i in iters:
            cat = [selmodel.get_value(i, 0), selmodel.get_value(i, 1)]
            self.cats.append(cat)

        logger.debug("chosen cats: %s" % self.cats)

    def newcat_screen(self, widget, win):
        if self.blogsystem == "":
            utils.show_info_banner(widget, "No account defined")
            return

        dialog = gtk.Dialog(title='Create new category', parent=None, flags=0)
        dialog.set_has_separator(False)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Create')

        entry1 = hildon.Entry(fhsize)
        entry1.set_placeholder("Category name")

        hbox1 = gtk.HBox()
        hbox1.pack_start(entry1, True, True, 0)
        hbox1.pack_start(button1, False, False, 0)

        button1.connect("clicked", self.new_cat_to_server, dialog, win, entry1)

        dialog.vbox.pack_start(hbox1, False, False, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def new_cat_to_server(self, widget, dialog, win, entry):
        newcat = entry.get_text()
        dialog.destroy()
        winprogind(win, 1)
        thread.start_new(self._do_add_cat_to_server, (win, newcat))

    def _do_add_cat_to_server(self, win, newcat):
        from wordpy import wordpress
        try:
            cat = wordpress.WordPressNewCategory()
            cat.name = newcat
            wpclient = wordpress.create_wordpress_client(self.url, self.user, \
                                                        self.password)
            if wpclient is not None:
                catid = wpclient.newCategory(cat)
                winprogind(win, 0)
                newcat = [catid, cat.name]
                newiter = self.cats_model.append()
                self.cats_model.set(newiter, 0, newcat[0], 1, newcat[1])
                self.show_banner_thread(win, "Category created")
            else:
                winprogind(win, 0)
                self.show_banner_thread(win, "Error creating new category")
                logger.error("Creating new category: wpclient not created")
        except:
            logger.exception("Creating new category")
            winprogind(win, 0)
            self.show_banner_thread(win, "Error creating new category")

    def _cats_tv_columns(self, treeview):
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('cats', gtk.CellRendererText(), text=1)
        treeview.append_column(column)

    def __create_cats_model(self, cats):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        #Added the category list to lstore
        for item in cats:
            iter = lstore.append()
            logger.debug("cat_id-cat_name: %s" % item)
            lstore.set(iter, 0, item[0], 1, item[1])
        return lstore

    def on_get_cats(self, widget, win, treeview):
        if self.blogsystem == "":
            utils.show_info_banner(widget, "No account defined")
            return

        winprogind(win, 1)
        thread.start_new(self._do_on_get_cats, (win, treeview))

    def _do_on_get_cats(self, win, treeview):
        self.cats_model.clear()
        cats = self.return_category_list(win)
        self.cats_model = self.__create_cats_model(cats)
        treeview.set_model(self.cats_model)
        self.cats.append(['0', 'a'])

    def return_category_list(self, win):
        from wordpy import wordpress
        cats = []
        try:
            wpclient = wordpress.create_wordpress_client(self.url, self.user, \
                                                            self.password)
            if wpclient is None:
                logger.error("Getting categories: Wordpress client is None")
                winprogind(win, 0)
                self.show_banner_thread(win, 'Error getting categories')
            else:
                wpclient.selectBlog(0)
                categories = tuple(wpclient.getCategoryList())
                for i in categories:
                    cats.append([i.id, i.name])
                ##Sort categories alphabetically
                ##(apparently it's sorted automatically)
                #cats.sort(lambda x, y: cmp(x[2],y[2]))
                winprogind(win, 0)
            return cats
        except:
            logger.exception('Getting categories')
            winprogind(win, 0)
            self.show_banner_thread(win, 'Error getting categories')
            return cats

    def tags_screen(self, widget, dialog):
        if self.entags:
            self.tags = self.entags.get_text()
        if self.rtags != '':
            oldrtags = self.rtags
        else:
            oldrtags = False

        if dialog:
            dialog.destroy()
        win = hildon.StackableWindow()
        win.set_title("Add Tags")

        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()
        self.tags_tv = hildon.GtkTreeView(ui_edit)

        selection = self.tags_tv.get_selection()
        selection.connect("changed", self.set_recenttags)
        selection.set_mode(gtk.SELECTION_MULTIPLE)
        self.recenttags_model = self.__create_recenttags_model('')

        self.tags_tv.set_model(self.recenttags_model)
        self._recenttags_tv_columns(self.tags_tv)
        parea.add(self.tags_tv)

        self.on_get_recenttags(self.tags_tv)

        if oldrtags:
            self.set_oldrtags(selection, oldrtags)

        label1 = gtk.Label("Recent Tags")

        self.entags = hildon.Entry(fhsize)
        self.entags.set_text(self.tags)
        self.entags.set_placeholder("tag1, tag with spaces, tag2")

        vbox1.pack_start(self.entags, False, False, 0)
        vbox1.pack_start(label1, False, False, 0)
        vbox1.pack_start(parea, True, True, 0)

        win.add(vbox1)
        win.show_all()

    def set_oldrtags(self, selection, oldrtags):
        for i in range(len(self.recenttags_model)):
            if self.recenttags_model[i][0] in oldrtags:
                seliter = self.recenttags_model.get_iter(i)
                selection.select_iter(seliter)

    def return_recenttags_list(self):
        taglist = []
        try:
            rt = RecentTags()
            recenttags = rt.get()
            for i in recenttags:
                taglist.append(i)
            return taglist
        except:
            logger.exception('Getting the recent tags list')
            return taglist

    def on_get_recenttags(self, treeview):
        self.recenttags_model.clear()
        recenttags = self.return_recenttags_list()
        self.recenttags_model = self.__create_recenttags_model(recenttags)
        treeview.set_model(self.recenttags_model)

    def _recenttags_tv_columns(self, treeview):
        column = gtk.TreeViewColumn('', gtk.CellRendererText(), text=0)
        treeview.append_column(column)

    def __create_recenttags_model(self, recenttags):
        lstore = gtk.ListStore(gobject.TYPE_STRING)
        for item in recenttags:
            iter = lstore.append()
            lstore.set(iter, 0, item)
        return lstore

    def set_recenttags(self, selection):
        self.rtags = ''
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        for i in iters:
            self.rtags = self.rtags + selmodel.get_value(i, 0) + ', '

        if self.rtags != '':
            self.rtags = self.rtags[:-2]

    def images_screen(self, widget, screen):
        win = hildon.StackableWindow()
        win.set_title("Add Image to post")

        vbox1 = gtk.VBox()

        hbox = gtk.HBox()

        self.local_img_label = gtk.Label()
        label1 = gtk.Label("Image:")

        hbox.pack_start(label1, True, True, 0)
        hbox.pack_start(self.local_img_label, True, True, 0)

        vbox1.pack_start(hbox, False, False, 0)

        self.local_img = gtk.Image()
        self.local_img.set_from_file(imgdir + 'img-missing.png')

        vbox2 = gtk.VBox()
        vbox2.set_homogeneous(True)

        self.edit_img_btn = hildon.Button(fhsize, horbtn)
        self.edit_img_btn.set_title("Edit image")
        self.edit_img_btn.set_sensitive(False)
        self.edit_img_btn.connect("clicked", self.edit_img_action_dlg, win)
        vbox2.pack_start(self.edit_img_btn, False, False, 0)

        self.initialize_image(None)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.initialize_image)
        button.set_title("Clear image")
        vbox2.pack_start(button, False, False, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("HTML Tags")
        button.connect("clicked", self.html_img_screen)
        vbox2.pack_start(button, False, False, 0)

        hbox = gtk.HBox()

        hbox.pack_start(self.local_img, True, True, 0)
        hbox.pack_start(vbox2, False, False, 0)

        vbox1.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        if self.blogsystem == 'Livejournal' or self.blogsystem == "Drupal":
            button.set_sensitive(False)
        button.connect("clicked", self.select_local_image, win)
        button.set_title("Local")
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Internet")
        button.connect("clicked", self.inet_imgs_screen, win)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Flickr")
        button.connect("clicked", self.add_flickr_img_screen, win)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Picasa")
        button.connect("clicked", self.add_picasa_img_screen, win)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Cached images")
        button.connect("clicked", self.cache_img_screen)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Insert image")
        button.connect("clicked", self.on_insert_img_to_post, screen)
        hbox.pack_start(button, True, True, 0)

        vbox1.pack_start(hbox, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def initialize_image(self, widget):
        self.imgpath = ''
        self.imgalign = 'none'
        self.alttext = ''
        self.aligntext = False
        self.origimg = True
        self.imgwidth = False
        self.imgheight = False
        self.local_img_label.set_text(self.imgpath)
        del self.edit_pixbuf
        self.edit_pixbuf = None
        self.local_img.set_from_file(imgdir + 'img-missing.png')
        self.set_imgname_to_label()
        self.edit_img_btn.set_sensitive(False)

    def on_insert_img_to_post(self, widget, screen):
        if self.imgpath == '':
            #If url is '' not pixbuf, not temp images should exist.
            self.initialize_image(None)
            self.delete_temp_images()
            stack = self.window.get_stack()
            stack.pop_1()
            return

        if screen == "main":
            textview = self.txtPost
            add_img_buffer = self.txtPost.get_buffer()
        elif screen == "advanced":
            textview = self.txtPostExt
            add_img_buffer = self.txtPostExt.get_buffer()


        start, end = utils.get_selection_iters(textview)
        seltext = textview.get_buffer().get_text(start, end)
        if seltext:
            textview.get_buffer().delete(start, end)

        if self.imgpath.find('/var/tmp/') >= 0:
        ## If there is temporal edited images, copy it to maemowordpy config dir
        ## and get it url, and delete the temporal image
        ## When it is uploaded with an article, it will be deleted
        ## it needs a the cached images function for deleting copied images that
        ## haven't been upload with an article. For example, user edit an image,
        ## and insert it in the article but she doesn't upload the article never,
        ## the image will be in mastory config dir forever ;)
            import shutil
            try:
                temp_image_dir = HOME + '/.maemowordpy/images/'

                shutil.copy(self.imgpath.replace('file://', ''),
                            temp_image_dir)
                filename = self.imgpath.replace('file://', '').split('/')

                self.imgpath = \
                        'file://' + temp_image_dir + filename[len(filename)-1]

                self.delete_temp_images()
                del self.edit_pixbuf
                self.edit_pixbuf = None
            except:
                logger.exception("Moving temporal image")
                utils.show_info_banner(widget, "Error moving temporal image")
                return

        img_src = '<img src="%s"' % self.imgpath

        ## If resize html tags is active, add it to <img> tag
        if not self.origimg:
            img_src += ' width="%s" height="%s"' % (self.imgwidth, self.imgheight)
        ## If there is alt text, add it to <img> tag
        if self.alttext:
            img_src += ' alt="%s"' % self.alttext

        if self.aligntext and self.imgalign != 'none':
            img_src += ' align="%s"' % self.imgalign

        #If aligntext it's explicitly defined,
        #but it isn't chosen an alignment, defaulting to left
        if self.aligntext and self.imgalign == 'none':
            img_src += ' align="left"'

        #final_img_src is the final <img src...> text
        final_img_src = img_src + ' />'

        if (self.aligntext and
                self.imgalign != 'none') or (self.aligntext and
                self.imgalign == 'none'):

            text1 = "<p>%s%s</p>" % (final_img_src, seltext)
            add_img_buffer.insert_at_cursor(text1, -1)

        if not self.aligntext and self.imgalign == 'none':
            text1 = final_img_src + seltext
            add_img_buffer.insert_at_cursor(text1, -1)

        if not self.aligntext and self.imgalign != 'none':
            text1 = \
                    '<div style="text-align:%s">%s%s</div>' % (self.imgalign,
                    final_img_src, seltext)
            add_img_buffer.insert_at_cursor(text1, -1)


        stack = self.window.get_stack()
        stack.pop_1()

    def set_pixbuf_to_local_image(self, filename):
        import gc
        self.imgpath = "file://" + filename
        self.edit_pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        self.imgwidth = False
        self.imgheight = False
        self.imgalign = 'none'
        self.alttext = ''
        self.aligntext = False
        self.origimg = True
        thumbnail_pixbuf = utils.file_to_pixbuf(filename, 'edit')
        self.local_img.set_from_pixbuf(thumbnail_pixbuf)
        self.edit_img_btn.set_sensitive(True)
        del thumbnail_pixbuf
        gc.collect()
        logger.debug("Image selected: %s" % self.imgpath)

    def select_local_image(self, widget, win):
        filename = utils.file_browser(win, gtk.FILE_CHOOSER_ACTION_OPEN, \
                    "Browse for Images", self.path_post_img, '', '', \
                    False, False)

        if not filename:
            return

        winprogind(win, 1)
        thread.start_new_thread(self._do_select_local_image, (filename, win))

    def _do_select_local_image(self, filename, win):
        try:
            self.set_pixbuf_to_local_image(filename)
            self.path_post_img = os.path.dirname(filename)
            self.local_img_label.set_text(os.path.basename(filename))
            winprogind(win, 0)
        except:
            logger.exception('Selecting a local image')
            winprogind(win, 0)

    def inet_imgs_screen(self, widget, win):
        dialog = gtk.Dialog(title='Insert image from URL', parent=None)
        dialog.set_has_separator(False)

        cbtn = hildon.CheckButton(fhsize)
        cbtn.set_label("Download image to edit")
        if self.blogsystem == "Drupal":
            cbtn.set_sensitive(False)

        entry1 = hildon.Entry(fhsize)
        entry1.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        entry1.set_text("http://")

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Set image')
        button1.connect("clicked", self.on_set_inet_img, entry1,
                        dialog, cbtn, win)

        cbtn.connect("toggled", self.toggled_download_img, button1)

        hbox1 = gtk.HBox()

        hbox1.pack_start(entry1, True, True, 0)
        hbox1.pack_start(button1, False, False, 0)

        dialog.vbox.pack_start(cbtn, False, False, 0)
        dialog.vbox.pack_start(hbox1, False, False, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def toggled_download_img(self, cbutton, button):
        if cbutton.get_active():
            button.set_title("Download image")
        else:
            button.set_title("Set image")

    def on_set_inet_img(self, widget, entry, dlg, cbutton, win):
        #Assuming the user doesn't change the html tags for the image
        #before of defining the image, else this will be a bug:
        self.initialize_image(None)

        active = cbutton.get_active()
        url = entry.get_text()
        dlg.destroy()

        self.imgpath = entry.get_text()
        self.set_imgname_to_label()

        if active:
            winprogind(win, 1)
            thread.start_new_thread(self.on_download_image, (win,))

    def set_imgname_to_label(self):
        if len(self.imgpath) > 50:
            name = self.imgpath[:47] + '...'
        else:
            name = self.imgpath

        if '/var/tmp' in self.imgpath:
            name = "Temporal image"

        self.local_img_label.set_text(name)

    def on_download_image(self, win):
        import urllib2, random, tempfile, string
        try:
            # Save as /tmp/maemowordpy-<random>/random1.jpg
            random_name = ''.join([random.choice(string.letters)
                                   for x in xrange(8)])

            tmpdir = tempfile.mkdtemp(prefix='mastory') + "/"
            tmpfile = tmpdir + random_name

            myimg = urllib2.urlopen(self.imgpath)
            imgdata = myimg.read()

            tempfile = open(tmpfile, "w")
            tempfile.write(imgdata)
            tempfile.close()

            self.set_pixbuf_to_local_image(tmpfile)
            self.imgpath = tmpfile
            self.set_imgname_to_label()
            winprogind(win, 0)
        except:
            self.initialize_image(None)
            self.delete_temp_images()
            winprogind(win, 0)
            logger.exception("Downloading images")
            self.show_banner_thread(win, "Error downloading image")

    def delete_temp_images(self):
        from wordpy import imaged
        try:
            imaged.delete_temp_images()
        except:
            logger.exception("Deleting temp images")
            utils.show_info_banner(self.window, 'Error deleting temp images')

    def add_flickr_img_screen(self, widget, window):
        win = hildon.StackableWindow()
        win.set_title("Insert image from Flickr")
        vbox1 = gtk.VBox()

        hbox1 = gtk.HBox()

        button1 = hildon.PickerButton(fhsize, horbtn)
        button1.set_title("Choose Image")

        getbutton = hildon.Button(thsize, horbtn)
        getbutton.set_title("Get image list")

        vbox = gtk.VBox()
        label= gtk.Label()
        vbox.pack_start(label, False, False, 0)
        vbox.pack_start(getbutton, False, False, 0)

        vbox2 = gtk.VBox()

        label1 = gtk.Label("Page")

        self.flickrpageNE = utils.FingerNE('horizontal')
        self.flickrpageNE.set_minimum(1)
        self.flickrpageNE.set_value(1)
        self.flickrpageNE.set_size([80, 80, 80, 80])
        self.flickrpageNE.set_image_buttons(imgdir + 'add.png', \
                                            imgdir + 'remove.png')

        vbox2.pack_start(label1, False, False, 0)
        vbox2.pack_start(self.flickrpageNE, True, True, 0)

        hbox1.pack_start(vbox, True, True, 0)
        hbox1.pack_start(vbox2, False, False, 0)

        hbox2 = gtk.HBox()

        button2 = hildon.PickerButton(fhsize, horbtn)
        button2.set_title("Choose Size")

        if self.flickr_photolist:
            self.set_flickr_selectors(button1, button2)

        button1.connect("value-changed", self.change_flickr_photosize, \
                            button1, button2)
        button2.connect("value-changed", self.change_flickr_photosize, \
                            button1, button2)
        getbutton.connect("clicked", self.get_flickr_photolist, win, \
                            button1, button2)

        vbox4 = gtk.VBox()
        label = gtk.Label()
        vbox4.pack_start(label, True, True, 0)
        label = gtk.Label()
        vbox4.pack_start(button2, False, False, 0)
        vbox4.pack_start(label, True, True, 0)

        vbox3 = gtk.VBox()
        vbox3.set_homogeneous(True)

        hbox3 = gtk.HBox()
        label2 = gtk.Label("Width:   ")
        self.labelWidth = gtk.Label("")

        hbox3.pack_start(label2, False, False, 55)
        hbox3.pack_start(self.labelWidth, False, False, 25)

        hbox4 = gtk.HBox()
        label4 = gtk.Label("Height:  ")
        self.labelHeight = gtk.Label("")

        hbox4.pack_start(label4, False, False, 55)
        hbox4.pack_start(self.labelHeight, False, False, 25)

        vbox3.pack_start(hbox3, False, False, 0)
        vbox3.pack_start(hbox4, False, False, 0)

        hbox2.pack_start(vbox4, True, True, 0)
        hbox2.pack_start(vbox3, True, True, 0)

        hbox3 = gtk.HBox()

        cbutton = hildon.CheckButton(fhsize)
        cbutton.set_label("Download image to edit")
        if self.blogsystem == "Drupal":
            cbutton.set_sensitive(False)

        button3 = hildon.Button(fhsize, horbtn)
        button3.set_title("Set image")
        button3.connect("clicked", self.on_set_flickr_photo, button1, \
                                button2, window, cbutton)

        cbutton.connect("toggled", self.toggled_download_img, button3)

        hbox3.pack_start(cbutton, True, True, 0)
        hbox3.pack_start(button3, True, True, 0)

        vbox1.pack_start(hbox1, False, False, 0)
        vbox1.pack_start(button1, False, False, 0)
        vbox1.pack_start(hbox2, True, False, 0)
        vbox1.pack_start(hbox3, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def on_set_flickr_photo(self, widget, button1, button2, win, cbutton):
        self.initialize_image(None)
        size = button2.get_value()
        photo = button1.get_value()
        if size == '' or photo == '':
            utils.show_info_banner(widget, "Choose an image")
            return

        sizeact = self.flickr_sizelist.index(size)
        photoact = self.flickr_photolist.index(photo)

        self.imgpath = str(self.photolist[4][photoact][sizeact])
        self.set_imgname_to_label()

        active = cbutton.get_active()

        if active:
            winprogind(win, 1)
            thread.start_new_thread(self.on_download_image, (win,))

        stack = self.window.get_stack()
        stack.pop_1()

    def change_flickr_photosize(self, widget, button1, button2):
        logger.debug("Changing size or photo")
        size = button2.get_value()
        photo = button1.get_value()
        if size == '' or photo == '':
            return

        sizeact = self.flickr_sizelist.index(size)
        photoact = self.flickr_photolist.index(photo)

        self.labelWidth.set_text(str(self.photolist[2][photoact][sizeact]))
        self.labelHeight.set_text(str(self.photolist[3][photoact][sizeact]))

    def get_flickr_photolist(self, widget, win, btn1, btn2):
        winprogind(win, 1)
        thread.start_new(self._do_get_flickr_photolist, (win, btn1, btn2))

    def _do_get_flickr_photolist(self, win, btn1, btn2):
        from wordpy import flickr
        self.flickr_photolist = []
        self.flickr_sizelist = []
        myflickr = flickr.Flickr('', False)
        page = int(self.flickrpageNE.get_value())
        try:
            self.photolist = myflickr.get_photolist(per_page=self.perpage, \
                                                    page=page)
            #list=photos, sizes, widths, heights, urls
            if self.photolist is not None:
                for item in self.photolist[0]:
                    self.flickr_photolist.append(item)
                for item in self.photolist[1][0]:
                    self.flickr_sizelist.append(item)

                self.set_flickr_selectors(btn1, btn2)
            else:
                self.show_banner_thread(win, "There isnt so much images")
                logger.info("Getting Flickr images: there isnt so much images")

            winprogind(win, 0)
        except:
            winprogind(win, 0)
            logger.exception("Getting Flickr images")
            error_msg = "Error getting the Flickr images"
            self.show_banner_thread(win, "Error getting the Flickr images")

    def set_flickr_selectors(self, btn1, btn2):
        selector = self.create_selector(self.flickr_photolist)
        btn1.set_selector(selector)
        btn1.set_value(self.flickr_photolist[0])
        self.select_default_value(btn1, self.flickr_photolist, selector)

        selector = self.create_selector(self.flickr_sizelist)
        btn2.set_selector(selector)
        btn2.set_value(self.flickr_sizelist[0])
        self.select_default_value(btn2, self.flickr_sizelist, selector)

        self.labelWidth.set_text(str(self.photolist[2][0][0]))
        self.labelHeight.set_text(str(self.photolist[3][0][0]))

    def add_picasa_img_screen(self, widget, window):
        #TODO: add a size pickerbutton too with thumbnails data
        win = hildon.StackableWindow()
        win.set_title("Insert image from Picasa")
        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        button1 = hildon.PickerButton(fhsize, horbtn)
        selector = self.create_selector(self.picasa_albumlist)
        button1.set_selector(selector)
        button1.set_title("Select Album")
        button1.set_value(self.defalbum)
        self.select_default_value(button1, self.picasa_albumlist, selector)

        button3 = hildon.PickerButton(fhsize, horbtn)
        button3.set_title("Select image")

        button2 = hildon.Button(fhsize, verbtn)
        button2.set_title("Get images")

        hbox4 = gtk.HBox()
        hbox4.pack_start(button3, True, True, 0)
        hbox4.pack_start(button2, False, False, 0)

        hbox1 = gtk.HBox()
        label = gtk.Label("Width: ")
        self.picasa_width = gtk.Label("")

        hbox1.pack_start(label, False, False, 55)
        hbox1.pack_start(self.picasa_width, False, False, 25)

        hbox2 = gtk.HBox()
        label = gtk.Label("Height:")
        self.picasa_height = gtk.Label("")

        hbox2.pack_start(label, False, False, 55)
        hbox2.pack_start(self.picasa_height, False, False, 25)

        button2.connect("clicked", self.get_picasa_photolist, win, \
                        button1, button3)

        button3.connect("value-changed", self.change_picasa_photosize)

        cbutton = hildon.CheckButton(fhsize)
        cbutton.set_label("Download image to edit")
        if self.blogsystem == "Drupal":
            cbutton.set_sensitive(False)

        button4 = hildon.Button(fhsize, horbtn)
        button4.set_title("Set image")
        button4.connect("clicked", self.on_set_picasa_photo, button3, \
                            window, cbutton)

        cbutton.connect("toggled", self.toggled_download_img, button4)

        hbox3 = gtk.HBox()

        button5 = hildon.Button(fhsize, horbtn)
        button5.set_title("Get albums")

        hbox3.pack_start(button1, True, True, 0)
        hbox3.pack_start(button5, False, False, 0)

        vbox1.pack_start(hbox3, False, False, 0)
        vbox1.pack_start(hbox4, False, False, 0)
        vbox1.pack_start(hbox1, True, True, 0)
        vbox1.pack_start(hbox2, True, True, 0)
        vbox1.pack_start(cbutton, False, False, 0)
        vbox1.pack_start(button4, False, False, 0)

        if self.picasa_photolist:
            self.set_picasa_selectors(button3)

        win.add(vbox1)
        win.show_all()

    def on_set_picasa_photo(self, widget, button1, win, cbutton):
        self.initialize_image(None)
        #size = button2.get_value()
        photo = button1.get_value()
        if photo == '':
            utils.show_info_banner(widget, "Choose an image")
            return

        #sizeact = self.flickr_sizelist.index(size)
        photoact = self.picasa_photolist.index(photo)

        self.imgpath = str(self.picasa_photos[photoact][1])
        self.set_imgname_to_label()

        active = cbutton.get_active()

        if active:
            winprogind(win, 1)
            thread.start_new_thread(self.on_download_image, (win,))

        stack = self.window.get_stack()
        stack.pop_1()

    def change_picasa_photosize(self, button):
        logger.debug("Changing size or photo")
        #size = button2.get_value()
        photo = button.get_value()
        if photo == '':
            return

        #sizeact = self.flickr_sizelist.index(size)
        photoact = self.picasa_photolist.index(photo)

        self.picasa_width.set_text(str(self.picasa_photos[photoact][2]))
        self.picasa_height.set_text(str(self.picasa_photos[photoact][3]))

    def set_picasa_selectors(self, button1):
        selector = self.create_selector(self.picasa_photolist)
        button1.set_selector(selector)
        button1.set_value(self.picasa_photolist[0])
        self.select_default_value(button1, self.picasa_photolist, selector)

        self.picasa_width.set_text(str(self.picasa_photos[0][2]))
        self.picasa_height.set_text(str(self.picasa_photos[0][3]))

    def get_picasa_photolist(self, widget, win, btn1, btn2):
        winprogind(win, 1)
        thread.start_new(self._do_get_picasa_photolist, (win, btn1, btn2))

    def _do_get_picasa_photolist(self, win, btn1, btn2):
        from wordpy import picasa
        self.picasa_photolist = []
        album_title = btn1.get_value()
        try:
            mypicasa = picasa.Picasa(self.picasa_login, self.picasa_pass)
            self.picasa_photos = mypicasa.getPhotosInAlbum(album_title)

            if self.picasa_photos is not None:
                for item in self.picasa_photos:
                    self.picasa_photolist.append(item[0])

                if self.picasa_photos != []:
                    self.set_picasa_selectors(btn2)
                else:
                    btn2.set_value("")
                    self.picasa_width.set_text('')
                    self.picasa_height.set_text('')
                    logger.error("Getting Picasa photolist: no images")
                    self.show_banner_thread(win, "No images in this album")

                winprogind(win, 0)

            else:
                winprogind(win, 0)
                logger.error("Getting Picasa photolist: album not found")
                self.show_banner_thread(win, "Album not found")
        except:
            winprogind(win, 0)
            logger.error("Getting Picasa photolist: album not found")
            self.show_banner_thread(win, "Error getting Picasa photo list")


    def html_img_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("Set HTML tags to the image")
        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        hbox = gtk.HBox()
        self.imgalign_btn = hildon.PickerButton(fhsize, horbtn)
        data = ["left", "center", "right", "none"]
        selector = self.create_selector(data)
        self.imgalign_btn.set_selector(selector)
        self.imgalign_btn.set_value(self.imgalign)
        self.imgalign_btn.set_title("Alignment")
        self.imgalign_btn.connect("value-changed", self.change_imgalign)
        self.select_default_value(self.imgalign_btn, data, selector)

        self.enalttext = hildon.Entry(fhsize)
        self.enalttext.set_placeholder("Alternative text")
        self.enalttext.set_text(self.alttext)
        self.enalttext.connect("changed", self.change_alttext)

        hbox.pack_start(self.imgalign_btn, False, False, 0)
        hbox.pack_start(self.enalttext, True, True, 0)

        cbutton2 = hildon.CheckButton(fhsize)
        cbutton2.set_label("Align with selected text")
        cbutton2.set_active(self.aligntext)
        cbutton2.connect('toggled', self.change_aligntext)

        hbox1 = gtk.HBox()

        self.orig_btn = hildon.GtkRadioButton(fhsize)
        self.orig_btn.set_mode(False)
        self.orig_btn.set_label("Original")
        self.orig_btn.connect('toggled', self.on_original_active)
        self.resize_btn = hildon.GtkRadioButton(fhsize)
        self.resize_btn.set_mode(False)
        self.resize_btn.set_label("HTML Resize")
        self.resize_btn.set_group(self.orig_btn)

        self.orig_btn.set_active(self.origimg)
        self.resize_btn.set_active(not self.origimg)

        hbox1.pack_start(self.orig_btn, True, True, 0)
        hbox1.pack_start(self.resize_btn, True, True, 0)

        hbox2 = gtk.HBox()

        self.labelwidth_html = gtk.Label("Width:")

        self.WidthNE = utils.FingerNE('horizontal')
        self.WidthNE.set_maximum(20000)
        self.WidthNE.set_minimum(1)
        self.WidthNE.set_size([85, 80, 80, 80])
        self.WidthNE.set_image_buttons(imgdir + 'add.png', \
                                        imgdir + 'remove.png')

        self.labelheight_html = gtk.Label("Height:")

        self.HeightNE = utils.FingerNE('horizontal')
        self.HeightNE.set_maximum(20000)
        self.HeightNE.set_minimum(1)
        self.HeightNE.set_size([85, 80, 80, 80])
        self.HeightNE.set_image_buttons(imgdir + 'add.png', \
                                        imgdir + 'remove.png')

        self.WidthNE.entry.connect('changed', self.preserve_image_aspect, \
                                "width", self.HeightNE.entry, 'html')
        self.HeightNE.entry.connect('changed', self.preserve_image_aspect, \
                                "height", self.WidthNE.entry, 'html')

        hbox2.pack_start(self.labelwidth_html, True, True, 0)
        hbox2.pack_start(self.WidthNE, False, False, 5)
        hbox2.pack_start(self.labelheight_html, True, True, 10)
        hbox2.pack_start(self.HeightNE, False, False, 10)

        self.ratio_btn = hildon.CheckButton(fhsize)
        self.ratio_btn.set_label("Preserve aspect ratio")
        self.ratio_btn.set_active(self.preserve_aspect)
        self.ratio_btn.connect('toggled', self.aspect_ratio_toggled, \
                            self.WidthNE.entry, self.HeightNE.entry, 'html')

        vbox1.pack_start(hbox, False, False, 6)
        vbox1.pack_start(cbutton2, False, False, 6)
        vbox1.pack_start(hbox1, False, False, 6)
        vbox1.pack_start(hbox2, False, False, 6)
        vbox1.pack_start(self.ratio_btn, False, False, 6)

        if self.imgpath.count("file://") > 0 or self.imgpath.count("/var/tmp") > 0:
            self.set_html_tags_image_size()

        self.do_resize_widgets_insensitive()

        win.add(vbox1)
        win.show_all()

    def change_aligntext(self, button):
        if button.get_active():
            self.aligntext = True
        else:
            self.aligntext = False

    def change_alttext(self, entry):
        self.alttext = entry.get_text()

    def change_imgalign(self, button):
        self.imgalign = button.get_value()

    def on_original_active(self, widget):
        ## If original in html size is active or not, do sensitive
        ## or insesitive widgets
        if self.orig_btn.get_active():
            self.origimg = True
            self.do_resize_widgets_insensitive()
        else:
            self.origimg = False
            self.WidthNE.set_sensitive(True)
            self.labelwidth_html.set_sensitive(True)
            self.labelheight_html.set_sensitive(True)
            self.HeightNE.set_sensitive(True)
            self.ratio_btn.set_sensitive(True)

    def do_resize_widgets_insensitive(self):
        ## Do insensitive the html size widgets
        if self.origimg:
            self.WidthNE.set_sensitive(False)
            self.labelwidth_html.set_sensitive(False)
            self.labelheight_html.set_sensitive(False)
            self.HeightNE.set_sensitive(False)
            self.ratio_btn.set_sensitive(False)

    def aspect_ratio_toggled(self, togglebutton, width, height, function):
        ## If there is local image selected, keep aspect ratio or not
        ## this is in html size widgets
        if function == 'resize':
            self.resize_preserve_aspect = togglebutton.get_active()
            preserve_aspect = self.resize_preserve_aspect
        else:
            self.preserve_aspect  = togglebutton.get_active()
            preserve_aspect = self.preserve_aspect
        try:
            if preserve_aspect:
                # Set height based on width and aspect ratio
                target_value = \
                float(width.get_text())/self.local_img.get_pixbuf().get_width()
                target_value = \
                int(target_value * self.local_img.get_pixbuf().get_height())

                self.ignore_preserve_aspect_callback = True
                height.set_text(str(target_value))
                self.ignore_preserve_aspect_callback = False
        except:
            pass

    def preserve_image_aspect(self, entry, option, entry2, function):
        ## If there is local image selected, and keep aspect ratio active
        ## in html size widgets, preserve image aspect
        try:
            if function == 'resize':
                if not self.resize_preserve_aspect:
                    return
            else:
                if not self.preserve_aspect:
                    return
            if self.ignore_preserve_aspect_callback:
                return
            if option == "width":
                target_value = \
                float(entry.get_text())/self.local_img.get_pixbuf().get_width()
                target_value = \
                int(target_value * self.local_img.get_pixbuf().get_height())
                if function != 'resize':
                    self.imgwidth = entry.get_text()
                    self.imgheight = str(target_value)
            else:
                target_value = \
                float(entry.get_text())/self.local_img.get_pixbuf().get_height()
                target_value = \
                int(target_value * self.local_img.get_pixbuf().get_width())
                if function != 'resize':
                    self.imgwidth = str(target_value)
                    self.imgheight = entry.get_text()

            self.ignore_preserve_aspect_callback = True
            entry2.set_text(str(target_value))
            self.ignore_preserve_aspect_callback = False
        except:
            pass

    def set_html_tags_image_size(self):
        if self.imgpath != '':
            if not self.imgwidth:
                import gc
                pixbuf = \
                gtk.gdk.pixbuf_new_from_file(self.imgpath.replace('file://', ''))
                self.WidthNE.entry.set_text(str(pixbuf.get_width()))
                self.ignore_preserve_aspect_callback = True
                self.HeightNE.entry.set_text(str(pixbuf.get_height()))
                self.ignore_preserve_aspect_callback = False
                del pixbuf
                gc.collect()
            else:
                self.WidthNE.entry.set_text(str(self.imgwidth))
                self.ignore_preserve_aspect_callback = True
                self.HeightNE.entry.set_text(str(self.imgheight))
                self.ignore_preserve_aspect_callback = False

    def cache_img_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("Delete cached images")
        vbox = gtk.VBox()

        parea = hildon.PannableArea()

        cached_images = self.GetCacheImages()
        self.cache_model = self.cache_images_model(cached_images)
        self.cache_tv = hildon.GtkTreeView(ui_edit)
        self.cache_tv.set_model(self.cache_model)
        self.__add_columns_cache_images(self.cache_tv)
        parea.add(self.cache_tv)

        hbox = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Delete image")
        button.connect("clicked", self.delete_cache_img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("View image")
        button.connect("clicked", self.view_cache_img)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Info")
        button.connect("clicked", self.show_info_cache_img, win)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        win.add(vbox)
        win.show_all()

    def show_info_cache_img(self, widget, win):
        msg = """These images are cached when inserting edited
local images and the post is not published"""
        utils.show_info_dialog(win, msg)

    def GetCacheImages(self):
        cached_images = []
        try:
            cachedir = os.listdir(HOME + "/.maemowordpy/images/")
            for image in cachedir:
                cached_images.append(image)
            return cached_images
        except:
            logger.exception("Getting cached images")
            return None

    def cache_images_model(self, cached_images):
        lstore = gtk.ListStore(gobject.TYPE_STRING)
        for item in cached_images:
            iter = lstore.append()
            lstore.set(iter, 0, item)
        return lstore

    def __add_columns_cache_images(self, treeview):
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn('images', renderer, text=0)
        treeview.append_column(column)

    def view_cache_img(self, widget):
        if not utils.is_treeview_selected(self.cache_tv):
            utils.show_info_banner(widget, "Must select an image")
            return
        try:
            selname, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.cache_tv, \
                    self.cache_model, 0)
            utils.preview_img(HOME + "/.maemowordpy/images/" + selname)

        except:
            logger.exception("Viewing cached images")
            utils.show_info_banner(widget, "Error viewing cached image")

    def delete_cache_img(self, widget):
        if not utils.is_treeview_selected(self.cache_tv):
            utils.show_info_banner(widget, "Must select an image")
            return
        try:
            selname, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.cache_tv, \
                    self.cache_model, 0)
            os.remove(HOME + '/.maemowordpy/images/' + selname)
            self.cache_model.remove(seliter)
        except:
            utils.show_info_banner(widget, 'Error deleting cached images')
            logger.exception("Deleting cached images")

    def edit_img_action_dlg(self, widget, win):
        data = ["Resize", "Crop", "Rotate", "Flip", "Brightness", "Colorize"]

        dlg = hildon.PickerDialog(self.window)
        dlg.set_title("Choose Action")
        selector = self.create_selector(data)
        selector.connect("changed", self.select_edit_img_action, dlg, win)
        dlg.set_selector(selector)

        dlg.show_all()

    def select_edit_img_action(self, selector, column, dlg, win):
        value = selector.get_current_text()
        dlg.destroy()

        if value == "Resize":
            self.show_resize_dlg(win)
        elif value == "Crop":
            self.show_crop_dlg(win)
        elif value == "Rotate":
            self.show_rotate_dlg(win)
        elif value == "Flip":
            self.show_flip_dlg(win)
        elif value == "Brightness":
            self.show_bright_color_dlg("brightness", win)
        elif value == "Colorize":
            self.show_bright_color_dlg("colorize", win)

    def show_resize_dlg(self, win):
        dialog = gtk.Dialog(title='Resize image', parent=None, flags=0)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()
        label1 = gtk.Label("Width:")

        self.ResizeWidthNE = utils.FingerNE('horizontal')
        self.ResizeWidthNE.set_maximum(10000)
        self.ResizeWidthNE.set_minimum(1)
        self.ResizeWidthNE.set_size([85, 80, 80, 80])
        self.ResizeWidthNE.set_image_buttons(imgdir + 'add.png', \
                                                imgdir + 'remove.png')

        self.ResizeHeightNE = utils.FingerNE('horizontal')
        self.ResizeHeightNE.set_maximum(10000)
        self.ResizeHeightNE.set_minimum(1)
        self.ResizeHeightNE.set_size([85, 80, 80, 80])
        self.ResizeHeightNE.set_image_buttons(imgdir + 'add.png', \
                                                imgdir + 'remove.png')

        self.ResizeWidthNE.entry.connect('changed', \
                                    self.preserve_image_aspect, "width", \
                                    self.ResizeHeightNE.entry, 'resize')
        self.ResizeHeightNE.entry.connect('changed', \
                                    self.preserve_image_aspect, "height", \
                                    self.ResizeWidthNE.entry, 'resize')

        label2 = gtk.Label("Height:")

        hbox1.pack_start(label1, False, False, 15)
        hbox1.pack_start(self.ResizeWidthNE, False, False, 15)
        hbox1.pack_start(label2, False, False, 15)
        hbox1.pack_start(self.ResizeHeightNE, False, False, 15)


        self.ResizeWidthNE.set_value(str(self.edit_pixbuf.get_width()))
        self.ResizeHeightNE.set_value(str(self.edit_pixbuf.get_height()))

        cbutton1 = hildon.CheckButton(fhsize)
        cbutton1.set_label("Preserve aspect ratio")
        cbutton1.set_active(self.resize_preserve_aspect)
        cbutton1.connect('toggled', self.aspect_ratio_toggled, \
                                    self.ResizeWidthNE.entry, \
                                    self.ResizeHeightNE.entry, 'resize')

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Resize')
        button1.connect("clicked", self.on_resize_img, dialog, win)

        dialog.vbox.pack_start(hbox1, False, False, 0)
        dialog.vbox.pack_start(cbutton1, True, True, 0)
        dialog.vbox.pack_start(button1, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def on_resize_img(self, widget, dialog, win):
        width = int(self.ResizeWidthNE.get_value())
        height = int(self.ResizeHeightNE.get_value())
        dialog.destroy()
        winprogind(win, 1)
        thread.start_new(self._do_resize_img, (win, width, height))

    def _do_resize_img(self, win, width, height):
        from wordpy import imaged
        if self.edit_pixbuf == None:
            winprogind(win, 0)
            self.show_banner_thread(win,"Not image selected" )
            return

        try:
            self.edit_pixbuf = imaged.resize_image(self.edit_pixbuf, width, height)
            self.on_set_edited_img(win)
        except:
            self.show_banner_thread(win, "Error resizing the image")
            logger.exception("Resizing image")

        winprogind(win, 0)

    def show_rotate_dlg(self, win):
        dialog = gtk.Dialog(title='Rotate image', parent=None, flags=0)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Rotate left')
        button.connect("clicked", self.on_rotate_img, win, 'left', '', dialog)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Rotate right')
        button.connect("clicked", self.on_rotate_img, win, 'right', '', dialog)
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Rotate angle')
        button.connect("clicked", self.show_rotate_angle_dlg, dialog, win)
        hbox1.pack_start(button, True, True, 0)

        dialog.vbox.pack_start(hbox1, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def show_rotate_angle_dlg(self, widget, dlg, win):
        dlg.destroy()
        dialog = gtk.Dialog(title='Rotate image with angle', parent=None)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()

        angleNE = utils.FingerNE('horizontal')
        angleNE.set_maximum(360)
        angleNE.set_minimum(0)
        angleNE.set_size([70, 70, 70, 70])
        angleNE.set_image_buttons(imgdir + 'add.png', imgdir + 'remove.png')

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Rotate')
        button1.connect("clicked", self.on_rotate_img, win, 'angle', \
                        angleNE.get_value, dialog)

        hbox1.pack_start(angleNE, False, False, 0)
        hbox1.pack_start(button1, True, True, 0)

        dialog.vbox.pack_start(hbox1, False, False, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def on_rotate_img(self, widget, win, orientation, angle, dlg):
        dlg.destroy()
        winprogind(win, 1)
        thread.start_new(self._do_rotate_img, (win, orientation, angle))

    def _do_rotate_img(self, win, orientation, angle):
        from wordpy import imaged
        if self.edit_pixbuf == None:
            winprogind(win, 0)
            self.show_banner_thread(win, "Not image selected")
            return

        if orientation == 'left':
            angle = 90
        elif orientation == 'right':
            angle = 270
        elif orientation == 'angle':
            angle = angle()

        try:
            self.edit_pixbuf = imaged.rotate_image(self.edit_pixbuf, angle)
            imaged.set_pixbuf_to_gtkimage(self.edit_pixbuf, 'edit', self.local_img)
            self.on_set_edited_img(win)
            winprogind(win, 0)
        except:
            winprogind(win, 0)
            logger.exception("Rotating image")
            self.show_banner_thread(win, 'Error rotating the image')

    def show_flip_dlg(self, win):
        dialog = gtk.Dialog(title='Flip image', parent=None, flags=0)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Flip horizontally')
        button1.connect("clicked", self.on_flip_img, 'horizontal', win, dialog)

        button2 = hildon.Button(fhsize, horbtn)
        button2.set_title('Flip vertically')
        button2.connect("clicked", self.on_flip_img, 'vertical', win, dialog)

        hbox1.pack_start(button1, True, True, 0)
        hbox1.pack_start(button2, True, True, 0)

        dialog.vbox.pack_start(hbox1, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def on_flip_img(self, widget, mode, win, dialog):
        dialog.destroy()
        winprogind(win, 1)
        thread.start_new(self._do_flip_img, (win, mode))

    def _do_flip_img(self, win, mode):
        from wordpy import imaged
        if self.edit_pixbuf == None:
            winprogind(win, 0)
            self.show_banner_thread(win, "Not image selected")
            return

        try:
            self.edit_pixbuf = imaged.flip_image(self.edit_pixbuf, mode)
            imaged.set_pixbuf_to_gtkimage(self.edit_pixbuf, 'edit', \
                                            self.local_img)
            self.on_set_edited_img(win)
            winprogind(win, 0)
        except:
            winprogind(win, 0)
            logger.exception("Flipping image")
            self.show_banner_thread(win, 'Error flipping the image')

    def show_bright_color_dlg(self, option, win):
        if option == "brightness":
            title = "Set brightness to image"
        elif option == "colorize":
            title = "Set color to image"

        dialog = gtk.Dialog(title=title, parent=None, flags=0)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()

        image = gtk.Image()
        width, height = utils.set_thumbnail_size(self.edit_pixbuf, 'edit')
        pixbuf = self.edit_pixbuf.scale_simple(int(width), int(height), \
                                                gtk.gdk.INTERP_BILINEAR)
        image.set_from_pixbuf(pixbuf)
        image.set_size_request(int(width), int(height))

        scale = gtk.HScale()
        scale.set_draw_value(False)
        scale.set_update_policy(gtk.UPDATE_DISCONTINUOUS)
        scale.set_range(0, 2)
        scale.set_increments(0.1, 0.5)
        scale.set_value(1)
        scale.connect('value-changed', self.saturation_preview, pixbuf, \
                        image, option)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Do changes')
        button1.connect("clicked", self.on_color_or_bright, scale, win, \
                        option, dialog)

        hbox1.pack_start(scale, True, True, 0)
        hbox1.pack_start(button1, False, False, 0)

        dialog.vbox.pack_start(image, True, True, 0)
        dialog.vbox.pack_start(hbox1, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def saturation_preview(self, scale, pixbuf, image, option):
        import gc
        from wordpy import imaged
        while gtk.events_pending():
            gtk.main_iteration()
        try:
            bak = imaged.do_colorize_or_brightness(pixbuf, scale.get_value(), option)
            image.set_from_pixbuf(bak)
            del bak
        except:
            logger.exception("Doing %s to the image" % option)

        gc.collect()

    def on_color_or_bright(self, widget, scale, win, option, dialog):
        value = scale.get_value()
        dialog.destroy()
        winprogind(win, 1)
        thread.start_new_thread(self._do_color_or_bright, (value, win, option))

    def _do_color_or_bright(self, value, win, option):
        try:
            from wordpy import imaged

            self.edit_pixbuf = \
                        imaged.do_colorize_or_brightness(self.edit_pixbuf, \
                        value, option)

            imaged.set_pixbuf_to_gtkimage(self.edit_pixbuf, 'edit', \
                                            self.local_img)
            self.on_set_edited_img(win)
            winprogind(win, 0)
        except:
            winprogind(win, 0)
            self.show_banner_thread(win, "Error doing %s to image" % option)
            logger.exception("Doing %s to image" % option)


    def show_crop_dlg(self, win):
        dialog = gtk.Dialog(title="Crop image", parent=None, flags=0)
        dialog.set_has_separator(False)

        hbox1 = gtk.HBox()

        self.cropdraw = gtk.DrawingArea()
        self.cropdraw.set_events(gtk.gdk.POINTER_MOTION_MASK \
                        | gtk.gdk.POINTER_MOTION_HINT_MASK \
                        | gtk.gdk.BUTTON_PRESS_MASK \
                        | gtk.gdk.BUTTON_MOTION_MASK \
                        | gtk.gdk.BUTTON_RELEASE_MASK)

        image_width, image_height = \
                        utils.set_thumbnail_size(self.edit_pixbuf, 'edit')
        crop_pixbuf = self.edit_pixbuf.scale_simple(int(image_width), \
                                int(image_height), gtk.gdk.INTERP_BILINEAR)
        self.cropdraw.set_size_request(int(image_width), int(image_height))

        width = self.edit_pixbuf.get_width()
        height = self.edit_pixbuf.get_height()

        hbox2 = gtk.HBox()

        hbox3 = gtk.HBox()
        hbox4 = gtk.HBox()
        hbox5 = gtk.HBox()

        label1 = gtk.Label("X: ")
        label2 = gtk.Label("Width: ")

        xspin = utils.FingerNE('horizontal')
        xspin.set_maximum(width)
        xspin.set_minimum(0)
        xspin.set_value(0)
        xspin.set_size([85, 70, 70, 70])
        xspin.set_image_buttons(imgdir + 'add.png', imgdir + 'remove-s.png')

        wspin = utils.FingerNE('horizontal')
        wspin.set_maximum(width)
        wspin.set_minimum(0)
        wspin.set_value(width)
        wspin.set_size([85, 70, 70, 70])
        wspin.set_image_buttons(imgdir + 'add.png', imgdir + 'remove-s.png')

        label3 = gtk.Label("Y: ")
        label4 = gtk.Label("Height:")

        yspin = utils.FingerNE('horizontal')
        yspin.set_maximum(height)
        yspin.set_minimum(0)
        yspin.set_size([85, 70, 70, 70])
        yspin.set_image_buttons(imgdir + 'add.png', imgdir + 'remove-s.png')

        hspin = utils.FingerNE('horizontal')
        hspin.set_maximum(height)
        hspin.set_value(height)
        hspin.set_minimum(0)
        hspin.set_size([85, 70, 70, 70])
        hspin.set_image_buttons(imgdir + 'add.png', imgdir + 'remove-s.png')

        hbox2.pack_start(label1, True, True, 30)
        hbox2.pack_start(xspin, True, True, 0)

        hbox3.pack_start(label3, True, True, 30)
        hbox3.pack_start(yspin, True, True, 0)

        hbox4.pack_start(label2, True, True, 0)
        hbox4.pack_start(wspin, True, True, 0)

        hbox5.pack_start(label4, True, True, 0)
        hbox5.pack_start(hspin, True, True, 0)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Crop')
        button1.connect("clicked", self.on_crop_img, dialog, win)

        vbox1 = gtk.VBox()

        vbox1.pack_start(hbox2, True, True, 2)
        vbox1.pack_start(hbox3, True, True, 2)
        vbox1.pack_start(hbox4, True, True, 2)
        vbox1.pack_start(hbox5, True, True, 2)

        vbox2 = gtk.VBox()
        vbox2.pack_start(self.cropdraw, True, True, 5)
        vbox2.pack_start(button1, False, False, 5)

        hbox1.pack_start(gtk.Label(), True, True, 5)
        hbox1.pack_start(vbox2, False, False, 0)
        hbox1.pack_start(vbox1, True, True, 0)

        dialog.vbox.pack_start(hbox1, True, True, 0)

        self.cropdraw.connect("expose-event", self.cropdraw_expose_cb, \
                                crop_pixbuf, image_width, image_height)

        self.cropdraw.connect("button_press_event", self.cropdraw_button_press)
        self.cropdraw.connect("button_release_event", self.cropdraw_button_release)


        self.cropdraw.connect("motion_notify_event", \
                            self.cropdraw_mouse_moved, 0, 0, xspin, yspin, \
                            wspin, hspin, image_width, image_height)

        self.x_changed = xspin.entry.connect("changed", \
                            self.crop_value_changed, xspin, yspin, wspin, \
                            hspin, image_width, image_height, 0)

        self.y_changed = yspin.entry.connect('changed', \
                            self.crop_value_changed, xspin, yspin, wspin, \
                            hspin, image_width, image_height, 1)
        self.width_changed = wspin.entry.connect('changed', \
                            self.crop_value_changed, xspin, yspin, wspin, \
                            hspin, image_width, image_height, 2)
        self.height_changed = hspin.entry.connect('changed', \
                            self.crop_value_changed, xspin, yspin, wspin, \
                            hspin, image_width, image_height, 3)


        self.cropdraw.realize()
        self.crop_rectangle = [0, 0]
        self.drawing_crop_rectangle = False
        self.update_rectangle = False
        self.rect = None

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def on_crop_img(self, widget, dialog, win):
        dialog.destroy()
        winprogind(win, 1)
        thread.start_new(self._do_crop_img, (win,))

    def _do_crop_img(self, win):
        from wordpy import imaged
        if self.edit_pixbuf == None:
            winprogind(win, 0)
            self.show_banner_thread(win, "Not image selected")
            return

        try:
            if self.rect != None:
                import gc
                temp_pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, \
                                    self.edit_pixbuf.get_has_alpha(), 8, \
                                    self.coords[2], self.coords[3])
                self.edit_pixbuf.copy_area(self.coords[0], self.coords[1], \
                            self.coords[2], self.coords[3], temp_pixbuf, 0, 0)
                self.edit_pixbuf = temp_pixbuf
                del temp_pixbuf
                imaged.set_pixbuf_to_gtkimage(self.edit_pixbuf, 'edit', \
                            self.local_img)

                self.on_set_edited_img(win)
                gc.collect()
                winprogind(win, 0)
        except:
            winprogind(win, 0)
            logger.exception("Cropping the image")
            self.show_banner_thread(win, "Error cropping the image")


    def crop_value_changed(self, currspinbox, x, y, width, height, image_width, image_height, type):
        if type == 0:   # X
            if int(x.get_value()) + \
                    int(width.get_value()) > \
                    self.edit_pixbuf.get_width():

                width.entry.handler_block(self.width_changed)
                width.set_value(self.edit_pixbuf.get_width() - int(x.get_value()))
                width.entry.handler_block(self.width_changed)

        elif type == 1: # Y
            if int(y.get_value()) + \
                    int(height.get_value()) > \
                    self.edit_pixbuf.get_height():

                height.entry.handler_block(self.height_changed)
                height.set_value(self.edit_pixbuf.get_height() - int(y.get_value()))
                height.entry.handler_unblock(self.height_changed)

        self.coords = \
                [int(x.get_value()), int(y.get_value()), \
                int(width.get_value()), int(height.get_value())]

        self.crop_rectangle[0] = \
                int(round(float(self.coords[0])/self.edit_pixbuf.get_width() \
                * image_width, 0))

        self.crop_rectangle[1] = \
                int(round(float(self.coords[1])/self.edit_pixbuf.get_height() \
                * image_height, 0))

        x2 = \
                int(round(float(self.coords[2])/self.edit_pixbuf.get_width() \
                * image_width, 0)) + self.crop_rectangle[0]

        y2 = \
                int(round(float(self.coords[3])/self.edit_pixbuf.get_height() \
                * image_height, 0)) + self.crop_rectangle[1]


        self.drawing_crop_rectangle = True
        self.update_rectangle = True
        self.cropdraw_mouse_moved(None, None, x2, y2, x, y, width, height, \
                                image_width, image_height)
        self.update_rectangle = False
        self.drawing_crop_rectangle = False



    def cropdraw_mouse_moved(self, widget, event, x2, y2, x, y, width, \
                            height, image_width, image_height):

        if event != None:
            x2, y2, state = event.window.get_pointer()

        if self.drawing_crop_rectangle:
            if self.crop_rectangle != None or self.update_rectangle:
                gc1 = self.cropdraw.window.new_gc(function=gtk.gdk.INVERT)
                if self.rect != None:
                    # Get rid of the previous drawn rectangle:
                    self.cropdraw.window.draw_rectangle(gc1, False, \
                                        self.rect[0], self.rect[1], \
                                        self.rect[2], self.rect[3])
                self.rect = [0, 0, 0, 0]
                if self.crop_rectangle[0] > x2:
                    self.rect[0] = x2
                    self.rect[2] = self.crop_rectangle[0]-x2
                else:
                    self.rect[0] = self.crop_rectangle[0]
                    self.rect[2] = x2-self.crop_rectangle[0]
                if self.crop_rectangle[1] > y2:
                    self.rect[1] = y2
                    self.rect[3] = self.crop_rectangle[1]-y2
                else:
                    self.rect[1] = self.crop_rectangle[1]
                    self.rect[3] = y2-self.crop_rectangle[1]
                self.cropdraw.window.draw_rectangle(gc1, False, \
                                self.rect[0], self.rect[1], self.rect[2], \
                                self.rect[3])
                # Convert the rectangle coordinates of the current image
                # to coordinates of pixbuf_original
                if self.rect[0] < 0:
                    self.rect[2] = self.rect[2] + self.rect[0]
                    self.rect[0] = 0
                if self.rect[1] < 0:
                    self.rect[3] = self.rect[3] + self.rect[1]
                    self.rect[1] = 0
                if event != None:
                    self.coords = [0,0,0,0]
                    self.coords[0] = \
                            int(round(float(self.rect[0])/image_width * \
                            self.edit_pixbuf.get_width(), 0))

                    self.coords[1] = \
                            int(round(float(self.rect[1])/image_height * \
                            self.edit_pixbuf.get_height(), 0))
                    self.coords[2] = \
                            int(round(float(self.rect[2])/image_width * \
                            self.edit_pixbuf.get_width(), 0))
                    self.coords[3] = \
                            int(round(float(self.rect[3])/image_height * \
                            self.edit_pixbuf.get_height(), 0))
                    if self.coords[0] + \
                                self.coords[2] > self.edit_pixbuf.get_width():
                        self.coords[2] = \
                                self.edit_pixbuf.get_width() - self.coords[0]
                    if self.coords[1] + \
                                self.coords[3] > self.edit_pixbuf.get_height():
                        self.coords[3] = \
                                self.edit_pixbuf.get_height() - self.coords[1]

                x.entry.handler_block(self.x_changed)
                y.entry.handler_block(self.y_changed)
                width.entry.handler_block(self.width_changed)
                height.entry.handler_block(self.height_changed)
                x.set_value(self.coords[0])
                y.set_value(self.coords[1])
                width.set_value(self.coords[2])
                height.set_value(self.coords[3])
                x.entry.handler_unblock(self.x_changed)
                y.entry.handler_unblock(self.y_changed)
                width.set_maximum(self.edit_pixbuf.get_width() - self.coords[0])
                height.set_maximum(self.edit_pixbuf.get_height() - self.coords[1])
                width.entry.handler_unblock(self.width_changed)
                height.entry.handler_unblock(self.height_changed)


    def cropdraw_button_press(self, widget, event):
        x, y, state = event.window.get_pointer()
        if (state & gtk.gdk.BUTTON1_MASK):
            self.drawing_crop_rectangle = True
            self.crop_rectangle = [x, y]
            gc1 = self.cropdraw.window.new_gc(function=gtk.gdk.INVERT)
            if self.rect != None:
                # Get rid of the previous drawn rectangle:
                self.cropdraw.window.draw_rectangle(gc1, False, self.rect[0], self.rect[1], self.rect[2], self.rect[3])
                self.rect = None

    def cropdraw_button_release(self, widget, event):
        x, y, state = event.window.get_pointer()
        if not (state & gtk.gdk.BUTTON1_MASK):
            self.drawing_crop_rectangle = False

    def cropdraw_expose_cb(self, image, event, pixbuf, width, height):
        image.window.draw_pixbuf(None, pixbuf, 0, 0, 0, 0, int(width), \
                                int(height))

    def on_set_edited_img(self, widget):
        # Save as /tmp/maemowordpy-<random>/filename.png
        try:
            from wordpy import imaged
            tmpfile = imaged.create_temp_image(self.edit_pixbuf)

            if tmpfile is None:
                return

            self.imgpath = "file://" + tmpfile
            self.set_imgname_to_label()

            self.imgwidth = self.edit_pixbuf.get_width()
            self.imgheight = self.edit_pixbuf.get_height()

        except:
            logger.exception("Creating temp image")
            utils.show_info_banner(widget, 'Error creating temp image')

    def manageposts_screen(self, widget):
        self.set_recentposts_to_label()

        win = hildon.StackableWindow()
        win.set_title("Manage Posts")
        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()
        self.manage_posts_tv = gtk.TreeView()
        self._manage_posts_tv_columns(self.manage_posts_tv)
        self.manage_posts_model = self.__create_manage_posts_model('')
        self.manage_posts_tv.set_model(self.manage_posts_model)
        hildon.hildon_gtk_tree_view_set_ui_mode(self.manage_posts_tv, ui_edit)
        parea.add(self.manage_posts_tv)

        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title("Get")
        button1.connect("clicked", self.on_get_posts_to_manage, win)
        button2 = hildon.Button(fhsize, horbtn)
        #button2.set_title("Clear")
        #button2.connect("clicked", self.on_clear_manage_posts)
        button3 = hildon.Button(fhsize, horbtn)
        button3.set_title("Edit")
        button3.connect("clicked", self.on_edit_post, win)
        button4 = hildon.Button(fhsize, horbtn)
        button4.connect("clicked", self.on_delete_post, win)
        button4.set_title("Delete")
        button5 = hildon.Button(fhsize, horbtn)
        button5.set_title("Status")
        button5.connect("clicked", self.show_change_status_ui, win)
        button6 = hildon.Button(fhsize, horbtn)
        button6.set_title("Comments")
        button6.connect("clicked", self.comments_screen)

        hbox1.pack_start(button1, True, True, 0)
        #hbox1.pack_start(button2, True, True, 0)
        hbox1.pack_start(button3, True, True, 0)
        hbox1.pack_start(button4, True, True, 0)
        hbox1.pack_start(button5, True, True, 0)
        hbox1.pack_start(button6, True, True, 0)

        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(hbox1, False, False, 0)

        win.add(vbox1)
        win.show_all()
        if self.blogsystem == "Livejournal" or self.blogsystem == "Drupal":
            button6.hide()

    def on_get_posts_to_manage(self, widget, win):
        if self.blogsystem == "":
            utils.show_info_banner(widget, "No account defined")
            return

        winprogind(win, 1)
        thread.start_new(self._do_get_posts_to_manage, (win, widget))

    def _do_get_posts_to_manage(self, win, widget):
        try:
            self.manage_posts_model.clear()
            if self.blogsystem == 'Wordpress':
                from wordpy import wordpress
                posts = wordpress.get_posts_with_status(self.url, self.user,
                                                self.password, self.numposts)
            elif self.blogsystem == 'Blogger':
                from wordpy import blogger
                posts = blogger.get_posts_with_status(self.user,
                                                    self.password,
                                                    self.blogid,
                                                    self.numposts)
            elif self.blogsystem == 'Livejournal':
                from wordpy import livejournal
                posts = livejournal.post_list_formatted(self.user,
                                                        self.password,
                                                        self.numposts)

            elif self.blogsystem == 'Drupal':
                from wordpy import drupal
                posts = drupal.get_posts_with_status(self.url, self.user,
                                                self.password, self.numposts)

            #posts = [['title', '283732', "publish"]]
            self.manage_posts_model = self.__create_manage_posts_model(posts)
            self.manage_posts_tv.set_model(self.manage_posts_model)
            winprogind(win, 0)
        except:
            logger.exception('Getting the post list')
            winprogind(win, 0)
            self.show_banner_thread(win, 'Error getting the post list')

    def on_delete_post(self, widget, win):
        if not utils.is_treeview_selected(self.manage_posts_tv):
            utils.show_info_banner(widget, "Must select a post")
            return
        confirmation = utils.show_confirmation(win, "Delete post?")
        if confirmation:
            winprogind(win, 1)
            thread.start_new(self._do_delete_post, (win, ))

    def _do_delete_post(self, win):
        try:
            selected = utils.is_treeview_selected(self.manage_posts_tv)
            if not selected:
                winprogind(win, 0)
                return

            postid, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.manage_posts_tv, \
                    self.manage_posts_model, 1)

            if self.blogsystem == 'Wordpress':
                from wordpy import wordpress
                wpclient = wordpress.create_wordpress_client(self.url,
                                                             self.user,
                                                             self.password)
                wpclient.deletePost(postid)
            elif self.blogsystem == 'Blogger':
                from wordpy import blogger
                bgclient = blogger.create_blogger_client(self.user,
                                                        self.password)
                bgclient.Delete(postid)
            elif self.blogsystem == 'Livejournal':
                from wordpy import livejournal
                ljclient = livejournal.create_livejournal_client(self.user,
                                                                self.password)
                ljclient.del_event(postid)
            elif self.blogsystem == 'Drupal':
                from wordpy import drupal
                dclient = drupal.create_drupal_client(self.url, self.user,
                                                        self.password)
                dclient.deletePost(postid)

            self.manage_posts_model.remove(seliter)
            winprogind(win, 0)
        except:
            logger.exception('Deleting post')
            error_msg = 'Error deleting post'
            winprogind(win, 0)
            self.show_banner_thread(win, 'Error deleting post')

    def on_clear_manage_posts(self, clicked):
        self.manage_posts_model.clear()

    def __create_manage_posts_model(self, posts):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, \
                                gobject.TYPE_STRING)
        for item in posts:
            iter = lstore.append()
            lstore.set(iter, 0, item[0], 1, item[1], 2, item[2])

        return lstore

    def _manage_posts_tv_columns(self, treeview):
        renderer = gtk.CellRendererText()
        renderer.set_property('wrap-mode', gtk.WRAP_WORD)
        renderer.set_property('wrap-width', 600)
        column = gtk.TreeViewColumn('Title', renderer, text=0)
        column.set_expand(True)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=1)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Status", gtk.CellRendererText(), text=2)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(150)
        treeview.append_column(column)

    def show_change_status_ui(self, widget, win):
        if not utils.is_treeview_selected(self.manage_posts_tv):
            utils.show_info_banner(widget, "Must select a post")
            return
        if self.blogsystem == "Wordpress":
            data = ["publish", "draft", "pending", "private"]
        elif self.blogsystem == "Blogger" or self.blogsystem == "Drupal":
            data = ["publish", "draft"]
        elif self.blogsystem == "Livejournal":
            data = ["public", "private", "friends"]

        dlg = hildon.PickerDialog(win)
        dlg.set_title("Change status")
        selector = self.create_selector(data)
        dlg.set_selector(selector)
        selector.connect("changed", self.on_change_status_to_post, dlg, win)

        dlg.show_all()
        result = dlg.run()
        if result == gtk.RESPONSE_DELETE_EVENT:
            dlg.destroy()
            return

    def on_change_status_to_post(self, selector, column, dlg, win):
        status = selector.get_current_text()
        dlg.destroy()
        logger.debug("new status: %s" % status)
        if not status:
            return
        winprogind(win, 1)
        thread.start_new(self._do_change_status_to_post, (win, status))

    def _do_change_status_to_post(self, win, status):
        from wordpy import posting
        try:
            postid, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.manage_posts_tv,
                            self.manage_posts_model, 1)

            if self.blogsystem == 'Wordpress':
                posting.edit_post_status_wordpress(self.url, self.user,
                                            self.password, postid, status)
            elif self.blogsystem == 'Blogger':
                posting.edit_post_status_blogger(self.user, self.password,
                                            self.blogid, postid, status)

            elif self.blogsystem == 'Livejournal':
                posting.edit_post_status_lj(self.user, self.password,
                                            postid, status)

            elif self.blogsystem == 'Drupal':
                posting.edit_post_status_drupal(self.url, self.user,
                                            self.password, postid, status)

            title = self.manage_posts_model.get_value(seliter, 0)
            if seliter:
                self.manage_posts_model.set(seliter, 0, title, 1, postid,
                                            2, status)

            winprogind(win, 0)
        except:
            logger.exception('Updating the post status')
            winprogind(win, 0)
            self.show_banner_thread(win,  'Error updating the post status')

    def comments_screen(self, widget):
        if not utils.is_treeview_selected(self.manage_posts_tv):
            utils.show_info_banner(widget, "Must select a post")
            return

        postid, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_posts_tv,
                self.manage_posts_model, 1)

        title, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_posts_tv,
                self.manage_posts_model, 0)

        win = hildon.StackableWindow()
        win.set_title("Manage Comments for %s" % title)
        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()
        self.manage_comm_tv = gtk.TreeView()
        self.manage_comm_tv.set_headers_visible(True)
        self._manage_comm_tv_columns(self.manage_comm_tv)
        self.manage_comm_model = self.__create_manage_comm_model('')
        self.manage_comm_tv.set_model(self.manage_comm_model)
        hildon.hildon_gtk_tree_view_set_ui_mode(self.manage_comm_tv, ui_edit)
        parea.add(self.manage_comm_tv)

        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Get")
        button.connect("clicked", self.get_comments_from_post, win, postid)
        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title("New")
        button1.connect("clicked", self.new_comment, win, postid)
        button2 = hildon.Button(fhsize, horbtn)
        button2.set_title("Edit")
        button2.connect("clicked", self.edit_comment)
        button3 = hildon.Button(fhsize, horbtn)
        button3.set_title("Delete")
        button3.connect("clicked", self.delete_comment, win, postid)
        button4 = hildon.Button(fhsize, horbtn)
        button4.connect("clicked", self.view_comment)
        button4.set_title("View")

        hbox1.pack_start(button, True, True, 0)
        hbox1.pack_start(button1, True, True, 0)
        hbox1.pack_start(button2, True, True, 0)
        hbox1.pack_start(button3, True, True, 0)
        hbox1.pack_start(button4, True, True, 0)

        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(hbox1, False, False, 0)

        win.add(vbox1)
        win.show_all()
        if self.blogsystem == "Blogger":
            button2.hide()


    def edit_comment(self, widget):
        if not utils.is_treeview_selected(self.manage_comm_tv):
            utils.show_info_banner(widget, "Must select a comment")
            return

        content, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 1)

        author, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 2)

        status, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 5)

        commid, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 0)

        email, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 3)

        url, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 4)

        win = hildon.StackableWindow()
        win.set_title("Edit comment")

        vbox = gtk.VBox()
        entry1 = hildon.Entry(fhsize)
        entry1.set_placeholder("Author")
        entry1.set_text(author)

        entry2 = hildon.Entry(fhsize)
        entry2.set_placeholder("Author Email")
        entry2.set_text(email)
        entry3 = hildon.Entry(fhsize)
        entry3.set_placeholder("Author URL")
        entry3.set_text(url)

        button1 = hildon.PickerButton(fhsize, horbtn)
        data = ["approve", "hold", "spam"]
        selector = self.create_selector(data)
        button1.set_selector(selector)
        button1.set_title("Status")
        button1.set_value(status)
        self.select_default_value(button1, data, selector)

        parea = hildon.PannableArea()
        textview = hildon.TextView()
        textview.modify_font(pango.FontDescription("Normal " + self.fontsize))
        textview.set_property("wrap-mode", gtk.WRAP_WORD)
        textview.get_buffer().set_text(content)
        parea.add(textview)

        button2 = hildon.Button(fhsize, horbtn)
        button2.set_title("Update comment")
        button2.connect("clicked", self.update_comment, win, commid,
                        textview, entry1, entry2, entry3, button1, seliter)

        hbox = gtk.HBox()
        hbox.pack_start(entry1, True, True, 0)
        hbox.pack_start(entry2, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        hbox.pack_start(entry3, True, True, 0)
        hbox.pack_start(button1, False, False, 0)
        vbox.pack_start(hbox, False, False, 0)

        vbox.pack_start(parea, True, True, 0)
        vbox.pack_start(button2, False, False, 0)

        win.add(vbox)
        win.show_all()

    def update_comment(self, widget, win, commid, textview, entry1,
                    entry2, entry3, button1, seliter):

        start, end = textview.get_buffer().get_bounds()
        content = textview.get_buffer().get_text(start, end)
        author = entry1.get_text()
        autemail = entry2.get_text()
        auturl = entry3.get_text()
        status = button1.get_value()

        data = [content, author, autemail, auturl, status]

        winprogind(win, 1)
        thread.start_new(self._do_update_comment, (win, data, commid, seliter))

    def _do_update_comment(self, win, data, commid, seliter):
        try:
            if self.blogsystem == "Wordpress":
                from wordpy import wordpress
                comm = wordpress.edit_comment(self.url, self.user, self.password,
                                            commid, data)

            winprogind(win, 0)
            self.manage_comm_model.set(seliter, 0, commid, 1, data[0],
                                        2, data[1], 3, data[2],
                                        4, data[3], 5, data[4])
            stack = self.window.get_stack()
            stack.pop_1()
            self.show_banner_thread(win, "Comment updated")
        except:
            winprogind(win, 0)
            self.show_banner_thread(win, "Error updating comment")
            logger.exception("Updating comment")

    def delete_comment(self, widget, win, postid):
        if not utils.is_treeview_selected(self.manage_comm_tv):
            utils.show_info_banner(widget, "Must select a comment")
            return

        confirmation = utils.show_confirmation(win, "Delete comment?")
        if confirmation:
            winprogind(win, 1)
            thread.start_new(self._do_delete_comment, (win, postid))

    def _do_delete_comment(self, win, postid):
        commid, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 0)

        try:
            if self.blogsystem == "Wordpress":
                from wordpy import wordpress
                wp = wordpress.create_wordpress_client(self.url, self.user,
                                                        self.password)
                wp.deleteComment(commid)
                selmodel.remove(seliter)

            elif self.blogsystem == "Blogger":
                from wordpy import blogger
                blogger.delete_comment(self.user, self.password, self.blogid,
                                        postid, commid)
                selmodel.remove(seliter)

            winprogind(win, 0)
            self.show_banner_thread(win, "Comment deleted")
        except:
            winprogind(win, 0)
            logger.exception("Deleting comment")
            self.show_banner_thread(win, "Error deleting comment")

    def new_comment(self, widget, win, postid):
        dialog = gtk.Dialog(title='Comment', parent=None)
        dialog.set_size_request(600, 350)

        #FIXME: it needs selection mode too
        parea = hildon.PannableArea()
        textview = hildon.TextView()
        textview.modify_font(pango.FontDescription("Normal " + self.fontsize))
        textview.set_property("wrap-mode", gtk.WRAP_WORD)
        parea.add(textview)

        button = hildon.Button(fhsize, horbtn)
        button.set_title("Send")
        button.connect("clicked", self.send_new_comment, dialog,
                        win, postid, textview)

        dialog.vbox.pack_start(parea, True, True, 0)
        dialog.vbox.pack_start(button, False, False, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def send_new_comment(self, widget, dialog, win, postid, textview):
        start, end = textview.get_buffer().get_bounds()
        content = textview.get_buffer().get_text(start, end)
        dialog.destroy()

        winprogind(win, 1)
        thread.start_new(self._do_send_new_comment, (win, content, postid))

    def _do_send_new_comment(self, win, content, postid):
        try:
            if self.blogsystem == "Wordpress":
                from wordpy import wordpress
                comm = wordpress.new_comment(self.url, self.user,
                                            self.password, postid, content)

                newc = [comm['comment_id'], comm['content'], comm['author'],
                            comm['author_email'], comm['author_url'],
                            comm['status']]

            elif self.blogsystem == "Blogger":
                from wordpy import blogger
                comm = blogger.new_comment(self.user, self.password,
                                            self.blogid, postid, content)

                if comm:
                    newc = [comm.GetEditLink().href.split("/")[-1],
                                comm.title.text, comm.author[0].name.text,
                                comm.author[0].email.text,
                                comm.author[0].uri.text, 'published']

                else:
                    winprogind(win, 0)
                    self.show_banner_thread(win,
                                    "New comments not allowed in drafts")
                    return


            newiter = self.manage_comm_model.append()
            self.manage_comm_model.set(newiter, 0, newc[0], 1, newc[1],
                            2, newc[2], 3, newc[3], 4, newc[4], 5, newc[5])

            winprogind(win, 0)
            self.show_banner_thread(win, "Comment sent")
        except:
            winprogind(win, 0)
            self.show_banner_thread(win, "Error sending new comment")
            logger.exception("Sending new comment")

    def view_comment(self, widget):
        if not utils.is_treeview_selected(self.manage_comm_tv):
            utils.show_info_banner(widget, "Must select a comment")
            return

        content, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 1)

        author, seliter, selmodel = \
                utils.get_selected_from_treeview(self.manage_comm_tv,
                self.manage_comm_model, 2)

        dialog = gtk.Dialog(title='View comment', parent=None)
        dialog.set_size_request(600, 350)

        parea = hildon.PannableArea()
        textview = hildon.TextView()
        textview.modify_font(pango.FontDescription("Normal " + self.fontsize))
        textview.set_property("editable", False)
        textview.set_property("wrap-mode", gtk.WRAP_WORD)
        textview.get_buffer().set_text(content)
        parea.add(textview)

        label = gtk.Label()
        label.set_markup("<b>Author</b>: %s" % author)

        dialog.vbox.pack_start(label, False, False, 0)
        dialog.vbox.pack_start(parea, True, True, 0)

        dialog.show_all()
        dialog.run()
        dialog.destroy()

    def get_comments_from_post(self, widget, win, postid):
        winprogind(win, 1)
        thread.start_new(self._do_get_comments_from_post, (win, postid))

    def _do_get_comments_from_post(self, win, postid):
        try:
            if self.blogsystem == "Wordpress":
                from wordpy import wordpress
                comments = wordpress.get_comments_filtered(self.url, self.user,
                                    self.password, postid, self.numcomm)
            elif self.blogsystem == "Blogger":
                from wordpy import blogger
                comments = blogger.get_comments_filtered(self.user,
                                    self.password, postid, self.blogid,
                                    self.numcomm)
            if comments:
                winprogind(win, 0)
                self.manage_comm_model = \
                                    self.__create_manage_comm_model(comments)
                self.manage_comm_tv.set_model(self.manage_comm_model)
            else:
                winprogind(win, 0)
                self.show_banner_thread(win, "No comments for this post")
        except:
            logger.exception("Getting comments")
            winprogind(win, 0)
            self.show_banner_thread(win, "Error getting comments")

    def __create_manage_comm_model(self, comments):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,
                            gobject.TYPE_STRING, gobject.TYPE_STRING,
                            gobject.TYPE_STRING, gobject.TYPE_STRING)

        for item in comments:
            iter = lstore.append()
            lstore.set(iter, 0, item[0], 1, item[1], 2, item[2],
                        3, item[3], 4, item[4], 5, item[5])

        return lstore

    def _manage_comm_tv_columns(self, treeview):
        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        renderer = gtk.CellRendererText()
        renderer.set_property("ellipsize", pango.ELLIPSIZE_END)
        column = gtk.TreeViewColumn('Comment', renderer, text=1)
        column.set_expand(True)
        treeview.append_column(column)

        renderer = gtk.CellRendererText()
        renderer.set_property("ellipsize", pango.ELLIPSIZE_END)
        column = gtk.TreeViewColumn('Author', renderer, text=2)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(230)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('email', gtk.CellRendererText(), text=3)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('url', gtk.CellRendererText(), text=4)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Status", gtk.CellRendererText(), text=5)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(130)
        treeview.append_column(column)

    def on_edit_post(self, widget, win):
        if not utils.is_treeview_selected(self.manage_posts_tv):
            utils.show_info_banner(widget, "Must select a post")
            return
        winprogind(win, 1)
        thread.start_new(self._do_edit_post, (win,))

    def _do_edit_post(self, win):
        try:
            postid, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.manage_posts_tv,
                    self.manage_posts_model, 1)

            if self.blogsystem == 'Wordpress':
                from wordpy import wordpress
                post = wordpress.get_post_filtered(self.url, self.user,
                                                self.password, postid)
            elif self.blogsystem == 'Blogger':
                from wordpy import blogger
                post = blogger.get_post_filtered(self.user, self.password,
                                                postid, self.blogid)
            elif self.blogsystem == 'Livejournal':
                from wordpy import livejournal
                post = livejournal.get_post_filtered(self.user,
                                                self.password, postid)
            elif self.blogsystem == 'Drupal':
                from wordpy import drupal
                post = drupal.get_post_filtered(self.url, self.user,
                                                self.password, postid)
            self.set_edited_post(post)
            winprogind(win, 0)
        except:
            logger.exception("Error getting the post to edit")
            winprogind(win, 0)
            self.show_banner_thread(win, "Error getting the post")

    def set_edited_post(self, post):
        ## post = (title, content, extended, excerpt, ttags, tracks, tags, cats,
        ## date, slug, pssword, comments, pings, status, postid)

        self.is_edited = True
        self.title = post[0]
        self.posttext = post[1]
        self.extendedtext = post[2]
        #excerpt = post[3]
        self.ttags = post[4]
        #self.tbacks = post[5]
        self.tags = post[6]
        self.slug = post[9]
        self.postpassw = post[10]
        self.comments = post[11]
        self.pings = post[12]

        if post[13] == 'usemask':
            self.status = 'friends'
        else:
            self.status = post[13]

        if self.status == "draft":
            self.set_draft_image()
        else:
            self.set_publish_image()

        self.postid = post[14]

        if self.entitle:
            self.entitle.set_text(self.title)
            self.post_edited_btn.show()
        if self.txtPost:
            self.postBuffer.set_text(self.posttext)
        if self.txtPostExt:
            self.extendedBuffer.set_text(self.extendedtext)
        if self.enpostpassw:
            self.enpostpassw.set_text(self.postpassw)
            self.enttags.set_text(self.ttags)
            self.enslug.set_text(self.slug)
        if self.entags:
            self.entags.set_text(self.tags)

        self.cats = []
        for i in post[7]:
            cat = [str(i[0]), i[1]]
            self.cats.append(cat)

        self.date = post[8]
        #post[8] = [2009, 6, 30, 17, 57]
        self.sch_date = (int(post[8][0]), int(post[8][1])-1, int(post[8][2]))
        self.sch_time = (int(post[8][3]), int(post[8][4]))

        stack = self.window.get_stack()
        stack.pop_1()

        gtk.gdk.threads_enter()
        self.post_screen(None)
        gtk.gdk.threads_leave()


    def create_selector(self, data):
        selector = hildon.TouchSelector(text=True)

        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    def media_screen(self, widget):
        self.set_recentposts_to_label()

        win = hildon.StackableWindow()
        win.set_title("Upload Images")
        vbox1 = gtk.VBox()

        hbox1 = gtk.HBox()
        hbox1.set_homogeneous(True)

        self.flickrbtn = hildon.GtkRadioButton(fhsize)
        self.flickrbtn.set_mode(False)
        self.flickrbtn.set_label("To Flickr")
        self.picbtn = hildon.GtkRadioButton(fhsize)
        self.picbtn.set_mode(False)
        self.picbtn.set_label("To Picasa")
        self.picbtn.set_group(self.flickrbtn)
        self.pixelbtn = hildon.GtkRadioButton(fhsize)
        self.pixelbtn.set_mode(False)
        self.pixelbtn.set_label("To Pixelpipe")
        self.pixelbtn.set_group(self.flickrbtn)

        self.flickrbtn.connect("toggled", self.change_imgservice)
        self.pixelbtn.connect("toggled", self.change_imgservice)

        hbox1.pack_start(self.flickrbtn, True, True, 0)
        hbox1.pack_start(self.picbtn, True, True, 0)
        hbox1.pack_start(self.pixelbtn, True, True, 0)

        parea = hildon.PannableArea()
        self.imagelist_tv = hildon.GtkTreeView(ui_edit)
        selection = self.imagelist_tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
        if not self.imglist_model:
            self.imglist_model = self.__create_imglist_model('')
        self.imagelist_tv.set_model(self.imglist_model)
        self._imglist_tv_columns(self.imagelist_tv)

        parea.add(self.imagelist_tv)

        hbox2 = gtk.HBox()

        button1 = hildon.Button(fhsize, horbtn)
        button1.connect("clicked", self.add_img_to_list, win)
        img = gtk.Image()
        img.set_from_file(imgdir + "add-big.png")
        button1.set_image(img)

        button2 = hildon.Button(fhsize, horbtn)
        button2.connect("clicked", self.delete_img_from_list)
        img = gtk.Image()
        img.set_from_file(imgdir + "remove.png")
        button2.set_image(img)

        button3 = hildon.Button(fhsize, horbtn)
        button3.connect("clicked", self.img_desc_screen)
        img = gtk.Image()
        img.set_from_file(imgdir + "edit.png")
        button3.set_image(img)

        button4 = hildon.Button(fhsize, horbtn)
        button4.connect("clicked", self.clear_image_list)
        img = gtk.Image()
        img.set_from_file(imgdir + "clear.png")
        button4.set_image(img)

        button5 = hildon.Button(fhsize, horbtn)
        button5.connect("clicked", self.upload_images)
        img = gtk.Image()
        img.set_from_file(imgdir + "up.png")
        button5.set_image(img)

        vbox1.pack_start(hbox1, False, False, 0)

        vbox2 = gtk.VBox()
        vbox2.set_homogeneous(True)
        vbox2.pack_start(button1, False, False, 0)
        vbox2.pack_start(button2, False, False, 0)
        vbox2.pack_start(button3, False, False, 0)
        vbox2.pack_start(button4, False, False, 0)
        vbox2.pack_start(button5, False, False, 0)
        hbox2.pack_start(parea, True, True, 0)
        hbox2.pack_start(vbox2, False, False, 0)

        vbox1.pack_start(hbox2, False, False, 0)

        win.add(vbox1)

        win.show_all()

    def upload_images(self, widget):
        if all_images == []:
            utils.show_info_banner(widget, "No images to upload")
            return

        #self.cancel_media_upload = False
        if self.imgservice == "Picasa":
            for image in all_images:
                if image[1] == "":
                    utils.show_info_banner(widget, \
                                        "Add a title to your images")
                    return
                if image[8] == "":
                    utils.show_info_banner(widget, \
                                        "Select an album where upload the images")
                    return


        self.uploading_img_screen()

        self.upinfo_title.set_markup('<b>Uploading files...</b>')
        self.timer = gobject.timeout_add (100, self.progress_timeout)
        thread.start_new(self.do_upload_images, ())

    def do_upload_images(self):
        from wordpy import flickr, picasa
        import urllib2
        #[[file, title, desc, tags, public, friend, family, [setsid], album]]

        try:
            filename_lb = self.upinfo_filename
            if self.imgservice == "Flickr":
                myflickr = flickr.Flickr('', False)
                myflickr.upload(all_images, filename_lb)
            elif self.imgservice == "Pixelpipe":
                pixelpipe = flickr.Flickr('', True)
                pixelpipe.upload(all_images, filename_lb)
            elif self.imgservice == "Picasa":
                mypicasa = picasa.Picasa(self.picasa_login, self.picasa_pass)
                mypicasa.uploadPhotos(all_images, filename_lb)

            self.destroy_progress()
            self.on_upload_complete('Upload complete')
        except Exception, e:
            logger.exception("Uploading media")
            self.destroy_progress()

            #Check if it's an URLError
            if "urlopen error" in str(e):
                e = "Connection failed"

            self.on_upload_complete('Upload failed: %s' % e)

    def progress_timeout(self):
        self.upinfo_pgbar.pulse()
        return True

    def destroy_progress(self):
        if self.timer > 0:
            gobject.source_remove(self.timer)
        self.timer = 0

    def on_upload_complete(self, upinfo):
        self.upinfo_pgbar.hide()
        #self.cancel_upinfo_btn.hide()
        self.upinfo_title.set_markup('<b>'+upinfo+'</b>')
        self.upinfo_filename.set_text('')

    def uploading_img_screen(self):
        win = hildon.StackableWindow()
        win.set_title("Uploading images")

        vbox1 = gtk.VBox()

        self.upinfo_title = gtk.Label()
        self.upinfo_filename = gtk.Label()
        self.upinfo_pgbar = gtk.ProgressBar()
        self.upinfo_pgbar.set_pulse_step(0.05)

        #self.cancel_upinfo_btn = hildon.Button(fhsize, horbtn)
        #self.cancel_upinfo_btn.connect("clicked", self.publish_post)
        #self.cancel_upinfo_btn.set_title("Cancel")

        vbox1.pack_start(self.upinfo_title, True, True, 5)
        vbox1.pack_start(self.upinfo_filename, True, True, 5)
        vbox1.pack_start(self.upinfo_pgbar, False, False, 5)
        #vbox1.pack_start(self.cancel_upinfo_btn, False, False, 5)

        win.add(vbox1)

        win.show_all()

    def change_imgservice(self, button):
        if self.flickrbtn.get_active():
            self.imgservice = 'Flickr'
        elif self.picbtn.get_active():
            self.imgservice = 'Picasa'
        elif self.pixelbtn.get_active():
            self.imgservice = 'Pixelpipe'

        logger.debug("Selected service to upload files: %s" % self.imgservice)

    def img_desc_screen(self, widget):
        if not utils.is_treeview_selected(self.imagelist_tv):
            return

        # Setting the correct value to the widgets:
        image = self.get_img_description()
        logger.debug("images selected: %s" % image)
        if len(image) > 1:
            filename = "Multiple files"
            title = ""
            tags = ""
            desc = ""
            album = self.defalbum
        else:
            filename = os.path.basename(image[0][0])
            title = image[0][1]
            tags = image[0][3]
            desc = image[0][2]
            album = image[0][8]

        win = hildon.StackableWindow()
        win.set_title("Describe images - " + filename)
        vbox1 = gtk.VBox()

        entry1 = hildon.Entry(fhsize)
        entry1.set_placeholder("Title")
        entry1.set_text(title)
        entry1.connect("changed", self.change_imgtitle, image)
        entry2 = hildon.Entry(fhsize)
        entry2.set_placeholder("Tags")
        entry2.set_text(tags)
        entry2.connect("changed", self.change_imgtags, image)

        parea = hildon.PannableArea()
        tv = hildon.TextView()
        tv.modify_font(pango.FontDescription("Normal " + self.fontsize))
        tv.set_wrap_mode(gtk.WRAP_WORD)
        tv.get_buffer().set_text(desc)
        tv.set_placeholder("Description")
        tv.get_buffer().connect("changed", self.change_imgdesc, image)
        parea.add(tv)

        button1 = hildon.Button(fhsize, horbtn)
        button1.connect("clicked", self.adv_img_desc_screen, image)
        if self.imgservice == 'Picasa':
            button1.set_title("Select album")
            button1.set_value(album)
        else:
            button1.set_title("Advanced")
            button1.set_value("")

        vbox1.pack_start(entry1, False, False, 0)
        vbox1.pack_start(entry2, False, False, 0)
        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(button1, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def change_imgtitle(self, entry, image):
        for i in range(len(image)):
            image[i][1] = entry.get_text()
        logger.debug("%s" % image)

    def change_imgtags(self, entry, image):
        for i in range(len(image)):
            image[i][3] = entry.get_text()
        logger.debug("%s" % image)

    def change_imgdesc(self, textbuffer, image):
        start, end = textbuffer.get_bounds()
        desc = textbuffer.get_text(start, end)
        for i in range(len(image)):
            image[i][2] = desc
        logger.debug("%s" % image)

    def get_img_description(self):
        selection = self.imagelist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        image = []
        for seliter in iters:
            filename = self.imglist_model.get_value(seliter, 2)
            for i in range(len(all_images)):
                if all_images[i][0] == filename:
                    image.append(all_images[i])
                    break
        return image

    def adv_img_desc_screen(self, button, image):
        if self.imgservice == 'Picasa':
            self.adv_picasa_screen(image, button)
        else:
            self.adv_flickr_screen(image)

    def adv_picasa_screen(self, image, btn):
        dlg = hildon.PickerDialog(self.window)
        dlg.set_title("Choose Picasa Album")
        selector = self.create_selector(self.picasa_albumlist)
        selector.connect("changed", self.select_picasa_alb, dlg, image, btn)
        dlg.set_selector(selector)
        dlg.show_all()

    def select_picasa_alb(self, selector, column, dlg, image, btn):
        for i in range(len(image)):
            image[i][8] = selector.get_current_text()
        btn.set_value(image[0][8])
        dlg.destroy()
        logger.debug("all_images: %s" % all_images)

    def adv_flickr_screen(self, image):
        win = hildon.StackableWindow()
        win.set_title("Advanced %s options" % self.imgservice)

        hbox1 = gtk.HBox()
        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        rbutton1 = hildon.GtkRadioButton(fhsize)
        rbutton1.set_mode(False)
        rbutton1.set_label("Public")
        rbutton2 = hildon.GtkRadioButton(fhsize)
        rbutton2.set_mode(False)
        rbutton2.set_label("Private")
        rbutton2.set_group(rbutton1)

        cbutton1 = hildon.CheckButton(fhsize)
        cbutton1.set_label("Friends")
        cbutton2 = hildon.CheckButton(fhsize)
        cbutton2.set_label("Family")

        self.do_private_img_widgets_insensitive(cbutton1, cbutton2)
        cbutton1.connect('toggled', self.change_friends_tag, image)
        cbutton2.connect('toggled', self.change_family_tag, image)

        if image[0][4] == 1 or len(image) >1:
            rbutton1.set_active(True)
            cbutton1.set_active(False)
            cbutton2.set_active(False)
        else:
            rbutton1.set_active(False)
            rbutton2.set_active(True)
            cbutton1.set_sensitive(True)
            cbutton2.set_sensitive(True)
            if image[0][5] == 1:
                cbutton1.set_active(True)
            else:
                cbutton1.set_active(False)
            if image[0][6] == 1:
                cbutton2.set_active(True)
            else:
                cbutton2.set_active(False)

        rbutton1.connect('toggled', self.on_public_img_active, rbutton2, \
                        cbutton1, cbutton2, image)

        label1 = gtk.Label("Privacy")

        vbox1.pack_start(label1, False, False, 0)
        vbox1.pack_start(rbutton1, False, False, 0)
        vbox1.pack_start(rbutton2, False, False, 0)
        vbox1.pack_start(cbutton1, False, False, 0)
        vbox1.pack_start(cbutton2, False, False, 0)

        separator = gtk.HSeparator()

        vbox2 = gtk.VBox()

        parea = hildon.PannableArea()
        tv = hildon.GtkTreeView(ui_edit)
        selection = tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
        self._sets_tv_columns(tv)

        setlist = self.load_temp_setlist()
        if setlist is not []:
            self.sets_model = self.__create_sets_model(setlist)
        else:
            self.sets_model = self.__create_sets_model('')

        tv.set_model(self.sets_model)
        if not len(image) > 1:
            self.on_select_flickr_sets(selection, image)
        selection.connect("changed", self.set_flickr_sets, image)

        parea.add(tv)

        button1 = hildon.Button(fhsize, horbtn)
        button1.connect("clicked", self.on_get_flickr_sets, win, tv)
        button1.set_title("Get Sets")

        vbox2.pack_start(parea, True, True, 0)
        vbox2.pack_start(button1, False, False, 0)

        hbox1.pack_start(vbox1, False, False, 0)
        hbox1.pack_start(separator, False, False, 0)
        hbox1.pack_start(vbox2, True, True, 0)

        win.add(hbox1)
        win.show_all()

    def on_select_flickr_sets(self, selection, image):
        for i in range(len(self.sets_model)):
            if self.sets_model[i][0] in image[0][7]:
                seliter = self.sets_model.get_iter(i)
                selection.select_iter(seliter)

    def set_flickr_sets(self, selection, image):
        for h in range(len(image)):
            image[h][7] = []
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        for i in iters:
            for j in range(len(image)):
                image[j][7].append(selmodel.get_value(i, 0))

        logger.debug("%s" % image)

    def change_friends_tag(self, widget, image):
        if widget.get_active():
            for i in range(len(image)):
                image[i][5] = 1
        else:
            for i in range(len(image)):
                image[i][5] = 0

        logger.debug("%s" % all_images)

    def change_family_tag(self, widget, image):
        if widget.get_active():
            for i in range(len(image)):
                image[i][6] = 1
        else:
            for i in range(len(image)):
                image[i][6] = 0

        logger.debug("%s" % all_images)

    def on_public_img_active(self, widget, rbutton2, cbutton1, cbutton2, image):
        if widget.get_active():
            for i in range(len(image)):
                image[i][4] = 1
                image[i][5] = 0
                image[i][6] = 0
            self.do_private_img_widgets_insensitive(cbutton1, cbutton2)
        else:
            for i in range(len(image)):
                image[i][4] = 0
                image[i][5] = 0
                image[i][6] = 0
            cbutton1.set_sensitive(True)
            cbutton2.set_sensitive(True)

        logger.debug("%s" % all_images)

    def do_private_img_widgets_insensitive(self, cbutton1, cbutton2):
        cbutton1.set_sensitive(False)
        cbutton2.set_sensitive(False)
        cbutton1.set_active(False)
        cbutton2.set_active(False)

    def __create_sets_model(self, setlist):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        for item in setlist:
            iter = lstore.append()
            lstore.set(iter, 0, item[0], 1, item[1])

        return lstore

    def on_get_flickr_sets(self, widget, win, treeview):
        winprogind(win, 1)
        thread.start_new(self._do_get_flickr_sets, (win, treeview))

    def _do_get_flickr_sets(self, win, treeview):
        from wordpy import flickr
        try:
            if self.imgservice == "Flickr":
                pixelpipe = False
            else:
                pixelpipe = True
            myflickr = flickr.Flickr('', pixelpipe)
            setlist = myflickr.get_set_list()
            winprogind(win, 0)
        except:
            logger.exception('Getting Flickr sets')
            winprogind(win, 0)
            self.show_banner_thread(win, 'Error getting Flickr sets')
            setlist = []

        self.sets_model.clear()
        #setlist = [(id, name)]
        self.save_temp_setlist(setlist)
        self.sets_model = self.__create_sets_model(setlist)
        treeview.set_model(self.sets_model)

    def save_temp_setlist(self, setlist):
        import tempfile
        tmpdir = tempfile.mkdtemp(prefix='mastory-flickr') + "/"
        tmpfile = tmpdir + 'flickr_setlist'
        logger.debug("Creating tempfile: %s" % tmpfile)
        sets = ''
        for i in range(len(setlist)):
            if i < len(setlist)-1:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1] + '|||'
            else:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1]

        tmpalb = open(tmpfile, 'w')
        tmpalb.write(sets)
        tmpalb.close()

    def load_temp_setlist(self):
        setlist = []
        tmpfile = False
        for i in os.listdir("/var/tmp"):
            if i.find("mastory-flickr") >= 0:
                tmpfile = "/var/tmp/"+i+"/flickr_setlist"
                break

        if tmpfile:
            albfile = open(tmpfile, 'r')
            sets = albfile.read()
            albfile.close()
            for i in sets.split('|||'):
                setlist.append(tuple(i.split('|@|')))

        return setlist

    def _sets_tv_columns(self, treeview):
        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Set", gtk.CellRendererText(), text=1)
        treeview.append_column(column)

    def __create_imglist_model(self, imgfile):
        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING, \
                                gobject.TYPE_STRING)
        #niter = lstore.append()
        #lstore.set(niter, 0, imgfile)
        return lstore

    def _imglist_tv_columns(self, treeview):
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn('', renderer, pixbuf=0)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Filename', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)

    def clear_image_list(self, widget):
        self.imglist_model.clear()
        del all_images[:]

    def delete_img_from_list(self, widget):
        if not utils.is_treeview_selected(self.imagelist_tv):
            return

        selection = self.imagelist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]

        for i in iters:
            selname = selmodel.get_value(i, 2)
            selmodel.remove(i)
            for i in range(len(all_images)):
                if all_images[i][0] == selname:
                    del all_images[i]
                    break

    def add_img_to_list(self, widget, win):
        from wordpy import utils
        imgfiles = utils.file_browser(self.window, \
                        gtk.FILE_CHOOSER_ACTION_OPEN, "Select Image", \
                        self.path_add_img, "", "", True, True)

        if not imgfiles:
            return
        winprogind(win, 1)
        thread.start_new_thread(self._do_add_img_to_list, (imgfiles, win))

    def _do_add_img_to_list(self, imgfiles, win):
        import gc
        from wordpy import utils
        self.path_add_img = os.path.dirname(imgfiles[len(imgfiles)-1])
        imgfiles = self.detect_folders(imgfiles)
        for filename in imgfiles:
            try:
                pixbuf = utils.file_to_pixbuf(filename, 'small')
                if filename is not None:
                    niter = self.imglist_model.append()
                    self.imglist_model.set(niter, 0, pixbuf, 1, \
                                    os.path.basename(filename), 2, filename)
                    del pixbuf
                    gc.collect()
                    image = [filename, '', '', '', 1, 0, 0, [], self.defalbum]
                    all_images.append(image)
                logger.debug("%s" % all_images)
            except:
                logger.error("Failed adding image: %s" % filename)
        winprogind(win, 0)

    def detect_folders(self, imgfiles):
        for i in imgfiles:
            if os.path.isdir(i):
                newfiles = os.listdir(i)
                del imgfiles[imgfiles.index(i)]
                for j in range(len(newfiles)):
                    imgfiles.append(i + '/' + newfiles[j])
                for k in imgfiles:
                    if os.path.isdir(k):
                        self.detect_folders(imgfiles)

        return imgfiles

    def settings_screen(self, widget):
        self.set_recentposts_to_label()

        win = hildon.StackableWindow()
        win.set_title("Settings")

        hbox1 = gtk.HButtonBox()
        hbox1.set_homogeneous(True)
        hbox1.set_property('layout-style', gtk.BUTTONBOX_SPREAD)

        button1 = hildon.Button(thsize, horbtn)
        button1.set_title("Accounts")
        button1.connect("clicked", self.accounts_stn_screen)

        button2 = hildon.Button(thsize, horbtn)
        button2.connect("clicked", self.general_stn_screen)
        button2.set_title("General")

        button3 = hildon.Button(thsize, horbtn)
        button3.connect("clicked", self.media_stn_screen)
        button3.set_title("Media")

        hbox1.add(button1)
        hbox1.add(button2)
        hbox1.add(button3)

        win.add(hbox1)
        win.show_all()

    def accounts_stn_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("Accounts")

        vbox1 = gtk.VBox()

        parea = hildon.PannableArea()

        self.accounts_tv = hildon.GtkTreeView(ui_edit)
        self.accounts_model = self.create_accounts_list()
        self.accounts_tv.set_model(self.accounts_model)
        self.add_accounts_tv_columns(self.accounts_tv)

        parea.add(self.accounts_tv)

        hbox1 = gtk.HBox()

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title("New")
        button1.connect("clicked", self.on_new_account, False)

        button2 = hildon.Button(fhsize, horbtn)
        button2.connect("clicked", self.on_new_account, True)
        button2.set_title("Edit")

        button3 = hildon.Button(fhsize, horbtn)
        button3.connect("clicked", self.delete_account)
        button3.set_title("Delete")

        button4 = hildon.Button(fhsize, horbtn)
        button4.connect("clicked", self.make_default_account)
        button4.set_title("Make default")

        hbox1.pack_start(button1, True, True, 0)
        hbox1.pack_start(button2, True, True, 0)
        hbox1.pack_start(button3, True, True, 0)
        hbox1.pack_start(button4, True, True, 0)

        vbox1.pack_start(parea, True, True, 0)
        vbox1.pack_start(hbox1, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def create_accounts_list(self):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, \
                                gobject.TYPE_STRING)
        alist = settings.get_account_list(accounts_db)
        ##this funcion will query to the accounts database and
        #get the name and system of accounts
        #account_list ==
        #[['name1', 'Blogger', 'True'], ['name2, 'Wordpress', 'False']]

        for item in alist:
            liter = lstore.append()
            if item[2] == "True":
                lstore.set(liter, 0, '·', 1, item[0], 2, item[1])
            else:
                lstore.set(liter, 0, '', 1, item[0], 2, item[1])
        return lstore

    def add_accounts_tv_columns(self, treeview):
        # column for account name
        renderer = gtk.CellRendererText()
        renderer.set_property('scale', 2.5)
        column = gtk.TreeViewColumn('', renderer, text=0)
        treeview.append_column(column)

        # column for account name
        renderer = gtk.CellRendererText()
        #renderer.set_property('scale', 1.3)
        renderer.set_property('wrap-mode', gtk.WRAP_WORD)
        renderer.set_property('wrap-width', 500)
        column = gtk.TreeViewColumn('Name', renderer, text=1)
        column.set_property("expand", True)
        treeview.append_column(column)

        # column for blog system
        renderer = gtk.CellRendererText()
        #renderer.set_property('scale', 1.3)
        column = gtk.TreeViewColumn('system', renderer, text=2)
        treeview.append_column(column)

    def on_new_account(self, widget, edit):
        if edit == False:
            title = "New account"
            blogsystem = "Wordpress"
            accountname = ""
            username = ""
            password = ""
            blogid = ""
            blogname = ""
            blogurl = ""
            enabled = False
        else:
            if not utils.is_treeview_selected(self.accounts_tv):
                utils.show_info_banner(widget, "Select an account")
                return

            title = "Edit account"
            blogsystem, account = self._get_account_details()
            self.account_id = account[0]
            accountname = account[1]
            username = account[2]
            password = account[3]
            blogid = account[4]
            blogname = account[5]
            blogurl = account[6]
            self.enabled = account[7]
            self.bloglist = []
            self.bloglist.append([blogname, blogid])


        win = hildon.StackableWindow()
        win.set_title(title)

        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        entry1 = hildon.Entry(fhsize)
        entry1.set_placeholder("Account name")
        entry1.set_text(accountname)

        button1 = hildon.PickerButton(fhsize, horbtn)
        button1.set_title("Blog system")
        data = ["Wordpress", "Blogger", "Livejournal", "Drupal"]
        selector = self.create_selector(data)
        button1.set_selector(selector)
        button1.set_value(blogsystem)
        self.select_default_value(button1, data, selector)

        entry2 = hildon.Entry(fhsize)
        entry2.set_text(username)
        entry2.set_placeholder("Username")
        entry2.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)

        entry3 = hildon.Entry(fhsize)
        entry3.set_placeholder("Password")
        entry3.set_text(password)
        entry3.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        entry3.set_visibility(False)

        entry4 = hildon.Entry(fhsize)
        entry4.set_placeholder("Blog URL")
        entry4.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        entry4.set_text(blogurl)

        hbox2 = gtk.HBox()

        button3 = hildon.PickerButton(fhsize, horbtn)
        button3.set_title("Select blog")
        #data = [""]
        #selector = self.create_selector(data)
        #button3.set_selector(selector)
        button3.set_value(blogname)

        button2 = hildon.Button(fhsize, horbtn)
        button2.set_title("Get blogs")
        button2.connect("clicked", self.get_blogger_bloglist, win, selector, \
                         entry2, entry3, button3)

        hbox2.pack_start(button3, True, True, 0)
        hbox2.pack_start(button2, False, False, 0)

        button4 = hildon.Button(fhsize, horbtn)
        button4.set_title("Save")
        widgets = [entry1, button1, entry2, entry3, entry4, button3]
        button4.connect("clicked", self.finish_new_account, edit, widgets)

        button1.connect("value-changed", self.on_select_blog_system, \
                        hbox2, entry4)

        vbox1.pack_start(button1, False, False, 0)
        vbox1.pack_start(entry1, False, False, 0)
        vbox1.pack_start(entry2, False, False, 0)
        vbox1.pack_start(entry3, False, False, 0)
        vbox1.pack_start(entry4, False, False, 0)
        vbox1.pack_start(hbox2, False, False, 0)
        vbox1.pack_start(button4, False, False, 0)

        win.add(vbox1)
        win.show_all()
        if blogsystem == "Blogger":
            entry4.hide()
        elif blogsystem == "Livejournal":
            entry4.hide()
            hbox2.hide()
        else:
            hbox2.hide()

    def finish_new_account(self, button, edit, widgets):
        #widgets = [name, system, user, pass, url, blogs]

        blogsystem = widgets[1].get_value()
        accountname = widgets[0].get_text()
        user = widgets[2].get_text()
        password = widgets[3].get_text()
        blogurl = widgets[4].get_text()
        blogname = widgets[5].get_value()

        if accountname == "":
            utils.show_info_banner(button,
                                "Please, complete the account settings")
            return

        if blogsystem == "Wordpress" or blogsystem == "Drupal":
            if user == '' or password == '' or blogurl == '':
                utils.show_info_banner(button,
                                "Please, complete the account settings")
                return

        if blogsystem == "Livejournal":
             if user == '' or password == '':
                utils.show_info_banner(button,
                                "Please, complete the account settings")
                return

        if blogsystem == "Blogger":
            if user == '' or password == '' or blogname == '':
                utils.show_info_banner(button,
                                "Please, complete the account settings")
                return
        try:
            logger.debug("bloglist: %s" % self.bloglist)
            for i in self.bloglist:
                if i[0] == blogname:
                    blogid = i[1]
        except:
            blogid = ''


        if edit:
            try:
                oldname, oldsystem, siter, selmodel = \
                                        self.get_name_and_system()
                settings.edit_account(accounts_db, accountname, blogsystem, \
                            user, password, blogid, blogname, blogurl, \
                            self.account_id, self.enabled, oldsystem, oldname)
                utils.show_info_banner(button, 'Account edited')
                oldname, seliter, selmodel = \
                            utils.get_selected_from_treeview(self.accounts_tv,\
                            self.accounts_model, 0)

                #Enabled is as the last state, no setting here
                new_item = [accountname, blogsystem, '']
                self.accounts_model.set(seliter, 1, new_item[0], \
                                    2, new_item[1])
                self.set_default_settings()
            except:
                logger.exception("Editing account")
                utils.show_info_banner(button, "Error editing account")
                return
        else:
            try:
                name_list = []
                #Get all acountnames
                for i in range(len((self.accounts_model))):
                    name_list.append(self.accounts_model[i][1])

                logger.debug("accts-newname: %s-%s" % (name_list, accountname))
                #If new accountname is duplicated, don't save
                if accountname in name_list:
                    utils.show_info_banner(button, 'Duplicated account name')
                    return

                n_tables = settings.new_account(accounts_db, accountname,
                                                blogsystem, user, password,
                                                blogid, blogname, blogurl)

                if n_tables == 0:
                    logger.debug("Enabling first account")
                    enabled = '·'
                    self.set_default_settings()
                else:
                    enabled = ''
                new_item = [accountname, blogsystem, enabled]
                newiter = self.accounts_model.append()
                self.accounts_model.set(newiter, 0, new_item[2],
                                        1, new_item[0],
                                        2, new_item[1])

                self.set_default_settings()

                utils.show_info_banner(button, 'Account added')
            except:
                logger.exception('Saving account')
                utils.show_info_banner(button, "Error saving account")
                return

        stack = self.window.get_stack()
        stack.pop_1()

    def on_select_blog_system(self, widget, box, entry):
        if widget.get_value() == "Blogger":
            box.show()
            entry.hide()
        elif widget.get_value() == "Livejournal":
            box.hide()
            entry.hide()
        else:
            box.hide()
            entry.show()

    def _get_account_details(self):
        accountname, blogsystem, siter, selmodel = self.get_name_and_system()
        account = settings.get_account_settings(accounts_db, blogsystem, \
                                                accountname)

        ##account = (id, accountname, user, password, blogid,
        ##blogname, blogurl, enabled)

        return blogsystem, account

    def get_name_and_system(self):
        name, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.accounts_tv, \
                    self.accounts_model, 1)
        system, seliter, selmodel = \
                    utils.get_selected_from_treeview(self.accounts_tv, \
                    self.accounts_model, 2)

        return name, system, seliter, selmodel

    def get_blogger_bloglist(self, widget, win, selector, user, passw, btn):
        winprogind(win, 1)
        thread.start_new(self._do_get_blogger_bloglist, (win, selector, user, \
                                                        passw, btn))

    def _do_get_blogger_bloglist(self, win, selector, user, passw, btn):
        from wordpy import blogger
        data = []
        user = user.get_text()
        passw = passw.get_text()
        try:
            bgclient = blogger.create_blogger_client(user, passw)
            #bloglist = [['blog1', 12], ['blog2', 45]]
            self.bloglist = blogger.get_blog_list(bgclient)

            #print self.bloglist

            for item in self.bloglist:
                data.append(item[0])
            winprogind(win, 0)
            selector = self.create_selector(data)
            #If the user has cancelled the action, don't set the values
            if not btn.get_parent_window():
                return

            btn.set_selector(selector)
            btn.set_value(data[0])
            self.select_default_value(btn, data, selector)
        except:
            logger.exception('Getting the blog list')
            winprogind(win, 0)
            self.show_banner_thread(win, 'Error getting the blog list')

    def delete_account(self, widget):
        try:
            if not utils.is_treeview_selected(self.accounts_tv):
                return

            accountname, blogsystem, seliter, selmodel = \
                                                self.get_name_and_system()

            for i in range(len((selmodel))):
                if selmodel[i][1] == accountname:
                    row_selected = i

            confirmation = utils.show_confirmation(self.window,
                            "Delete account?")
            if confirmation == True:
                if selmodel[row_selected][0] == '·':
                    logger.debug("Deleting default account")
                    selmodel.remove(seliter)
                    if len(self.accounts_model) > 0:
                        self.accounts_model[0][0] = '·'
                        newblogsystem = self.accounts_model[0][2]
                        newaccountname = self.accounts_model[0][1]
                        settings.make_default(accounts_db, newblogsystem, \
                                                        newaccountname, True)
                else:
                    logger.debug("Deleting not default account")
                    selmodel.remove(seliter)

                settings.delete_account(accounts_db, blogsystem, accountname)
                self.set_default_settings()
                utils.show_info_banner(widget, 'Account deleted')

            else:
                return
        except:
            logger.exception('Deleting account')
            utils.show_info_banner(widget, 'Error deleting account')

    def make_default_account(self, widget):
        try:
            if not utils.is_treeview_selected(self.accounts_tv):
                return

            accountname, blogsystem, seliter, selmodel = \
                                        self.get_name_and_system()

            #[['account1', 'Blogger', 'True'], ['acc2', 'Wordpress', 'False']]
            accountlist = settings.get_account_list(accounts_db)
            for i in range(len(accountlist)):
                if accountlist[i][2] == 'True':
                    oldname = accountlist[i][0]
                    oldsystem = accountlist[i][1]

            try:
                settings.make_default(accounts_db, oldsystem, oldname, False)
            except UnboundLocalError:
                pass

            settings.make_default(accounts_db, blogsystem, accountname, True)

            # Unsetting the old default account in the treeview.
            for i in range(len(self.accounts_model)):
                if oldname == self.accounts_model[i][1]:
                    self.accounts_model[i][0] = ''

            new_item = [accountname, blogsystem, '·']
            self.accounts_model.set(seliter, 0, new_item[2], \
                    1, new_item[0], 2, new_item[1])

            self.set_default_settings()
            # Cleaning any categories, other accounts have differents cats!
            self.cats = []
            try:
                self.manage_posts_model.clear()
            except:
                pass
        except:
            logger.exception('Making the default account')
            utils.show_info_banner(widget, "Error making default account")

    def media_stn_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("Media Settings")

        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        label1 = gtk.Label("Picasa settings")

        entry1 = hildon.Entry(fhsize)
        entry1.set_placeholder("Username")
        entry1.connect("changed", self.on_setting_change, 'picasa_login')
        entry1.set_text(self.picasa_login)
        entry1.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        entry2 = hildon.Entry(fhsize)
        entry2.set_placeholder("Password")
        entry2.set_text(self.picasa_pass)
        entry2.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        entry2.set_visibility(False)
        entry2.connect("changed", self.on_setting_change, 'picasa_pass')

        hbox2 = gtk.HBox()

        button2 = hildon.PickerButton(fhsize, horbtn)
        button2.set_title("Select default album")
        print 'albumlist: ', self.picasa_albumlist
        if self.picasa_albumlist != [] and self.picasa_albumlist != ['']:
            selector = self.create_selector(self.picasa_albumlist)
            button2.set_selector(selector)
            button2.set_value(self.defalbum)
            self.select_default_value(button2, self.picasa_albumlist, selector)
        button2.connect("value-changed", self.change_picasa_defalbum)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title("Get albums")
        button1.connect("clicked", self.get_picasa_albumlist, win, button2)

        hbox2.pack_start(button2, True, True, 0)
        hbox2.pack_start(button1, False, False, 0)

        label2 = gtk.Label("Flickr settings:")

        hbox3 = gtk.HBox()
        hbox3.set_homogeneous(True)

        button3 = hildon.Button(fhsize, horbtn)
        button3.set_title("Authorize Flickr")
        button3.connect("clicked", self.on_authorize_to_flickr, win, False)

        button4 = hildon.PickerButton(fhsize, horbtn)
        button4.set_title("Photos per page")
        data = ["5", "10", "15", "20"]
        selector = self.create_selector(data)
        button4.set_selector(selector)
        button4.set_value(str(self.perpage))
        button4.connect("value-changed", self.change_perpage)
        self.select_default_value(button4, data, selector)

        hbox3.pack_start(label2, True, True, 0)
        hbox3.pack_start(button4, True, True, 0)


        hbox4 = gtk.HBox()
        hbox4.set_homogeneous(True)

        button5 = hildon.Button(fhsize, horbtn)
        button5.set_title("Authorize Pixelpipe")
        button5.connect("clicked", self.on_authorize_to_flickr, win, True)

        hbox4.pack_start(button3, True, True, 0)
        hbox4.pack_start(button5, True, True, 0)

        vbox1.pack_start(label1, False, False, 0)
        vbox1.pack_start(hbox2, False, False, 0)
        vbox1.pack_start(entry1, False, False, 0)
        vbox1.pack_start(entry2, False, False, 0)

        vbox1.pack_start(hbox3, False, False, 0)
        vbox1.pack_start(hbox4, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def on_setting_change(self, widget, setting):
        if setting == "picasa_login":
            self.picasa_login = widget.get_text()
        elif setting == "picasa_pass":
            self.picasa_pass = widget.get_text()

    def get_picasa_albumlist(self, widget, win, button):
        winprogind(win, 1)
        thread.start_new(self._do_get_picasa_albumlist, (win, button))

    def _do_get_picasa_albumlist(self, win, button):
        from wordpy import picasa
        self.picasa_albumlist = []
        try:
            mypicasa = picasa.Picasa(self.picasa_login, self.picasa_pass)
            albums, albumlist = mypicasa.getAlbums()

            for item in albumlist:
                self.picasa_albumlist.append(item)

            winprogind(win, 0)
            selector = self.create_selector(self.picasa_albumlist)
            button.set_selector(selector)
            button.set_value(self.picasa_albumlist[0])
            self.change_picasa_defalbum(button)
        except:
            winprogind(win, 0)
            self.show_banner_thread(win, "Error getting Picasa album list")
            logger.exception("Getting Picasa album list")

    def change_picasa_defalbum(self, button):
        self.defalbum = button.get_value()

    def change_perpage(self, button):
        self.perpage = int(button.get_value())

    def on_authorize_to_flickr(self, widget, win, pixelpipe):
        from wordpy import flickr
        try:
            flickr.authorize_on_flickr(self.window, pixelpipe)
        except:
            if pixelpipe:
                service = "Pixelpipe"
            else:
                service = "Flickr"
            utils.show_info_banner(widget, "Error authorizing on %s" % service)
            logger.exception("Authorizing on %s" % service)


    def select_default_value(self, button, data, selector):
        try:
            value = button.get_value()
            ind = data.index(value)
            selector.set_active(0, ind)
        except:
            selector.set_active(0, 0)

    def general_stn_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("General Settings")

        vbox1 = gtk.VBox()
        vbox1.set_homogeneous(True)

        button1 = hildon.PickerButton(fhsize, horbtn)
        button1.set_title("Fontsize for text entries")
        data = ["14", "16", "17", "18", "19", "20", "22", "24", "26", "28"]
        selector = self.create_selector(data)
        button1.set_selector(selector)
        button1.set_value(str(self.fontsize))
        button1.connect("value-changed", self.change_fontsize)
        self.select_default_value(button1, data, selector)

        cbutton = hildon.CheckButton(fhsize)
        cbutton.set_label("Autosave on")

        if self.autosave_on == 1:
            cbutton.set_active(True)
        else:
            cbutton.set_active(False)

        button2 = hildon.PickerButton(fhsize, horbtn)
        button2.set_title("Autosave time (minutes)")
        data = ["1", "5", "10", "15", "30", "60"]
        selector = self.create_selector(data)
        button2.set_selector(selector)
        button2.set_value(str(self.autosave_time))
        button2.connect("value-changed", self.change_as_time)
        self.select_default_value(button2, data, selector)


        button3 = hildon.Button(fhsize, horbtn)
        button3.set_title("Autosave path")
        button3.connect("clicked", self.on_select_autosave_path)

        name = self.autosave_path.replace(HOME, '')[1:]
        if len(name) > 40:
            name = name[:37] + '...'
        button3.set_value(name)

        cbutton.connect('toggled', self.on_autosave_cb_toggled, \
                        button2, button3)

        if not cbutton.get_active():
            button2.set_sensitive(False)
            button3.set_sensitive(False)

        button4 = hildon.PickerButton(fhsize, horbtn)
        button4.set_title("Posts in post list")
        data = ["5", "10", "15", "20", "25", "40", "50", "75", \
                "100", "150", "200"]
        selector = self.create_selector(data)
        button4.set_selector(selector)
        button4.set_value(str(self.numposts))
        button4.connect("value-changed", self.change_numpost)
        self.select_default_value(button4, data, selector)

        button5 = hildon.PickerButton(fhsize, horbtn)
        button5.set_title("Comments to get")
        data = ["5", "10", "15", "20", "25", "40", "50", "75", "100", "150"]
        selector = self.create_selector(data)
        button5.set_selector(selector)
        button5.set_value(self.numcomm)
        button5.connect("value-changed", self.change_numcomm)
        self.select_default_value(button5, data, selector)

        hbox = gtk.HBox()
        hbox.pack_start(button4, True, True, 0)
        hbox.pack_start(button5, True, True, 0)

        hbox2 = gtk.HBox()
        hbox2.pack_start(cbutton, True, True, 0)
        hbox2.pack_start(button2, True, True, 0)

        cbutton2 = hildon.CheckButton(fhsize)
        cbutton2.set_label("Confirm post sending")

        if self.confirm_on:
            cbutton2.set_active(True)
        else:
            cbutton2.set_active(False)

        cbutton2.connect('toggled', self.change_confirm)

        cbutton3 = hildon.CheckButton(fhsize)
        cbutton3.set_label("Choose account sending")

        if self.choose_on:
            cbutton3.set_active(True)
        else:
            cbutton3.set_active(False)

        cbutton3.connect('toggled', self.change_chooseon)

        hbox3 = gtk.HBox()
        hbox3.pack_start(cbutton2, True, True, 0)
        hbox3.pack_start(cbutton3, True, True, 0)

        vbox1.pack_start(hbox3, False, False, 0)
        vbox1.pack_start(button1, False, False, 0)
        vbox1.pack_start(hbox2, False, False, 0)
        vbox1.pack_start(button3, False, False, 0)
        vbox1.pack_start(hbox, False, False, 0)

        win.add(vbox1)
        win.show_all()

    def change_chooseon(self, button):
        if button.get_active():
            self.choose_on = 1
        else:
            self.choose_on = 0

    def change_confirm(self, button):
        if button.get_active():
            self.confirm_on = 1
        else:
            self.confirm_on = 0

    def change_fontsize(self, button):
        self.fontsize = button.get_value()

    def change_numpost(self, button):
        self.numposts = int(button.get_value())

    def change_numcomm(self, button):
        self.numcomm = button.get_value()

    def change_as_time(self, button):
        self.autosave_time = int(button.get_value())
        self.stop_autosave_timer()
        self.autosave_timer = \
                        gobject.timeout_add(int(self.autosave_time*60000), \
                        self.check_autosave)

    def on_autosave_cb_toggled(self, widget, button1, button2):
        if widget.get_active():

            confirmation = utils.show_confirmation(self.window, ("If you active this "
                            "feature is possible that your battery is going to "
                            "last less if you let the application open during a"
                            " certain time.\nDo you want activate it anyway?"))
            if not confirmation:
                widget.set_active(False)
            else:
                button1.set_sensitive(True)
                button2.set_sensitive(True)
                self.autosave_on = 1
                self.stop_autosave_timer()
                self.autosave_timer = \
                            gobject.timeout_add(int(self.autosave_time*60000), \
                            self.check_autosave)
        else:
            button1.set_sensitive(False)
            button2.set_sensitive(False)
            self.autosave_on = 0
            self.stop_autosave_timer()

    def stop_autosave_timer(self):
        if self.autosave_timer > 0:
            gobject.source_remove(self.autosave_timer)
        self.autosave_timer = 0

    def check_autosave(self):
        logger.debug("autosave on?: %s" % self.autosave_on)

        if self.entitle:
            self.title = self.entitle.get_text()

        if self.title == '':
            import time
            date = time.localtime()
            date = '%s-%s-%s-' % (date[2], date[1], date[0])
            title = date + 'autosaved_post'
        else:
            title = self.title

        if self.autosave_on == 1:
            try:
                filename = self.autosave_path + '/%s.wpx' % title
                self.on_save_post(None, filename, 'autosave')
                logger.debug("Saving post: %s" % filename)
                self.autosave_timer = \
                        gobject.timeout_add(int(self.autosave_time*60000), \
                        self.check_autosave)
            except:
                logger.exception("Autosaving post")
        else:
            self.stop_autosave_timer()

    def on_select_autosave_path(self, button):
        dirname = utils.file_browser(self.window,
                        gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
                        'Select autosave path', HOME + '/MyDocs/.documents',
                        '', '', False, False)
        if dirname:
            self.autosave_path = dirname
            name = self.autosave_path.replace(HOME, '')[1:]
            if len(name) > 40:
                name = name[:37] + '...'
            button.set_value(name)

    def on_key_press(self, widget, event, *args):
        if event.keyval == hildon.KEY_INCREASE:
            if int(self.fontsize) >= 28:
                utils.show_info_banner(widget, 'Maximum font size reached')
                return
            else:
                self.fontsize = str(int(self.fontsize) + 2)
                utils.show_info_banner(widget, "Fontsize: %s" % self.fontsize)
                if self.txtPost:
                    self.txtPost.modify_font(pango.FontDescription("Normal " \
                                            + self.fontsize))
                if self.txtPostExt:
                    self.txtPostExt.modify_font(pango.FontDescription("Normal"\
                                            + " " + self.fontsize))
        elif event.keyval == hildon.KEY_DECREASE:
            if int(self.fontsize) <= 14:
                utils.show_info_banner(widget, 'Minimal font size reached')
                return
            else:
                self.fontsize = str(int(self.fontsize) - 2)
                utils.show_info_banner(widget, "Fontsize: %s" % self.fontsize)
                if self.txtPost:
                    self.txtPost.modify_font(pango.FontDescription("Normal " \
                                                + self.fontsize))
                if self.txtPostExt:
                    self.txtPostExt.modify_font(pango.FontDescription("Normal"\
                                                + " " + self.fontsize))

    def set_default_settings(self):
        default_account, def_settings = \
            settings.get_default_settings(accounts_db, settings_db)

        try:
            self.accountname = default_account[0][0]
            self.blogsystem = default_account[0][1]
            self.user = default_account[0][2]
            self.password = default_account[0][3]
            self.blogid = default_account[0][4]
            self.blogname = default_account[0][5]
            self.url = default_account[0][6]
        except:
            if not default_account:
                logger.info("No accounts")
            else:
                logger.exception("Loading accounts")
            self.accountname = ''
            self.blogsystem = ''
            self.user = ''
            self.password = ''
            self.blogid = ''
            self.blogname = ''
            self.url = ''

        try:
            self.fontsize = str(def_settings[0][1])
            self.numposts = int(def_settings[0][2])
            self.perpage = int(def_settings[0][3])
            self.picasa_login = def_settings[0][4]
            self.picasa_pass = def_settings[0][5]
            self.picasa_albumlist = []
            self.defalbum = def_settings[0][13]
            for i in def_settings[0][6].split('|||'):
                self.picasa_albumlist.append(i)
            self.autosave_on = int(def_settings[0][7])
            self.autosave_time = int(def_settings[0][8])
            self.autosave_path = def_settings[0][9]
            if self.autosave_path == '':
                self.autosave_path = HOME + '/MyDocs/.documents'
            self.path_post = def_settings[0][10]
            self.path_post_img = def_settings[0][11]
            self.path_add_img = def_settings[0][12]
            self.numcomm = def_settings[0][14]
            self.confirm_on = int(def_settings[0][15])
            self.choose_on = int(def_settings[0][16])
        except:
            if not def_settings:
                logger.info("No settings")
            else:
                logger.exception("Loading settings")
            self.numcomm = '15'
            self.fontsize = '18'
            self.numposts = 25
            self.perpage = 10
            self.picasa_login = ''
            self.picasa_pass = ''
            self.defalbum = ''
            self.picasa_albumlist = []
            self.autosave_on = 0
            self.autosave_time = 5
            self.autosave_path = HOME + '/MyDocs/.documents'
            self.path_post = HOME + '/MyDocs/.documents'
            self.path_post_img = HOME + '/MyDocs/.images'
            self.path_add_img = HOME + '/MyDocs/.images'
            self.confirm_on = 0
            self.choose_on = 0

    def show_is_edited_post(self, widget):
        utils.show_info_banner(widget, "This is an edited post")

    def insert_htmltags(self, widget, tag, back, screen):
        from wordpy import htmltags
        if screen == "main":
            textview = self.txtPost
        elif screen == "advanced":
            textview = self.txtPostExt
        try:
            if textview == None:
                utils.show_info_banner(widget, \
                                    "Select the main or extended entry")
                return
            htmltags.insert_htmltag(textview, tag)
            if back:
                stack = self.window.get_stack()
                stack.pop_1()
        except:
            logger.exception('Inserting html tags in a post')

    def on_show_log(self, widget):
        utils.show_log_dialog(logfile)

    def progress_posting_timeout(self):
        self.posting_pgbar.pulse()
        return True

    def show_account_selector(self):
        dialog = gtk.Dialog(title='Choose account', parent=None, flags=0)
        dialog.set_size_request(-1, 360)
        dialog.set_has_separator(False)

        parea = hildon.PannableArea()
        acctv = hildon.GtkTreeView(ui_edit)
        accmodel = self.create_accounts_list()
        acctv.set_model(accmodel)
        self.add_accounts_tv_columns(acctv)
        parea.add(acctv)

        selection = acctv.get_selection()

        for i in range(len(accmodel)):
            if self.accountname == accmodel[i][1]:
                seliter = accmodel.get_iter(i)
                selection.select_iter(seliter)

        button1 = hildon.Button(fhsize, horbtn)
        button1.set_title('Send post')
        button1.connect("clicked", self.choose_account, dialog, acctv, accmodel)

        dialog.vbox.pack_start(parea, True, True, 0)
        dialog.vbox.pack_start(button1, False, False, 0)

        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_DELETE_EVENT:
            self.accountdata = None
            dialog.destroy()

    def choose_account(self, widget, dialog, acctv, accmodel):
        accname, seliter, selmodel = \
                    utils.get_selected_from_treeview(acctv, accmodel, 1)
        blogsystem, seliter, selmodel = \
                    utils.get_selected_from_treeview(acctv, accmodel, 2)
        account = settings.get_account_settings(accounts_db, blogsystem, \
                                                accname)

        dialog.destroy()
        ##account = (id, accountname, user, password, blogid,
        ##blogname, blogurl, enabled)
        self.accountdata = [account[6], account[2], account[4], account[3], blogsystem]


    def publish_post(self, widget):
        if self.blogsystem == "":
            utils.show_info_banner(widget, 'You need create an account')
            return

        self.get_post_data()

        if self.title == '':
            utils.show_info_banner(widget, 'You need write a title')
            return

        if self.posttext == "":
            utils.show_info_banner(widget, 'You need write post text')
            return

        if self.confirm_on:
            confirmation = utils.show_confirmation(self.window, "Send post?")
        else:
            confirmation = True

        if confirmation:
            if self.choose_on and not self.is_edited:
                self.show_account_selector()
                if not self.accountdata:
                    logger.debug("No sending the post")
                    return
                else:
                    url = self.accountdata[0]
                    user = self.accountdata[1]
                    blogid = self.accountdata[2]
                    password = self.accountdata[3]
                    blogsystem = self.accountdata[4]
            else:
                url = self.url
                user = self.user
                blogid = self.blogid
                password = self.password
                blogsystem = self.blogsystem

            self.publishing_screen()
            self.posting_title.set_markup('<b>Publishing post...</b>')
            self.posting_info.set_label("Uploading content")
            self.posting_pgbar.show()
            self.timer_posting = gobject.timeout_add (100, self.progress_posting_timeout)

            thread.start_new(self._do_upload_post, (url, user, password, blogid, blogsystem))
        else:
            return

    def _do_upload_post(self, url, user, password, blogid, blogsystem):
        from wordpy import posting

        try:
            if self.is_edited:
                edited = True
                date = self.date
                postid = self.postid
            else:
                edited = False
                date = None
                postid = 0

            #Initializing cats if no one was chosen, but were got from server
            #I know it's weird, but today it's friday and I need go out.
            if self.cats == [['0', 'a']]:
                self.cats = []

            if blogsystem == 'Wordpress':
                post = posting.to_wordpress(url, user, password, self.title,
                                self.postpassw, self.tags, self.pings,
                                self.comments, self.posttext,
                                self.extendedtext, self.status, self.slug,
                                self.cats, self.tbacks, self.ttags, edited,
                                postid, self.rtags, self.posting_info,
                                self.sch_time, self.sch_date, self.schedule_on)
            elif blogsystem == 'Blogger':
                post = posting.to_blogger(user, password, blogid, self.title,
                                self.posttext, self.ttags, self.tags,
                                self.status, edited, postid, self.rtags,
                                self.posting_info,  self.sch_time,
                                self.sch_date, self.schedule_on)
            elif blogsystem == 'Livejournal':
                post = posting.to_livejournal(user, password, self.posttext,
                                self.title, self.tags, date, edited, postid,
                                self.rtags, self.comments, self.sch_time,
                                self.sch_date, self.ttags, self.schedule_on,
                                self.status)
            elif blogsystem == 'Drupal':
                post = posting.to_drupal(url, user, password, self.title,
                                self.postpassw, self.tags, self.pings,
                                self.comments, self.posttext,
                                self.extendedtext, self.status, self.slug,
                                self.cats, self.tbacks, self.ttags, edited,
                                postid, self.rtags, self.posting_info,
                                self.sch_time, self.sch_date, self.schedule_on)


            if post == None:
                self.destroy_progress_posting()
                self.on_posting_complete('Error publishing')
                logger.error("Publishing a post: Authentication failed")

            else:
                logger.debug("Post published: %s" % post)
                self.is_edited = False
                self.post_edited_btn.hide()
                recentposts = RecentPosts()
                recentposts.put(self.title, self.accountname)
                recenttags = RecentTags()
                recenttags.put(self.tags)
                self.destroy_progress_posting()
                self.on_posting_complete('Publish succesful')

        except:
            logger.exception("Publishing a post")
            self.destroy_progress_posting()
            self.on_posting_complete('Error publishing')

    def destroy_progress_posting(self):
        if self.timer_posting > 0:
            gobject.source_remove(self.timer_posting)
        self.timer_posting = 0

    def on_posting_complete(self, upinfo):
        self.posting_title.set_markup('<b>'+upinfo+'</b>')
        self.posting_info.set_text('')
        self.posting_pgbar.hide()
        if upinfo == 'Error publishing':
            self.posting_save_btn.show()
            self.posting_try_btn.show()
        else:
            stack = self.window.get_stack()
            numtopop = len(stack.get_windows())
            stack.pop(numtopop-1)
            self.recentposts.set_text('What else do you want to do?')
            self.recentposts_title.set_markup('<b>Publish successful</b>')
            self.on_new_post(None, 'publish')

    def publishing_screen(self):
        win = hildon.StackableWindow()
        win.set_title("Publishing Post")

        vbox1 = gtk.VBox()

        self.posting_title = gtk.Label()
        self.posting_info = gtk.Label()
        self.posting_pgbar = gtk.ProgressBar()
        self.posting_pgbar.set_pulse_step(0.05)

        hbox1 = gtk.HBox()

        self.posting_save_btn = hildon.Button(fhsize, horbtn)
        self.posting_save_btn.set_title("Save post")
        self.posting_save_btn.connect("clicked", self.on_saveas_post)
        self.posting_try_btn = hildon.Button(fhsize, horbtn)
        self.posting_try_btn.connect("clicked", self.publish_post)
        self.posting_try_btn.set_title("Try again")

        hbox1.pack_start(self.posting_save_btn, True, True, 0)
        hbox1.pack_start(self.posting_try_btn, True, True, 0)

        vbox1.pack_start(self.posting_title, True, True, 5)
        vbox1.pack_start(self.posting_info, True, True, 5)
        vbox1.pack_start(self.posting_pgbar, False, False, 5)
        vbox1.pack_start(hbox1, False, False, 5)

        win.add(vbox1)

        win.show_all()
        self.posting_save_btn.hide()
        self.posting_try_btn.hide()

    def get_post_data(self):
        if self.entitle:
            self.title = self.entitle.get_text()

        if self.txtPost:
            start, end = self.postBuffer.get_bounds()
            self.posttext = self.postBuffer.get_text(start, end)

        if self.txtPostExt:
            start, end = self.extendedBuffer.get_bounds()
            self.extendedtext = self.extendedBuffer.get_text(start, end)

        if self.enpostpassw:
            self.postpassw = self.enpostpassw.get_text()
            self.ttags = self.enttags.get_text()
            self.slug = self.enslug.get_text()

        if self.entags:
            self.tags = self.entags.get_text()

        #self.tbacks = ''

    def initialize_post_data(self):
        import time
        self.title = ''
        self.postpassw = ''
        self.tags = ''
        self.pings = True
        self.comments = True
        self.posttext = ''
        self.extendedtext = ''
        self.status = 'publish'
        self.slug = ''
        self.cats = []
        self.tbacks = ''
        self.ttags = ''
        self.is_edited = False
        self.rtags = ''
        date = time.localtime()
        self.sch_time = (date[3], date[4])
        self.sch_date = (date[0], date[1]-1, date[2])
        self.schedule_on = False

    def on_new_post(self, widget, option):
        #showing confirmation dialog
        if option == 'menu':
            confirmation = utils.show_confirmation(self.window, \
                            "Delete current entry?")
        else:
            confirmation = True

        if confirmation == True:
            ## Clear all text, title, tags, etc.
            self.initialize_post_data()
            self.is_edited = False
            if self.entitle:
                self.entitle.set_text("")
                self.post_edited_btn.hide()
            if self.txtPost:
                self.postBuffer.set_text("")
            if self.txtPostExt:
                self.extendedBuffer.set_text("")
            if self.enpostpassw:
                self.enpostpassw.set_text("")
                self.enttags.set_text("")
                self.enslug.set_text("")
            if self.entags:
                self.entags.set_text("")

            self.set_publish_image()
        else:
            return

    def on_save_post(self, widget, filename, option):
        try:
            if option == 'autosave':
                self.xml_file = filename
            else:
                if (self.xml_file == None) or (self.xml_file == False):
                    self.xml_file = utils.file_browser(self.window, \
                                gtk.FILE_CHOOSER_ACTION_SAVE, "Save Post", \
                                self.path_post, "", "wpx", False, False)

            if (self.xml_file):
                from wordpy import io
                self.path_post = os.path.dirname(self.xml_file)
                post = self.get_post_options()
                io.xml_save_to_file(self.xml_file, widget, utils, post)
                if option != 'autosave':
                    utils.show_info_banner(widget, 'Post saved')
        except:
            utils.show_info_banner(widget, 'Error saving the post')
            logger.exception("Saving the post")

    def on_saveas_post(self, widget):
        try:
            xml_file = "Untitled"
            if (self.xml_file != None) and (self.xml_file != False):
                xml_file = os.path.basename(self.xml_file)

            xml_file = utils.file_browser(self.window, \
                                gtk.FILE_CHOOSER_ACTION_SAVE,  "Save Post", \
                                self.path_post, xml_file, "wpx", False, False)
            if (xml_file):
                from wordpy import io
                post = self.get_post_options()
                if (io.xml_save_to_file(xml_file, widget, utils, post)):
                    self.xml_file = xml_file
                    self.path_post = os.path.dirname(self.xml_file)
                    utils.show_info_banner(widget, 'Post saved')
        except:
            utils.show_info_banner(widget, 'Error saving as.. the post')
            logger.exception("Saving as... the post")

    def get_post_options(self):
        self.get_post_data()

        title = self.title
        text = self.posttext
        excerpt = ''
        extended = self.extendedtext
        ttags = self.ttags
        tbacks = ''
        tags = self.tags
        password = self.postpassw
        slug = self.slug
        status = self.status
        year, month, day = self.sch_date[0], self.sch_date[1]+1, self.sch_date[2]
        hour, minutes = self.sch_time[0], self.sch_time[1]
        date_time = '%s||%s||%s||%s||%s' % (year, month, day, hour, minutes)

        scheduleon = str(self.schedule_on)
        comments = str(self.comments)
        pings = str(self.pings)
        rtags = self.rtags
        cats = str(self.cats)

        post = (title, text, excerpt, extended, ttags, tbacks, tags,
                password, slug, status, date_time, scheduleon, comments,
                pings, rtags, cats)

        return post

    def on_open_post(self, widget):
        try:
            self.xml_file = utils.file_browser(self.window, \
                            gtk.FILE_CHOOSER_ACTION_OPEN, "Open Post", \
                            self.path_post, "", "", False, False)

            if (self.xml_file == False) or (self.xml_file== None):
                return
            else:
                from wordpy import io
                self.path_post = os.path.dirname(self.xml_file)
                post_loaded = io.xml_load_from_file(self.xml_file, \
                                                    widget, utils)
                self.set_post_loaded(post_loaded)
                utils.show_info_banner(widget, 'Post opened')
        except:
            utils.show_info_banner(widget, "Error opening the post")
            logger.exception("Opening a post")

    def set_post_loaded(self, post_loaded):
        #post_loaded =
        # (title, post, excerpt, extended, technorati, trackbacks, tags, \
        # password, slug, status, date)
        self.is_edited = False

        self.title = post_loaded[0]
        self.posttext = post_loaded[1]
        #self.excerpt.set_text(post_loaded[2])
        self.extendedtext = post_loaded[3]
        self.ttags = post_loaded[4]
        #self.tbacks = post_loaded[5]
        self.tags = post_loaded[6]
        self.postpassw = post_loaded[7]
        self.slug = post_loaded[8]
        self.status = post_loaded[9]

        if self.status == "draft":
            self.set_draft_image()
        else:
            self.set_publish_image()

        if self.entitle:
            self.entitle.set_text(self.title)
            self.post_edited_btn.hide()
        if self.txtPost:
            self.postBuffer.set_text(self.posttext)
        if self.txtPostExt:
            self.extendedBuffer.set_text(self.extendedtext)
        if self.enpostpassw:
            self.enpostpassw.set_text(self.postpassw)
            self.enttags.set_text(self.ttags)
            self.enslug.set_text(self.slug)
        if self.entags:
            self.entags.set_text(self.tags)


        if '/' in post_loaded[10]:
            #compatibility with version 1.0 -> date = 10/8/2009||17||58
            date, hour, minutes = post_loaded[10].split('||')
            day, month, year = date.split('/')
            self.sch_date = (int(year), int(month)-1, int(day))
            self.sch_time = (int(hour), int(minutes))
        elif '||' in post_loaded[10]:
            year, month, day, hour, minutes = post_loaded[10].split('||')
            self.sch_date = (int(year), int(month)-1, int(day))
            self.sch_time = (int(hour), int(minutes))
        else:
            import time
            date = time.localtime()
            self.sch_time = (date[3], date[4])
            self.sch_date = (date[0], date[1]-1, date[2])

        try:
            self.schedule_on = (post_loaded[11][0].upper()== "T")
        except:
            self.schedule_on = False
        try:
            self.comments = (post_loaded[12][0].upper()== "T")
        except:
            self.comments = True
        try:
            self.pings = (post_loaded[13][0].upper()== "T")
        except:
            self.pings = True
        try:
            self.rtags = post_loaded[14]
        except:
            self.rtags = ''
        try:
            self.cats = eval(post_loaded[15])
        except:
            self.cats = []

    def quit_and_save(self, widget):
        self.delete_temp_files()
        fontsize = self.fontsize
        numpost = self.numposts
        perpage = self.perpage
        picasa_login = self.picasa_login
        picasa_pass = self.picasa_pass
        defalbum = self.defalbum

        albums = self.picasa_albumlist

        picasa_albums = ''
        for i in range(len(albums)):
            if i < len(albums)-1:
                picasa_albums = picasa_albums + albums[i] + '|||'
            else:
                picasa_albums = picasa_albums + albums[i]

        autosave = self.autosave_on
        as_time = self.autosave_time
        as_path = self.autosave_path

        path_post  = self.path_post
        path_post_img = self.path_post_img
        path_add_img = self.path_add_img
        numcomm = self.numcomm
        confirmon = self.confirm_on
        chooseon = self.choose_on
        try:
            settings.save_settings(settings_db, fontsize, numpost, perpage,
                        picasa_login, picasa_pass, picasa_albums, autosave,
                        as_time, as_path, path_post, path_post_img,
                        path_add_img, defalbum, numcomm, confirmon, chooseon)
        except:
            logger.exception("Saving the general settings")

        gtk.main_quit()

    def delete_temp_files(self):
        ## Delete temporal files ##
        try:
            for i in os.listdir("/var/tmp"):
                if i.find("wordpy") >= 0:
                    import shutil
                    logger.debug("Deleting temp directory: %s", i)
                    shutil.rmtree("/var/tmp/" + i)
        except:
            logger.exception("Deleting temp files")

    def show_banner_thread(self, win, msg):
        gtk.gdk.threads_enter()
        utils.show_info_banner(win, msg)
        gtk.gdk.threads_leave()

class About:

    def __init__(self, widget):
        self.abdialog = gtk.Dialog(title='About', parent=None, flags=0)
        self.abdialog.set_has_separator(False)
        self.abdialog.set_size_request(-1, 400)

        self.info_lb = gtk.Label()
        self.info_lb.set_line_wrap(True)

        self.id = False

        hbox1 = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Description')
        button.connect("clicked", self.show_info, 'description')
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Credits')
        button.connect("clicked", self.show_info, 'credits')
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('License')
        button.connect("clicked", self.show_info, 'license')
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Donate')
        button.connect("clicked", self.show_info, 'donate')
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Report ')
        button.connect("clicked", self.show_info, 'report')
        hbox1.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title(' Rate ')
        button.connect("clicked", self.show_info, 'vote')
        hbox1.pack_start(button, True, True, 0)

        self.action_btn = hildon.Button(fhsize, horbtn)
        self.image = gtk.Image()

        self.show_info(None, 'description')

        self.abdialog.vbox.pack_start(self.action_btn, False, False, 0)
        self.abdialog.vbox.pack_start(self.image, False, False, 5)
        self.abdialog.vbox.pack_start(self.info_lb, True, True, 0)
        self.abdialog.vbox.pack_start(hbox1, False, False, 0)

        self.abdialog.show_all()
        self.action_btn.hide()
        self.image.hide()
        self.abdialog.run()
        self.abdialog.destroy()

    def do_action(self, widget, action):
        import dbus
        bus = dbus.SystemBus()
        proxy = bus.get_object("com.nokia.osso_browser", "/com/nokia/osso_browser/request")
        iface = dbus.Interface(proxy, 'com.nokia.osso_browser')

        if action == "donate":
            url = "http://maemo-wordpy.garage.maemo.org/donate.html"
        elif action == "report":
            url = "http://maemo-wordpy.garage.maemo.org/reporting.html"
        elif action == "vote":
            url = "http://maemo.org/downloads/product/mastory"

        self.abdialog.destroy()

        iface.open_new_window(url)

    def show_info(self, widget, kind):
        if kind == 'license':
            self.action_btn.hide()
            self.image.hide()
            info = """<small><b>MaStory</b> is free software. It's using a GPL version 2 license or at your election any later version.

Some icons used in MaStory are from the Allblack iconset by Mandarancio (mandarancio.deviantart.com), others were created by the MaStory's author. All are using the Creative Commons license: Attribution-Noncommercial-Share Alike 3.0

MaStory's logo is created by MaStory's author. GPL license.</small>"""
        elif kind == 'credits':
            self.action_btn.hide()
            self.image.hide()
            info = """<small><b>Written by</b> Daniel Martin Yerga (dyerga@gmail.com)
<b>UI design by</b> Antoine RJ Wright
Icons from the initial screen are kindly done by Joshua Maverick.

<b>Thanks</b> to everyone who has reported bugs, suggestions, giving spirits, critiques, writing blog articles about MaStory, and so on. THANKS TO ALL!

MaStory is your software, made for you.</small>"""
        elif kind == 'description':
            self.action_btn.hide()
            self.image.hide()
            info = """<b><big>MaStory 2.0</big></b>

<i>MaStory is a blogging client for Maemo</i>

<b>Web Page</b>:
maemo-wordpy.garage.maemo.org"""

        elif kind == 'donate':
            self.action_btn.show()
            self.image.hide()
            self.action_btn.set_title('Make donation')
            if self.id:
                self.action_btn.disconnect(self.id)
            self.id = self.action_btn.connect("clicked", self.do_action, "donate")
            info = """<small><b>MaStory</b> is a free (and gratis) software application.
Developing good software takes time and hard work.
<b>MaStory's author</b> develops the program in his spare time.
If you like the program and it's helpful, consider donating a small amount of money.
Donations are a great incentive and help the developer feel that the hard work is appreciated.</small>
"""
        elif kind == 'report':
            self.action_btn.show()
            self.image.hide()
            self.action_btn.set_title('Report bug')
            if self.id:
                self.action_btn.disconnect(self.id)
            self.id = self.action_btn.connect("clicked", self.do_action, "report")
            info = """<small>MaStory is being improved thanks to bug reports that users have submitted. The author appreciates these reports.
If the application is raising an error when you're using it, you have two choices to report this error:
1) Send the log from the application menu (if there's an error in the log).
2) Press the button and write a bug report with as much information as possible.</small>"""
        elif kind == 'vote':
            self.action_btn.show()
            self.image.show()
            self.image.set_from_file(imgdir + "maemoorg.png")
            self.action_btn.set_title('Rate MaStory')
            if self.id:
                self.action_btn.disconnect(self.id)
            self.id = self.action_btn.connect("clicked", self.do_action, "vote")
            info = """<small>The downloads section in maemo.org has a nice system where you can rate applications.
If you consider MaStory a good application (or a bad one too), you could rate it in maemo.org site.</small>"""

        self.info_lb.set_markup(info)

class RecentPosts:

    def get(self):
        if os.path.exists(configdir + 'recentposts'):
            f = open(configdir + 'recentposts', 'r')
        else:
            f = open(configdir + 'recentposts', 'w')
            f.close()
            f = open(configdir + 'recentposts', 'r')
        recentposts = f.read()

        if len(recentposts) == 0:
            recentposts = '(No recent posts)'
        f.close()

        return recentposts

    def put(self, title, blog):
        new = '<small>%s <b>(%s)</b></small>\n' % (title, blog)
        if os.path.exists(configdir + 'recentposts'):
            f = open(configdir + 'recentposts', 'r')
        else:
            f = open(configdir + 'recentposts', 'w')
            f.close()
            f = open(configdir + 'recentposts', 'r')

        lines = f.readlines()
        f.close()

        if len(lines) == 3:
            lines[2] = lines[1]
            lines[1] = lines[0]
            lines[0] = new
        else:
            lines.insert(0, new)

        lines[len(lines)-1] = lines[len(lines)-1].replace('\n', '')

        f = open(configdir + 'recentposts', 'w')
        f.writelines(lines)
        f.close()


class RecentTags:

    def get(self):
        if os.path.exists(configdir + 'recenttags'):
            f = open(configdir + 'recenttags', 'r')
        else:
            f = open(configdir + 'recenttags', 'w')
            f.close()
            f = open(configdir + 'recenttags', 'r')

        recenttags = f.readlines()
        if len(recenttags) == 0:
            recenttags = []
        f.close()

        for i in range(len(recenttags)):
            recenttags[i] = recenttags[i].replace('\n', '')

        return recenttags

    def put(self, tag_txt):
        if os.path.exists(configdir + 'recenttags'):
            f = open(configdir + 'recenttags', 'r')
        else:
            f = open(configdir + 'recenttags', 'w')
            f.close()
            f = open(configdir + 'recenttags', 'r')

        recenttags = f.readlines()
        f.close()

        tags = []
        for i in tag_txt.split(", "):
            for j in i.split(" ,"):
                for k in j.split(","):
                    for l in k.split("; "):
                        for m in l.split(" ;"):
                            for n in m.split(";"):
                                if (n != " " and n != ""):
                                    tags.append(n)

        for tag in tags:
            if tag+'\n' not in recenttags:
                if len(recenttags) == 20:
                    for i in range(len(recenttags)):
                        recenttags[len(recenttags)-1-i] = \
                                        recenttags[len(recenttags)-2-i]
                        recenttags[0] = tag + '\n'
                else:
                    recenttags.insert(0, tag+'\n')

        f = open(configdir + 'recenttags', 'w')
        f.writelines(recenttags)
        f.close()


if __name__ == "__main__":
    WordpyUI = WordpyUI()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
