# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gdata.photos.service

class Picasa:

    def __init__(self, username, password):

        self.username = username
        self.password = password

        self.service = gdata.photos.service.PhotosService()
        self.service.ClientLogin(self.username, self.password)

    def getAlbums(self):
        albums = self.service.GetUserFeed().entry

        album_titles = []
        for album in albums:
            album_titles.append(album.title.text)

        return albums, album_titles

    def getPhotosInAlbum(self, album_title):
        albums, title_albums = self.getAlbums()

        if album_title == '':
            print 'Album not passed'
            return None

        for i in range(len(title_albums)):
            if album_title == title_albums[i]:
                album_index = i

        if album_index == '':
            print 'Album not found'
            return None

        photos = self.service.GetFeed(albums[album_index].GetPhotosUri()).entry

        #TODO: get thumbnails url and sizes
        #for i in range(len(photos[1].media.thumbnail)):
         #   print photos[1].media.thumbnail[i].url
        #    print photos[1].media.thumbnail[i].width
         #   print photos[1].media.thumbnail[i].height

        photolist = []
        for photo in photos:
            one_photo = [photo.title.text, photo.content.src, \
                                photo.width.text, photo.height.text]
            photolist.append(one_photo)

        return photolist

    def uploadPhotos(self, photos, filename_lb):
        import os
        albums = self.service.GetUserFeed().entry

        for i in range(len(photos)):
            filename_lb.set_text(os.path.basename(photos[i][0]))
            for album in albums:
                if album.title.text == photos[i][8]:
                    self.service.InsertPhotoSimple(album, photos[i][1], \
                                photos[i][2], photos[i][0], keywords=photos[i][3])
                    break
