# Some of this code is from Zapys Livejournal client
# Copyright (C) Zapys authors
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import xmlrpclib, time, md5

LJ_TIME_FORMAT = r"%Y-%m-%d %H:%M:%S"

def create_livejournal_client(user, password):
    ljclient = rpcServer(user, password)
    return ljclient

def post_list_formatted(user, password, numposts):
    posts = []
    ljclient = create_livejournal_client(user, password)
    postlist = ljclient.get_post_list(numposts)

    for i in range(len(postlist)):
        try:
            if not postlist[i].has_key('subject'):
                postlist[i]['subject'] = ''
            posts.append([postlist[i]['subject'], postlist[i]['itemid'], \
                        postlist[i]['security']])
        except KeyError:
            if not postlist[i].has_key('subject'):
                postlist[i]['subject'] = ''
            posts.append([postlist[i]['subject'], postlist[i]['itemid'], 'public'])
    return posts

def get_post_filtered(user, password, postid):
    ljclient = create_livejournal_client(user, password)

    post = ljclient.get_post(postid)
    try:
        title = post['subject']
    except:
        title = ''
    try:
        content = post['event']
    except:
        content = ''
    content = content.replace('<br />', '\n')
    ttags = ''
    tracks = ''
    if content.find("Technorati Tags:") >= 0:
        import re
        techno_tags = []
        hele = re.compile(r'"http://technorati.com/tag/[^$%]+"')
        a = hele.findall(content)
        b = a[0].split('"')
        for j in range(len(b)):
            if b[j].find("http://technorati.com/tag/") >=0:
                c = b[j].replace('http://technorati.com/tag/', '')
                techno_tags.append(c)

        ttags = (', ').join(techno_tags)

        if content.find("<small>Technorati Tags:") >= 0:
            descr = content.partition('<br /><br /><p style="text-align: right"><small>Technorati Tags:')
        else:
            descr = content.partition('<br /><br /><p style="text-align:right;">Technorati Tags:')

        content = descr[0]

    extended = ''
    excerpt = ''
    if post['props'].has_key('taglist'):
        tags = post['props']['taglist']
    else:
        tags = ''

    if post['props'].has_key('opt_nocomments'):
        comments = 0
    else:
        comments = 1

    cats = ''
    date = post['eventtime']

    splitted = date.split(' ')

    date = splitted[0].split('-')
    time = splitted[1].split(':')

    date = [date[0], date[1], date[2], time[0], time[1]]

    #post[8] = [2009, 6, 30, 17, 57]
    #LJ date: 2009-07-10 20:37:00

    slug = ''
    pssword = ''
    pings = False
    if post.has_key('security'):
        status = post['security']
    else:
        status = 'public'


    return (title, content, extended, excerpt, ttags, tracks, tags, cats, date, \
            slug, pssword, comments, pings, status, postid)


class rpcServer:
    username = ''
    password = ''
    initialized = False

    def __init__(self, user, password):
        self.username = user
        self.hpassword = md5.md5(password).hexdigest()

    def connect(self):
        if not self.initialized:
            self.server = xmlrpclib.Server("http://www.livejournal.com/interface/xmlrpc:80")
            self.initialized = True

    def get_last(self):

        self.connect()
        result = self.server.LJ.XMLRPC.getevents({
            'username': self.username,
            'hpassword': self.hpassword,
            'ver': '1',
            'lineendings': '0x0A',
            "selecttype": "lastn",
            "itemid": -1,
            "howmany": 1
            })

        return result['events'][0]


    def get_post(self, postid):
        self.connect()
        result = self.server.LJ.XMLRPC.getevents({
            'username': self.username,
            'hpassword': self.hpassword,
            'ver': '1',
            'lineendings': '0x0A',
            "selecttype": "one",
            "itemid": postid,
            "howmany": 1
            })

        return result['events'][0]


    def get_post_list(self, numposts):
        self.connect()
        result = self.server.LJ.XMLRPC.getevents({
            'username': self.username,
            'hpassword': self.hpassword,
            'ver': '1',
            'lineendings': '0x0A',
            "selecttype": "lastn",
            "itemid": -1,
            "howmany": numposts
            })

        return result['events']

    def del_event(self, itemid):
        self.connect()
        result = self.server.LJ.XMLRPC.editevent({
            'username': self.username,
            'hpassword': self.hpassword,
            'ver': '1',
            "itemid": itemid,
            })
        return result

    # post is disct {subj, taglist, text}
    def post(self, post, eventtime = None):
        self.connect()
        if eventtime == None:
            moment = time.localtime()
        else:
            moment = time.strptime(eventtime, LJ_TIME_FORMAT)

        return self.server.LJ.XMLRPC.postevent({
            'username': self.username,
            'hpassword': self.hpassword,
            'clientversion': 'MaStory/2.0',
            'ver':'1',
            'event': post['event'],
            'subject': post['subject'],
            'props': {'taglist': post['taglist'], 'opt_preformatted': True, \
                    'opt_nocomments': post['opt_nocomments']},
            'security': post['security'],
            'allowmask': '1',
            'year': moment[0],
            'mon': moment[1],
            'day': moment[2],
            'hour' : moment[3],
            'min': moment[4],
            'lineendings':'0x0A'
            })

    # post is disct {subj, tags, text}
    def edit(self, itemid, eventtime, post):
        self.connect()
        moment = time.strptime(eventtime, LJ_TIME_FORMAT)
        return self.server.LJ.XMLRPC.editevent({
            'username': self.username,
            'hpassword': self.hpassword,
            'ver': '1',
            'itemid': itemid,
            'event': post['event'],
            'subject': post['subject'],
            'props': {'taglist': post['taglist'], 'opt_preformatted': True, \
                    'opt_nocomments': post['opt_nocomments']},
            'security': post['security'],
            'allowmask': '1',
            'year': moment[0],
            'mon': moment[1],
            'day': moment[2],
            'hour' : moment[3],
            'min': moment[4],
            })
