# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gtk, gc

def resize_image(pixbuf, width, height):
    pixbuf = pixbuf.scale_simple(int(width), int(height), gtk.gdk.INTERP_BILINEAR)
    return pixbuf

def rotate_image(pixbuf, angle):
    im = pixbuf2Image(pixbuf)
    rotated_im = im.rotate(float(angle))
    pixbuf = image2pixbuf(rotated_im)
    del im
    del rotated_im
    gc.collect()
    return pixbuf

def flip_image(pixbuf, mode):
    import Image
    im = pixbuf2Image(pixbuf)
    if mode == 'horizontal':
        flip = Image.FLIP_LEFT_RIGHT
    elif mode == 'vertical':
        flip = Image.FLIP_TOP_BOTTOM

    flipped_im = im.transpose(flip)
    pixbuf = image2pixbuf(flipped_im)
    del im
    del flipped_im
    gc.collect()
    return pixbuf

def do_colorize_or_brightness(pixbuf, value, option):
    im = pixbuf2Image(pixbuf)
    import ImageEnhance
    if option == 'colorize':
        enh = ImageEnhance.Color(im)
        new_im = enh.enhance(value)
    elif option == 'brightness':
        enh = ImageEnhance.Brightness(im)
        new_im = enh.enhance(value)

    pixbuf = image2pixbuf(new_im)
    del new_im
    del enh
    del im
    gc.collect()
    return pixbuf

def image2pixbuf(im):
    ## Convert PIL Image to gtk.Pixbuf
    import StringIO
    file1 = StringIO.StringIO()
    im.save(file1, "ppm")
    contents = file1.getvalue()
    file1.close()
    loader = gtk.gdk.PixbufLoader("pnm")
    loader.write(contents, len(contents))
    pixbuf = loader.get_pixbuf()
    loader.close()
    return pixbuf

def pixbuf2Image(pixbuf):
    ## Convert gtk.Pixbuf to PIL Image
    import Image
    assert(pixbuf.get_colorspace() == gtk.gdk.COLORSPACE_RGB)
    dimensions = pixbuf.get_width(), pixbuf.get_height()
    stride = pixbuf.get_rowstride()
    pixels = pixbuf.get_pixels()
    mode = pixbuf.get_has_alpha() and "RGBA" or "RGB"

    return Image.frombuffer(mode, dimensions, pixels, "raw", mode, stride, 1)

def set_pixbuf_to_gtkimage(pixbuf, mode, gtkimage):
    from wordpy import utils
    w, h = utils.set_thumbnail_size(pixbuf, mode)
    scale_pix = pixbuf.scale_simple(int(w), int(h), gtk.gdk.INTERP_BILINEAR)
    gtkimage.set_from_pixbuf(scale_pix)
    gtkimage.show()
    del scale_pix

def create_temp_image(pixbuf):
    # Save as /tmp/mastory-<random>/random1.jpg
    import random
    import string
    import tempfile
    try:
        random_name = ''.join([random.choice(string.letters) for x in xrange(8)])
        tmpdir = tempfile.mkdtemp(prefix='mastory') + "/"
        tmpfile = tmpdir + random_name + '.jpg'
        pixbuf.save(tmpfile, "jpeg")
        return tmpfile

    except:
        return None

def delete_temp_images():
    import os
    ## Delete temporal edited images ##
    for i in os.listdir("/var/tmp"):
        if i.find("mastory") >= 0:
            import shutil
            print "Deleting temp directory: %s" % i
            shutil.rmtree("/var/tmp/" + i)
