import xmlrpclib
import time
import os
import exceptions

def create_drupal_client(url, user, password):
    """Quick helper routine used to create the drupal
    client"""
    # prepare client object
    try:
        client = DrupalClient(url, user, password)
    except:
        return None

    # select blog id
    client.setContentType('story')

    return client

def get_posts_with_status(url, user, password, numposts):
    client = create_drupal_client(url, user, password)
    posts = []
    recentposts = client.getRecentPosts(numposts)

    for i in recentposts:
        title = i.title
        postid = i.id
        #FIXME:
        #status = i.status
        status = "-"
        post = [title, postid, status]
        posts.append(post)

    return posts


def get_post_filtered(url, user, password, postid):
    import re
    client = create_drupal_client(url, user, password)
    post = client.getPost(postid)
    title = post.title
    content = post.description
    ttags = ''
    tracks = ''
    if content.find("Technorati Tags:") >= 0:
        techno_tags = []
        hele = re.compile(r'"http://technorati.com/tag/[^$%]+"')
        a = hele.findall(content)
        b = a[0].split('"')
        for j in range(len(b)):
            if b[j].find("http://technorati.com/tag/") >=0:
                c = b[j].replace('http://technorati.com/tag/', '')
                techno_tags.append(c)

        ttags = (', ').join(techno_tags)

        if content.find("<small>Technorati Tags:") >= 0:
            descr = content.partition('<br /><br /><p style="text-align: right"><small>Technorati Tags:')
        else:
            descr = content.partition('<br /><br /><p style="text-align:right;">Technorati Tags:')

        content = descr[0]

    extended = ''
    excerpt = ''
    tags = ''
    cats = []
    postdate = post.date
    date = []
    for i in range(len(postdate)):
        if i < 5:
            date.append(postdate[i])

    slug = ''
    pssword = ''
    comments = post.allowComments
    pings = 1
    #FIXME:
    status = 'publish'
    postid = post.id

    return (title, content, extended, excerpt, ttags, tracks, tags, cats,
            date, slug, pssword, comments, pings, status, postid)



def test_new_post():
    post = DrupalPost()
    post.title   = 'Test blog post again'
    post.description    = 'Test body'
    post.status = 'publish'
    #post.date = None
    #post.permaLink = ''
    #dont work -> post.textMore = ''
    #post.excerpt = ''
    #post.link = ''
    #post.categories = []
    #post.user = ''
    post.allowComments = True
    #post.password = ''

    client = create_drupal_client()
    nid = client.newPost(post)

    print str(nid)



class DrupalPost:
    """Represents post item
    """
    def __init__(self):
        self.id = 0
        self.title = ''
        self.date = None
        self.permaLink = ''
        self.description = ''
        self.link = ''
        self.categories = []
        self.user = ''
        self.allowComments = False

class MetaWeblogCategory:
    def __init__(self):
        self.id = 0
        self.parentId = ''
        self.description = ''
        self.name = ''
        self.htmlurl = ''
        self.rssurl = ''

class DrupalCategory:
    """Represents category item
    """
    def __init__(self):
        self.id = 0
        self.name = ''
        self.isPrimary = False

class DrupalException(exceptions.Exception):
    """Custom exception for WordPress client operations
    """
    def __init__(self, obj):
        if isinstance(obj, xmlrpclib.Fault):
            self.id = obj.faultCode
            self.message = obj.faultString
        else:
            self.id = 0
            self.message = obj

    def __str__(self):
        return '<%s %d: \'%s\'>' % (self.__class__.__name__, self.id, self.message)


class DrupalClient:
    """Client for connect to WordPress XML-RPC interface
    """

    def __init__(self, url, user, password):
        self.url = url
        self.user = user
        self.password = password
        self.type = 'story'
        self.categories = None
        self._server = xmlrpclib.ServerProxy(self.url)

    def _filterPost(self, post):
        """Transform post struct in WordPressPost instance
        """
        postObj = DrupalPost()
        postObj.permaLink 		= post['permaLink']
        postObj.description 	= post['description']
        postObj.title 			= post['title']
        postObj.user 			= post['userid']
        postObj.date 			= time.strptime(str(post['dateCreated']),
                                    "%Y%m%dT%H:%M:%S")
        postObj.link 			= post['link']
        postObj.allowComments 	= post['mt_allow_comments']
        postObj.id 				= int(post['postid'])
        #postObj.categories 		= post['categories']

        return postObj

    def _filterCategory(self, cat):
        """Transform category struct in WordPressCategory instance
        """
        catObj = DrupalCategory()
        catObj.id 			= int(cat['categoryId'])
        catObj.name 		= cat['categoryName']
        if cat.has_key('isPrimary'):
            catObj.isPrimary 	= cat['isPrimary']
        return catObj

    def setContentType(self, blogId):
        self.type = 'story'

    def newPost(self, post):
        """Insert new post
        """
        blogContent = {
            'title' : post.title,
            'description' : post.description,
            'mt_allow_comments' : post.allowComments
#            'post_status' : post.status,
        }

       # if post.date:
        #    blogContent['dateCreated'] = xmlrpclib.DateTime(post.date)

        # add categories
        #i = 0
        #categories = []
        #for cat in post.categories:
        #    if i == 0:
        #        categories.append({'categoryId' : cat, 'isPrimary' : 1})
        #    else:
        #        categories.append({'categoryId' : cat, 'isPrimary' : 0})
       #     i += 1


        if post.status == 'publish':
            publish = True
        else:
            publish = False

        # insert new post
        idNewPost = int(self._server.metaWeblog.newPost(self.type, self.user,
                                            self.password, blogContent, publish))

        # set categories for new post
        #self.setPostCategories(idNewPost, categories)

        lastpost = self.getLastPost().link
        return lastpost
        #return idNewPost

    def getLastPost(self):
        """Get last post
        """
        return tuple(self.getRecentPosts(1))[0]


    def getRecentPosts(self, numPosts=5):
        """Get recent posts
        """
        try:
            posts = self._server.metaWeblog.getRecentPosts(self.type,
                                        self.user, self.password, numPosts)
            for post in posts:
                yield self._filterPost(post)
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)

    def deletePost(self, postId):
        """Delete post
        """
        try:
            return self._server.blogger.deletePost(self.type, postId,
                                        self.user, self.password, False)
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)


    def editPost(self, postId, post):
        """Edit post
        """
        blogcontent = {
            'title' : post.title,
            'description' : post.description,
            'mt_allow_comments' : post.allowComments
        #    'permaLink' : post.permaLink,
        #    'mt_allow_pings' : post.allowPings,
        #    'mt_text_more' : post.textMore,
        #    'mt_excerpt' : post.excerpt,
        #    'mt_tb_ping_urls' : post.trackbacks,
        #    'post_status' : post.status,
        #    'wp_password' : post.password,
        #    'mt_keywords' : post.tags,
        #    'wp_slug' : post.name
        }

        #if post.date:
        #    blogcontent['dateCreated'] = xmlrpclib.DateTime(post.date)

        # add categories
        #i = 0
        #categories = []
       # for cat in post.categories:
        #    if i == 0:
       #         categories.append({'categoryId' : cat, 'isPrimary' : 1})
        #    else:
        #        categories.append({'categoryId' : cat, 'isPrimary' : 0})
        #    i += 1

        if post.status == 'publish':
            publish = True
        else:
            publish = False

        print 'postid:', postId, self.user, self.password, publish
        result = self._server.metaWeblog.editPost(str(postId), self.user,
                                                self.password, blogcontent,
                                                publish)
        if result == 0:
            raise DrupalException('Post edit failed')

        # set categories for new post
        #self.setPostCategories(postId, categories)

        return result

    def getPost(self, postId):
        """Get post item
        """
        try:
            return self._filterPost(self._server.metaWeblog.getPost(str(postId),
                                    self.user, self.password))
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)

    ###################################
    ##                               ##
    ##     Categories functions      ##
    ##                               ##
    ###################################

    def getCategories(self):
        try:
            categories = self._server.metaWeblog.getCategories(self.type,
                    self.user, self.password)
            for cat in categories:
                catObj = MetaWeblogCategory()
                catObj.id = cat['categoryId']
                catObj.parentId = cat['parentId']
                catObj.description = cat['description']
                catObj.name = cat['categoryName']
                catObj.htmlurl = cat['htmlUrl']
                catObj.rssurl = cat['rssUrl']
                yield catObj
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)


    def setPostCategories(self, postId, categories):
        """Set post's categories
        """
        self._server.mt.setPostCategories(postId, self.user, self.password,
                                        categories)


    def getPostCategories(self, postId):
        """Get post's categories
        """
        try:
            categories = self._server.mt.getPostCategories(postId, self.user,
                        self.password)
            for cat in categories:
                yield self._filterCategory(cat)
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)

    def getCategoryList(self):
        """Get blog's categories list
        """
        try:
            if not self.categories:
                self.categories = []
                categories = self._server.mt.getCategoryList(self.type,
                        self.user, self.password)
                for cat in categories:
                    self.categories.append(self._filterCategory(cat))
            return self.categories
        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)

    def getCategoryIdFromName(self, name):
        """Get category id from category name
        """
        for c in self.getCategoryList():
            if c.name == name:
                return c.id

    def newMediaObject(self, mediaFileName):
        """Add new media object (image, movie, etc...)
        """
        try:
            f = file(mediaFileName, 'rb')
            mediaBits = f.read()
            f.close()

            mediaStruct = {
                'name' : os.path.basename(mediaFileName),
                'bits' : xmlrpclib.Binary(mediaBits)
            }

            result = self._server.metaWeblog.newMediaObject(self.type,
                                        self.user, self.password, mediaStruct)
            return result['url']

        except xmlrpclib.Fault, fault:
            raise DrupalException(fault)
