#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '2.0'

# files to install
inst_desktop = ['mastory.desktop']
inst_py = ['mastory.py']
pixmaps = ['pixmaps/link.png', 'pixmaps/paragraph.png', 'pixmaps/bold.png',
'pixmaps/italic.png', 'pixmaps/image.png', 'pixmaps/underline.png',
'pixmaps/strikethrough.png', 'pixmaps/add.png', 'pixmaps/left.png',
'pixmaps/right.png', 'pixmaps/center.png', 'pixmaps/fill.png',
'pixmaps/code.png', 'pixmaps/quote.png', 'pixmaps/li.png', 'pixmaps/ul.png',
'pixmaps/ol.png', 'pixmaps/fontcolor.png', 'pixmaps/bgcolor.png',
'pixmaps/fontsize.png', 'pixmaps/sup.png', 'pixmaps/sub.png',
'pixmaps/mono.png', 'pixmaps/cite.png', 'pixmaps/remove.png',
'pixmaps/edit.png', 'pixmaps/add-big.png','pixmaps/up.png',
'pixmaps/post_edited.png', 'pixmaps/img-missing.png',
'pixmaps/mastory.png', 'pixmaps/maemoorg.png', 'pixmaps/advanced.png',
'pixmaps/tags.png', 'pixmaps/preview.png', 'pixmaps/clear.png',
'pixmaps/remove-s.png', 'pixmaps/black.png', 'pixmaps/green.png',
'pixmaps/blue.png', 'pixmaps/grey.png', 'pixmaps/brown.png',
'pixmaps/white.png', 'pixmaps/red.png', 'pixmaps/yellow.png',
'pixmaps/draft.png', 'pixmaps/upload.png', 'pixmaps/manageposts.png',
'pixmaps/newpost.png', 'pixmaps/settings.png']


inst_modules = ['wordpy/__init__.py', 'wordpy/blogger.py','wordpy/flickr.py',
'wordpy/htmltags.py', 'wordpy/imaged.py', 'wordpy/io.py', 'wordpy/picasa.py',
'wordpy/posting.py', 'wordpy/settings.py', 'wordpy/utils.py',
'wordpy/wordpress.py', 'wordpy/livejournal.py', 'wordpy/drupal.py',
'wordpy/fancy_button.py']
inst_dbus = ['mastory.service']
inst_icon = ['mastory.png' ]
inst_icon_sca = ['pixmaps/mastory.png']
backup_conf  = ['mastory.conf']
sh = ['mastory']


data_files = [
  ('share/applications/hildon', inst_desktop),
  ('/opt/mastory',   inst_py),
  ('/opt/mastory/pixmaps',   pixmaps),
  ('/opt/mastory/wordpy',   inst_modules),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'mastory',
  version      = version,
  description  = 'Blogging client for Maemo',
  long_description = """MaStory allows you to blog from your Maemo device.
It supports Wordpress, Blogger, Livejournal and Drupal.
You can write posts in offline mode and edit posts already published.
It interacts with photo services like Flickr and Picasa.
And more features for blogging from your hands.""",
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://garage.maemo.org/projects/maemo-wordpy',
  license      = 'GPL v2 or later at your election',
  platforms    = 'Maemo',
  data_files   = data_files,
  scripts      = sh
)
