#!/usr/bin/python
# -*- coding: utf-8 -*-
"affichage des horaires de train"



import urllib2
import HTMLParser
import ConfigParser

try:
    import hildon
except ImportError: 
    raise ImportError("erreur d'importation de hildon")

try :
    from portrait import FremantleRotation
except ImportError: 
    raise ImportError("erreur d'importation de portrait")

try :
    import gtk
except ImportError: 
    raise ImportError("erreur d'importation de gtk")

try : 
    import pygtk
except ImportError: 
    raise ImportError("erreur d'importation de pygtk")
    
pygtk.require("2.0")

class LigneHoraire(object):
    "une ligne code_mission | heure_de_passage"
    def __init__(self, code_mission, heure_de_passage, destination, voie):
        self.__code_mission = code_mission
        self.__heure_de_passage = heure_de_passage
        self.__destination = destination
        self.__voie = voie
    
    def add_to_treestore(self, treestore):
        "ajoute la ligne à un treestore"
        treestore.append(None, [self.__code_mission, self.__heure_de_passage, self.__destination, self.__voie])
    
    

class TableParser(HTMLParser.HTMLParser):
    "Parse les tableaux html contenant les horaires"
    def __init__(self):
        HTMLParser.HTMLParser.__init__(self)
        self.__table_horaires3 = False
        self.__code_de_mission = False
        self.__a_code_de_mission = False
        self.__heure_de_passage = False
        self.__destination = False
        self.__voie = False
        self.__liste_train = []
        self.__liste_horaire = []
        self.__liste_destination = []
        self.__liste_voie = []
        
        
    def handle_starttag(self, tag, attrs):
        "execute a chaque balise ouvrante"
        if (tag == 'table' and (dict(attrs)['class'] == 'horaires3')):
            self.__table_horaires3 = True
        
        elif self.__table_horaires3 and tag == 'td':
            try:
                self.__code_de_mission = (
                    dict(attrs)['headers'] == 'Code_de_mission')
                self.__heure_de_passage = (
                    dict(attrs)['headers'] == 'Heure_de_passage')
                self.__destination = (
                    dict(attrs)['headers'] == 'Destination')
                self.__voie = (
                    dict(attrs)['headers'] == 'Voie')
            except KeyError:
                if dict(attrs).has_key('headers'):
                    raise
                else:
                    pass
        else:
            self.__a_code_de_mission = (tag == 'a' and self.__code_de_mission)
        
    def handle_data(self, data):
        "execute pour chaque contenu de balise"
        if self.__a_code_de_mission:
            self.__liste_train.append(data.strip())
        if self.__heure_de_passage:
            self.__liste_horaire.append(data.strip())
        if self.__destination:
            self.__liste_destination.append(data.strip())
        if self.__voie:
            self.__liste_voie.append(data.strip())
            
    def handle_endtag(self, tag):
        "execute à chaque balise fermante"
        self.__a_code_de_mission ^= (self.__a_code_de_mission and tag == 'a')
        self.__heure_de_passage ^= (self.__heure_de_passage and tag == 'td')
        self.__destination ^= (self.__destination and tag == 'td')
        self.__voie ^= (self.__voie and tag == 'td')
    
    
    @property
    def __list_ligne_horaire(self):
        "getter"
        __list_ligne_horaire = []
        __curseur_horaire = 0
        for __i in self.__liste_train:
            __list_ligne_horaire.append(LigneHoraire(
                code_mission=__i, 
                heure_de_passage=self.__liste_horaire[__curseur_horaire],
                destination=self.__liste_destination[__curseur_horaire],
                voie=self.__liste_voie[__curseur_horaire]
                ))
            __curseur_horaire += 1
        return __list_ligne_horaire

    def fill_treestore(self, treestore):
        "remlpli le treestore avec les resultats"
        for __i in self.__list_ligne_horaire:
            __i.add_to_treestore(treestore)

class Trajet(object):
    "trajet d'une gare source à une gare_dest"
    def __init__(self, gare_source, gare_dest):
        self.__gare_source = gare_source
        self.__gare_dest = gare_dest
        
    def refresh_treestore(self, treestore):
        "met à jour les horaires d'un trajet"
        treestore.clear()
        __parser = TableParser()
        __parser.feed(urllib2.urlopen('http://www.transilien.com/web/ITProchainsTrainsAvecDest.do?codeTr3aDepart='+self.__gare_source.shortname+'&codeTr3aDest='+self.__gare_dest.shortname+'&urlModule=/site/pid/184&gareAcc=true').read())
        __parser.fill_treestore(treestore)


class ConfFile(object):
    "fichier contenant les gares"
    def __init__(self, fichier):
        self.config = ConfigParser.ConfigParser()
        self.config.read(fichier)

class LongNameGare(object):
    "nom long d'une gare"
    def __init__(self, longname):
        self.__longname = longname
    def get_gare(self, conffile):
        "retourne une gare à partir d'un nom long"
        return Gare(conffile.config.get('ListeDesGares', self.__longname))

class Gare(object):
    "gare"
    def __init__(self, shortname):
        self.shortname = shortname

class TransilienUI:
    "interface hildon"
    def __init__(self):
        self.main_window = hildon.Window()
        self.main_window.set_title("Horaires des Prochains Trains")
        self.main_window.connect("destroy", self.on_main_window_destroy)

        rotation_object = FremantleRotation(
            'NameOfYourApp', 
            self.main_window, 
            '1.0', 
            FremantleRotation.AUTOMATIC
            )
        
        refresh_button = hildon.Button(
            gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, 
            hildon.BUTTON_ARRANGEMENT_HORIZONTAL, 
            "Actualiser"
            )
        refresh_button.connect("clicked", self.on_refresh_button_clicked)

        self.treestore = gtk.TreeStore(str, str, str, str)
        self.treeview = gtk.TreeView(self.treestore)

        self.treeview.append_column(
            gtk.TreeViewColumn( 
                'Train', 
                gtk.CellRendererText(), 
                text=0
            ))
        
        self.treeview.append_column(
            gtk.TreeViewColumn(
                'Horaire', 
                gtk.CellRendererText(), 
                text=1
            ))
            
        self.treeview.append_column(
            gtk.TreeViewColumn(
                'Destination', 
                gtk.CellRendererText(), 
                text=2
            ))
        self.treeview.append_column(
            gtk.TreeViewColumn(
                'Voie', 
                gtk.CellRendererText(), 
                text=3
            ))


        self.picker_button_source = hildon.PickerButton(
            gtk.HILDON_SIZE_AUTO, 
            hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.picker_button_source.set_title("Gare de Depart")
        self.combo_source = hildon.TouchSelectorEntry(text=True)
        self.combo_dest = hildon.TouchSelectorEntry(text=True)

        liste = ConfFile('/opt/masstransit/masstransit.cfg').config.items('ListeDesGares')
        liste.sort()
        for i in liste:
            self.combo_source.append_text(i[0])
            self.combo_dest.append_text(i[0])
        
        self.picker_button_source.set_selector(self.combo_source)

        picker_button_dest = hildon.PickerButton(
            gtk.HILDON_SIZE_AUTO, 
            hildon.BUTTON_ARRANGEMENT_VERTICAL
            )
        picker_button_dest.set_title("Gare d'arrivee")
        picker_button_dest.set_selector(self.combo_dest)
        
        vertical_box = gtk.VBox()
        horizontal_box = gtk.HBox()
        vertical_box.pack_start(horizontal_box)
        horizontal_box.pack_start(self.picker_button_source)
        horizontal_box.pack_start(picker_button_dest)
        vertical_box.pack_start(self.treeview)
        vertical_box.pack_start(refresh_button)

        self.main_window.add(vertical_box)
        self.main_window.show_all()

    def on_main_window_destroy(self, widget):
        "quitte l'application à la fermeture de la fenetre"
        gtk.main_quit()

    def on_refresh_button_clicked(self, widget):
        "met à jour les horaires"
        conf = ConfFile('/opt/masstransit/masstransit.cfg')
        try :
            gare_source = LongNameGare(self.combo_source.get_current_text()).get_gare(conf)
        except AttributeError:
            if self.combo_source.get_current_text() is None:
                gtk.Dialog.run(hildon.hildon_note_new_information(self.main_window, "Vous devez remplir la gare source"))
            else:
                raise
        else:
            try :
                gare_dest = LongNameGare(self.combo_dest.get_current_text()).get_gare(conf)     
            except AttributeError:
                if self.combo_dest.get_current_text() is None:
                    gtk.Dialog.run(hildon.hildon_note_new_information(self.main_window, "Vous devez remplir la gare de destination"))
                else:
                    raise
            else:
                Trajet(gare_source , gare_dest).refresh_treestore(self.treestore)
        
if __name__ == "__main__":
    TransilienUI()
    gtk.main()
    
