#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    stm.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


from urllib import urlopen, urlencode
from xml.etree.ElementTree import fromstring
from lib.BeautifulSoup import BeautifulSoup, BeautifulStoneSoup
from PyQt4 import QtCore

m_stm_url = "http://m.stm.info/"
stm_url = "http://www2.stm.info/"
#stm_url = "http://www2.stm.info/horaires/frmResult.aspx?Arret=54200&Langue=En"


def testUrl(url):
    try:
        urlopen(url)
        return True
    except Exception,e:
        print e
        return False
    


def getXMLBusSTopList(begin, line_number, direction):
    params = urlencode({'begin': begin, 'line_number': line_number, 'direction': direction})
    bus_stop_list_url = m_stm_url + "/stm/bus/stopList?%s" % params
    f = urlopen(bus_stop_list_url)
    dirty_xml = f.read()
    dirty_xml = dirty_xml.replace('&Ecirc;', 'e')
    dirty_xml = dirty_xml.replace('&nbsp;', ' ')
    dirty_xml = dirty_xml.replace('&eacute;', 'e')
    dirty_xml = dirty_xml.replace('&Eacute;', 'e')
    xml = fromstring(dirty_xml)
    return xml


# Bus

## Bus stop list
def getBusStopList(direction, line_number):
    """
    direction = "North" # South, West, Est, North
    line_number = 55
    begin = 0 # 20,40,60,80 ... 20 by page
    """
    begin = 0

    bus_stop_list = []
    bus_stop_list_temp = None
    while bus_stop_list_temp != []:
        xml = getXMLBusSTopList(begin,line_number,direction)
        begin += 20
        bus_stop_list_temp = []
        divs = xml.findall("{http://www.w3.org/1999/xhtml}body/{http://www.w3.org/1999/xhtml}div")
        for div in divs:
            children = div.getchildren()
            if len(children) != 2:
                continue
            if 'stop_code' in children[1].attrib.values()[0]:
                bus_stop_name = u"%s" % children[0].text[:-3]
                stop_code = children[1].text
#                stop_code_link = children[1].attrib['href']
                bus_stop_list_temp.append((stop_code, bus_stop_name))

        bus_stop_list.extend(bus_stop_list_temp)

    return bus_stop_list

## Bus stop
def parse_bus_stop_schedule(soup, night=False):

    # get stop name
    stops_soup = soup.findAll("span", {"id" : "lblArret"})
    if len(stops_soup) > 0:
        stops = [i.string for i in stops_soup[0].findAll("font")]
        if len(stops) > 0:
            stop_name = stops[0]
            stop_name = stop_name.split(" - ")[1]


    if night:
        table = "webGrilleNuit"
    else:
        table = "webGrille"

    grille = soup.findAll("table", {"id" : table})
    if len(grille) < 1:
        return False,False
    soup2 = BeautifulSoup(str(grille[0]))

    # Get Times
    temp_times = []
    for td in soup2.findAll("td", {"width" : "55"}):
        child = td.findChild("a")
        if child:
            # TODO: note
            # note = dict(child.attrs)["onclick"]
            # note = note.split("('")[1].split("')")[0]
            temp_times.append(child.string)
        else:
            temp_times.append(td.string)
            
    # Convert Time
    temp_times2 = []
    today = QtCore.QDate.currentDate()
    now = QtCore.QTime.currentTime()
    six_am = QtCore.QTime(6,0)
    mid_night = QtCore.QTime(0,0)
    four_am = QtCore.QTime(4,0)
    
    for time in temp_times:
        try:
            hour,minute = time.split("h")
            schedule_time = QtCore.QTime(int(hour),int(minute))
            
            # for night buses ( begin after 00:01 and finish at 06:00)
            if now > six_am and table == "webGrilleNuit":
                day = today.addDays(1)
            # for normal buses which finish after 00:01
            elif table == "webGrille" \
                and schedule_time > mid_night \
                and schedule_time < four_am \
                and now > four_am:
                day = today.addDays(1)
            else:
                day = today
            date = QtCore.QDateTime(day,
                                    QtCore.QTime(int(hour), int(minute))
                                    )
            temp_times2.append(date)
        except:
            temp_times2.append(None)

    # Get line number and direction
    temp_lines = [unicode(i.string) for i in soup2.findAll("b", {})]
    datas = []
    
    # Group by 6 times
    times = []
    for i in range(0,len(temp_times2)-1,6):
        times.append(temp_times2[i:i+6])

    # Groups by 2 (line number and direction)
    lines = []
    for i in range(0,len(temp_lines)-1,2):
        lines.append(temp_lines[i:i+2])
 
    return stop_name,zip(lines,times)

def getBusStopSchedule(stop_code, line_number=None, mode=None):
    """
    """
    stop_code=str(stop_code)

    # Get informations
    params = urlencode({
                        'Arret': stop_code,
                        'Langue': 'En',
                        })
    bus_stop_url = stm_url + "horaires/frmResult.aspx?%s" % params

    f = urlopen(bus_stop_url)
    dirty_xml = f.read()
    soup = BeautifulSoup(dirty_xml)

    
    stop_name = "Stop name not found"
    if mode == 'day':
        stop_name,datas = parse_bus_stop_schedule(soup, False)
    elif mode == 'night':
        stop_name,datas = parse_bus_stop_schedule(soup, True)
    else:
        stop_name,datas = parse_bus_stop_schedule(soup, False)
        stop_name_night,night_datas = parse_bus_stop_schedule(soup, True)
        if night_datas != False:
            datas.append(night_datas[0])

    if line_number:
        for line,stop_codes in datas:
            if line[0] == unicode(line_number):
                return stop_name,[(line,stop_codes),]
        return "No data found for this line",False

    return stop_name,datas



def getBusLineList(lines_range=0):

    stm_url = "http://www.stm.info/English/bus/"
    lines = [   "A-LIG10.HTM",
                "A-LIG100.HTM",
                "A-LIG170.HTM",
                "A-LIG350.HTM",
            ]

    bus_stop_url = stm_url + lines[lines_range]

    f = urlopen(bus_stop_url)
    dirty_xml = f.read()
    soup = BeautifulSoup(dirty_xml)

    table = soup.findAll("table", { "width" : "403",
                            "border" : "1",
                            "cellspacing" : "0",
                            "cellpadding" : "1",
                            })

    if len(table) < 1:
        return False,False

    soup2 = BeautifulSoup(str(table[0]))

    temp_td_list = soup2.findAll("td")

    lines_list = []
    temp_td_list = temp_td_list[4:]
    for i in range(0,len(temp_td_list)-1,5):
        line = temp_td_list[i].string.strip()
        encoded_line_name = temp_td_list[i+1].findChild().string.strip()
        line_name = unicode(BeautifulStoneSoup(encoded_line_name,convertEntities=BeautifulStoneSoup.HTML_ENTITIES ))
        line_map = "http://www.stm.info/English/bus/plan_lig/A-PL%s.htm" % line
#        line_complete_schedule = temp_td_list[i+4].string
        lines_list.append((line, line_name, line_map))

    return lines_list


#Maps
#map_url = "http://www.stm.info/bus/images/PLAN/lign-10.gif"


# Metro

## Station list

# verte = 1
# orange = 2
# jaune = 4
# bleue = 5
#line_id = 1
#station_list_url = "http://m.stm.info/stm/subway/stationList?lineId=%(line_id)s"
### => Return station list

## Metro station
#station_name = "Charlevoix"
#metro_station_url = "http://m.stm.info/stm/subway/schedule?lineId=%(line_id)s&stationId=%(station_name)s"
### => Return first and last train

## Metro maps
#metro_maps = "http://m.stm.info/stm/images/stm_subway_map_640x644.png"
