#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    lineslist.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from PyQt4 import QtCore, QtGui
from module import stm

class UI_LinesList(QtGui.QMainWindow):
    def __init__(self, lines_range, parent=None, root=None):
        QtGui.QMainWindow.__init__(self, parent=parent)
        self.parent = parent
        self.root = root
        self.setWindowTitle("Mass-Transit - Bus lines")
        self.tree_widget = QtGui.QTreeWidget()
        self.tree_widget.setColumnCount(2)
        self.tree_widget.setHeaderHidden(1)
        self.tree_widget.setRootIsDecorated(0)
        self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        self.setCentralWidget(self.tree_widget)


        lines = stm.getBusLineList(lines_range)
        row = 0
        for line in lines:
            line_item = QtGui.QTreeWidgetItem(QtCore.QStringList(line))
            line_item.setData(0,QtCore.Qt.UserRole,line[0])
            line_item.setData(1,QtCore.Qt.UserRole,line[0])
            self.tree_widget.addTopLevelItem(line_item)

        # Signals
        QtCore.QObject.connect( self.tree_widget,
                                QtCore.SIGNAL("itemClicked (QTreeWidgetItem *,int)"),
                                self.show_directions)

    def show_directions(self, item, column):
        line = item.data(column,QtCore.Qt.UserRole).toString()
        self.root.stop_list(str(line), self)
        self.setAttribute(QtCore.Qt.WA_Maemo5ShowProgressIndicator, False)


    def closeEvent(self, event):
        self.root.mode = "favorites"
