#include <hildon/hildon.h>
#include "mr_biorhythm_chart.h"
#include <libosso-abook/osso-abook.h>
#include "config.h"



#define MARHYTHM_IMAGE_PATH PACKAGE_DATA_DIR"/marhythm/images"
#define MARHYTHM_IMAGE_STAR_ENABLED_PATH MARHYTHM_IMAGE_PATH"/star_enabled.png"
#define MARHYTHM_IMAGE_STAR_DISABLED_PATH MARHYTHM_IMAGE_PATH"/star_disabled.png"
#define MARHYTHM_IMAGE_STAR_CRITICAL_PATH MARHYTHM_IMAGE_PATH"/star_critical.png"
#define MARHYTHM_IMAGE_PHYSICAL_LEGEND_PATH MARHYTHM_IMAGE_PATH"/physical_legend.png"
#define MARHYTHM_IMAGE_EMOTIONAL_LEGEND_PATH MARHYTHM_IMAGE_PATH"/emotional_legend.png"
#define MARHYTHM_IMAGE_INTELLECTUAL_LEGEND_PATH MARHYTHM_IMAGE_PATH"/intellectual_legend.png"

typedef struct
{
	gfloat physical;
	gfloat emotional;
	gfloat intellectual;
} MarhythmBiorhythmValues;

typedef struct
{
	GtkWidget* physicalStarWidgets[4];
	GtkWidget* emotionalStarWidgets[4];
	GtkWidget* intellectualStarWidgets[4];
	GtkLabel *selectedDateLabel;
	GtkButton *previousReferenceDayButton;
	GtkButton *nextReferenceDayButton;
	MrBiorhythmChart *biorhythmChart;
} MarhythmBiorhythmUpdatableWidgets;

typedef struct
{
    GtkWidget *biorhythmChart;
    GtkWidget *mainWindow;
    GtkWidget *referenceDateSelectorButton;
    GtkWidget *personalBiorhythmButton;
    GtkWidget *aboutButton;
    GtkWidget *contactListView;
    GtkWidget *filterByABCButton;
    GtkWidget *filterByAvailabilityButton;
    GtkWidget *filterByRecentButton;
    GDate *currentReferenceDate;
    GDate *currentSelectedDate;
    GDate *currentContactBirthDate;
    MarhythmBiorhythmUpdatableWidgets biorhythmUpdatableWidgets;
} MarhythmData;

void marhythm_init( MarhythmData *applicationData );
void marhythm_display_contacts( MarhythmData *applicationData );
void marhythm_display_contacts_by_abc( MarhythmData *applicationData );
void marhythm_display_contacts_by_availability( MarhythmData *applicationData );
void marhythm_display_biorhythm( MarhythmData *applicationData, OssoABookContact *contact );
void marhythm_display_personal_biorhythm( MarhythmData *applicationData );
void marhythm_set_biorhythm_contact( MarhythmData *applicationData, OssoABookContact *contact );
void marhythm_set_biorhythm_reference_date( MarhythmData *applicationData, GDate *referenceDate );
void marhythm_set_default_current_reference_date( MarhythmData *applicationData );
void marhythm_create_stars_from_biorhythm_value( GtkWidget* widgetsArray[], gfloat value );
void marhythm_update_biorhythm_screen( MarhythmData *applicationData );
void marhythm_update_stars_from_biorhythm_value( GtkWidget* widgetsArray[], gfloat value );
void marhythm_update_biorhythm_widgets( MarhythmBiorhythmUpdatableWidgets *biorhythmUpdatableWidgets, MarhythmBiorhythmValues biorhythmValues, GDate *selectedDate );
void marhythm_show_about_dialog();
