#include "callbacks.h"
#include "marhythm.h"

void aboutButtonClicked( GtkWidget *button, gpointer data )
{
	marhythm_show_about_dialog();
}

void contactActivated (OssoABookContactView *view,
                                                        OssoABookContact *master_contact,
                                                        gpointer data)
{
    MarhythmData *applicationData;
    applicationData = (MarhythmData*) data;
    
    EContactDate *contactBirthDate;
    
    contactBirthDate = ( EContactDate* )  e_contact_get ( E_CONTACT ( master_contact ),
                                                         E_CONTACT_BIRTH_DATE );
    if( contactBirthDate != NULL )
    {
        marhythm_display_biorhythm( applicationData, master_contact );
    }
    else
    {
        hildon_banner_show_information ( applicationData->mainWindow, NULL, "The birthdate for this contact has not been specified");
    }
}

void filterButtonToggled( GtkWidget *button, gpointer data )
{
    MarhythmData *applicationData = (MarhythmData*) data;
    if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(button) ) )
    {
       
         if( button == applicationData->filterByABCButton  )
        {
            marhythm_display_contacts_by_abc( applicationData );            
            return;
        }

        if( button == applicationData->filterByAvailabilityButton  )
        {
            marhythm_display_contacts_by_availability( applicationData );            
            return;
        }   

    }
}

void
personalBiorhythmClicked( GtkWidget *button, gpointer data )
{
    MarhythmData *applicationData = (MarhythmData*) data;
    marhythm_display_personal_biorhythm( applicationData );
}

void referenceDateChanged( HildonPickerButton *button, gpointer data )
{
    MarhythmData  *applicationData;
    GtkWidget *referenceDateSelectorButton;
    GDate *referenceDate;
    GDate *selectedDate;
    guint selectedDay, selectedMonth, selectedYear;

    applicationData = (MarhythmData*) data;
    referenceDateSelectorButton = GTK_WIDGET( button );

    hildon_date_button_get_date( HILDON_DATE_BUTTON(referenceDateSelectorButton), &selectedYear, &selectedMonth, &selectedDay );

    referenceDate = g_date_new_dmy( selectedDay, selectedMonth + 1, selectedYear );
	selectedDate = g_date_new_dmy( g_date_get_day( referenceDate ),
					g_date_get_month( referenceDate ),
					g_date_get_year( referenceDate ) );
					
	applicationData->currentReferenceDate = referenceDate;
	applicationData->currentSelectedDate = selectedDate;
	
	marhythm_update_biorhythm_screen( applicationData );
}

void nextReferenceDayButtonClicked( GtkWidget *button, gpointer data )
{    
    MarhythmData  *applicationData;
    MarhythmBiorhythmUpdatableWidgets *biorhythmUpdatableWidgets;
    GDate *newSelectedDate;

    applicationData = (MarhythmData*) data;
    biorhythmUpdatableWidgets = &applicationData->biorhythmUpdatableWidgets;
    
    gtk_widget_set_sensitive( GTK_WIDGET( biorhythmUpdatableWidgets->previousReferenceDayButton ), TRUE);
    
    if(  g_date_days_between( applicationData->currentReferenceDate, applicationData->currentSelectedDate ) == 13 )
    {
		gtk_widget_set_sensitive( GTK_WIDGET( biorhythmUpdatableWidgets->nextReferenceDayButton ), FALSE);
	}
     
    g_date_add_days( applicationData->currentSelectedDate, 1 );
    
    newSelectedDate = g_date_new_dmy( g_date_get_day( applicationData->currentSelectedDate ),
		g_date_get_month( applicationData->currentSelectedDate ),
		g_date_get_year( applicationData->currentSelectedDate ) );
		
	applicationData->currentSelectedDate = newSelectedDate;
    
    marhythm_update_biorhythm_screen( applicationData );
}

void previousReferenceDayButtonClicked( GtkWidget *button, gpointer data )
{    
    MarhythmData  *applicationData;
    MarhythmBiorhythmUpdatableWidgets *biorhythmUpdatableWidgets;
    GDate *newSelectedDate;

    applicationData = (MarhythmData*) data;
    biorhythmUpdatableWidgets = &applicationData->biorhythmUpdatableWidgets;
    
    gtk_widget_set_sensitive( GTK_WIDGET( biorhythmUpdatableWidgets->nextReferenceDayButton ), TRUE);
    
    if(  g_date_days_between( applicationData->currentReferenceDate, applicationData->currentSelectedDate ) == -14 )
    {
		gtk_widget_set_sensitive( GTK_WIDGET( biorhythmUpdatableWidgets->previousReferenceDayButton ), FALSE);
	}
	
    
    g_date_subtract_days( applicationData->currentSelectedDate, 1 );    
    
    newSelectedDate = g_date_new_dmy( g_date_get_day( applicationData->currentSelectedDate ),
		g_date_get_month( applicationData->currentSelectedDate ),
		g_date_get_year( applicationData->currentSelectedDate ) );
		
	applicationData->currentSelectedDate = newSelectedDate;
    
    
    marhythm_update_biorhythm_screen( applicationData );
}
