#include "mr_utilities.h"
#include <math.h>

gfloat mr_calculate_cycle_energy_from_date( GDate *birthDate, GDate *referenceDate, MR_BIORHYTHM_CYCLE cycle )
{
    gint daysLive;
    gfloat result;

    daysLive = g_date_days_between( birthDate, referenceDate );

    result = sin( ( daysLive    / (double) cycle) * 2 * G_PI ) * MR_ENERGY_MAX_VALUE;
    return result;
}
