#ifndef _HILDON_MAPPER_H
#define _HILDON_MAPPER_H

#include "config.h"

#ifdef WITH_OSSO
#include <libosso.h>

#ifdef WITH_OSSO_IC
#include <osso-ic.h>
#include <osso-ic-dbus.h>
#endif

#ifdef WITH_TBI
#include <tablet-browser-interface.h>
#else
#ifdef WITH_OBI
#include <osso-browser-interface.h>
#endif
#endif

#include "iap.h"
#endif

#ifdef WITH_HILDON

#ifdef WITH_HILDON_1
#include <hildon/hildon.h>

#ifdef WITH_HILDONFM
#include <hildon/hildon-file-chooser-dialog.h>
#endif

#ifdef WITH_DEVICE_MAEMO
#include <device_symbols.h>
#endif

#else

#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-controlbar.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-color-button.h>
#include <hildon-widgets/hildon-number-editor.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-system-sound.h>

#ifdef WITH_HILDONFM
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#endif

#ifdef WITH_DEVICE_MAEMO
#include <device_symbols.h>
#include <hildon-widgets/hildon-input-mode-hint.h>
#endif

#endif

#if HILDON_CHECK_VERSION(2,2,0)
#define WITH_HILDON_2_2
#include <he-about-dialog.h>
#include <he-fullscreen-button.h>
#else
#define WITH_HILDON_2_0
#endif

#else
#include "hildon-wrappers.h"
#endif

#endif /* H */
