/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * UI Action groups, toolbars and menus
 *
 * Should be included from ui-common.c ONLY
 */
 
static GtkActionEntry ui_entries[] = {
	{"file", NULL, N_("_File"), NULL, NULL, NULL },
	{"file_settings", GTK_STOCK_PREFERENCES, N_("_Settings..."), NULL, NULL, NULL },
	{"file_settings_generic", NULL, N_("Generic..."), NULL, NULL, G_CALLBACK(menu_cb_settings) },
	{"file_settings_colors", NULL, N_("_Colors..."), NULL, NULL, G_CALLBACK(menu_cb_settings_colors) },
	{"file_settings_gps", NULL, N_("_Gps..."), NULL, NULL, G_CALLBACK(menu_cb_settings_gps) },
	{"file_settings_osm", NULL, N_("_Map info..."), NULL, NULL, G_CALLBACK(menu_cb_settings_osm) },
	{"file_settings_keys", NULL, N_("_Keys..."), NULL, NULL, G_CALLBACK(menu_cb_settings_keys) },
	{"file_import_osm", GTK_STOCK_OPEN, N_("_Import OSM data..."), NULL, NULL, G_CALLBACK(menu_cb_import_osm) },
	{"file_quit", GTK_STOCK_QUIT, N_("_Quit"), "<control>Q", NULL, G_CALLBACK(mapper_cb_quit) },

	{"help", NULL, N_("_Help"), NULL, NULL, NULL },
	{"help_about", GTK_STOCK_ABOUT, N_("_About"), "<control>A", NULL, G_CALLBACK(menu_cb_about) },

	{"track", NULL, N_("_Track"), NULL, NULL, NULL },
	{"track_open", GTK_STOCK_OPEN, N_("_Open..."), NULL, NULL, G_CALLBACK(menu_cb_track_open) },
	{"track_save", GTK_STOCK_SAVE, N_("_Save..."), "<control>S", NULL, G_CALLBACK(menu_cb_track_save) },
	{"track_clear", GTK_STOCK_CLEAR, N_("_Clear"), NULL, NULL, G_CALLBACK(menu_cb_track_clear) },
	{"track_insert_break", NULL, N_("Insert _Break"), NULL, NULL, G_CALLBACK(menu_cb_track_insert_break) },
	{"track_insert_mark", GTK_STOCK_NEW, N_("Insert _Mark..."), NULL, NULL, G_CALLBACK(menu_cb_track_insert_mark) },
	{"track_dist_last_mark", NULL, N_("Distance to _last mark"), NULL, NULL, G_CALLBACK(menu_cb_track_distlast) },
	{"track_dist_first", NULL, N_("Distance from _first"), NULL, NULL, G_CALLBACK(menu_cb_track_distfirst) },
	{"track_filter", NULL, N_("_Filter..."), NULL, NULL, G_CALLBACK(menu_cb_track_filter) },

	{"route", NULL, N_("_Route"), NULL, NULL, NULL },
	{"route_open", GTK_STOCK_OPEN, N_("_Open..."), NULL, NULL, G_CALLBACK(menu_cb_route_open) },
	{"route_save", GTK_STOCK_SAVE, N_("_Save..."), NULL, NULL, G_CALLBACK(menu_cb_route_save) },
	{"route_download", NULL, N_("Do_wnload..."), NULL, NULL, G_CALLBACK(menu_cb_route_download)},
	{"route_reset", NULL, N_("Reset"), NULL, NULL, G_CALLBACK(menu_cb_route_reset) },
	{"route_clear", GTK_STOCK_CLEAR, N_("_Clear"), NULL, NULL, G_CALLBACK(menu_cb_route_clear) },
	{"route_dist_next", NULL, N_("Show Distance to _Next Waypoint"), NULL, NULL, G_CALLBACK(menu_cb_route_distnext) },
	{"route_dist_last", NULL, N_("Show Distance to _End of Route"), NULL, NULL, G_CALLBACK(menu_cb_route_distlast) },

	{"poi", NULL, N_("_Poi"), NULL, NULL, NULL },
	{"poi_categories", GTK_STOCK_INDEX, N_("_Categories.."), NULL, NULL, G_CALLBACK(menu_cb_category) },
	{"poi_settings", GTK_STOCK_PREFERENCES, N_("_Settings..."), NULL, NULL, NULL },
	{"poi_add", GTK_STOCK_ADD, N_("_Add"), "<control>A", NULL, G_CALLBACK(cb_poi_add) },
	{"poi_quick_add", GTK_STOCK_ABOUT, N_("_Quick Add"), "<control>E", NULL, G_CALLBACK(cb_quick_poi_display) },
	{"poi_search", GTK_STOCK_FIND, N_("_Search..."), NULL, NULL, G_CALLBACK(cb_poi_search) },
	{"poi_import", GTK_STOCK_OPEN, N_("_Import..."), NULL, NULL, NULL },
	{"poi_export", GTK_STOCK_SAVE, N_("_Export..."), NULL, NULL, NULL },

	{"search", NULL, N_("_Search"), NULL, NULL, NULL },
	{"search_address", GTK_STOCK_FIND, N_("Address..."), "<control>F", NULL, G_CALLBACK(menu_cb_search_address) },

	{"map", NULL, N_("_Map"), NULL, NULL, NULL },
	{"map_maps", NULL, N_("_Maps"), NULL, NULL, NULL },
	{"map_manager", NULL, N_("Manager..."), NULL, NULL, G_CALLBACK(menu_cb_mapman) },
	{"autocenter", NULL, N_("_Autocenter"), NULL, NULL, NULL },

	{"view", NULL, N_("_View"), NULL, NULL, NULL },
	{"view_zoom_in", GTK_STOCK_ZOOM_IN, N_("Zoom _in"), NULL, NULL, G_CALLBACK(cb_zoomin) },
	{"view_zoom_out", GTK_STOCK_ZOOM_OUT, N_("Zoom _out"), NULL, NULL, G_CALLBACK(cb_zoomout) },
	{"view_zoom_normal", GTK_STOCK_ZOOM_100, N_("Zoom _normal"), "<control>0", NULL, G_CALLBACK(cb_zoom_base) },

	{"goto", NULL, N_("_Go"), NULL, NULL, NULL },
	{"goto_home", GTK_STOCK_HOME, N_("_Home"), "<control>H", NULL, G_CALLBACK(menu_cb_goto_home) },
	{"goto_destination", GTK_STOCK_JUMP_TO, N_("_Destination"), "<control>J", NULL, G_CALLBACK(menu_cb_goto_destination) },
	{"goto_gps", NULL, N_("_GPS"), "<control>G", NULL, G_CALLBACK(menu_cb_goto_gps) },
	{"goto_latlon", NULL, N_("Lat/Lon"), NULL, NULL, G_CALLBACK(menu_cb_goto_latlon) },
	{"goto_nextway", NULL, N_("Next Waypoint"), NULL, NULL, G_CALLBACK(menu_cb_goto_nextway) },
	{"goto_nearpoi", NULL, N_("Near POI"), NULL, NULL, G_CALLBACK(menu_cb_goto_nearpoi) },

	{"audio", NULL, N_("_Audio"), NULL, NULL, NULL },

	{"gps", NULL, N_("Gp_s"), NULL, NULL, NULL },
	{"gps_settings", NULL, N_("_Settings..."), NULL, NULL, NULL },
};
static guint n_ui_entries = G_N_ELEMENTS (ui_entries);

static GtkToggleActionEntry ui_toggle_entries[] = {
	{"map_auto_download", NULL, N_("Auto download"), NULL, NULL, G_CALLBACK(menu_cb_auto_download), FALSE},
	{"view_zoom_auto", GTK_STOCK_ZOOM_FIT, N_("AutoZoom"), NULL, NULL, G_CALLBACK(cb_zoom_auto), FALSE},
	{"gps_enabled", GTK_STOCK_CONNECT, N_("GPS Enabled"), NULL, NULL, G_CALLBACK(menu_cb_enable_gps), FALSE},
	{"audio_button_toggle_record", NULL, N_("Headset button toggles record"), NULL, NULL, G_CALLBACK(menu_cb_audio_toggle), FALSE},
#if defined (GTK_STOCK_FULLSCREEN)
	{"view_fullscreen", GTK_STOCK_FULLSCREEN, N_("Fullscreen"), NULL, NULL, G_CALLBACK(cb_fullscreen), FALSE},
#else
	{"view_fullscreen", NULL, N_("Fullscreen"), "F11", NULL, G_CALLBACK(cb_fullscreen), FALSE},
#endif
	{"view_toolbar", NULL, N_("Show Toolbar"), NULL, NULL, G_CALLBACK(menu_cb_view_toolbar), FALSE},
	{"view_scale", NULL, N_("Show Scale"), NULL, NULL, G_CALLBACK(menu_cb_show_scale), TRUE},
	{"view_route", NULL, N_("Show Route"), NULL, NULL, G_CALLBACK(menu_cb_show_routes), TRUE},
	{"view_track", NULL, N_("Show Track"), NULL, NULL, G_CALLBACK(menu_cb_show_tracks), TRUE},
	{"view_vector", NULL, N_("Show Vector"), NULL, NULL, G_CALLBACK(menu_cb_show_velvec), TRUE},
	{"view_poi", NULL, N_("Show POIs"), NULL, NULL, G_CALLBACK(menu_cb_show_poi), TRUE},
};
static guint n_ui_toggle_entries = G_N_ELEMENTS (ui_toggle_entries);

static GtkRadioActionEntry ui_autocenter_entries[] = {
  { "autocenter_latlon", NULL, "Lat/Lon", "<control>L", NULL, CENTER_LATLON },
  { "autocenter_lead", NULL, "Lead", "<control>E", NULL, CENTER_LEAD },
  { "autocenter_none", NULL, "None", "<control>N", NULL, CENTER_MANUAL },
};
static guint n_ui_autocenter_entries = G_N_ELEMENTS (ui_autocenter_entries);

