/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gconf/gconf-client.h>
#include "gconf-utils.h"

/**
 * GConf helpers
 *
 */

/**
 *
 */
gint 
mapper_gconf_get_int(GConfClient *gconf_client, const gchar *path, gint def)
{
GConfValue *value;
gint v;

g_return_val_if_fail(gconf_client, def);
value=gconf_client_get(gconf_client, path, NULL);
if (value) {
	v=gconf_value_get_int(value);
	gconf_value_free(value);
} else {
	v=def;
}
return v;
}

/**
 *
 */
gboolean
mapper_gconf_get_boolean(GConfClient *gconf_client, const gchar *path, gboolean def)
{
GConfValue *value;
gboolean r;

g_return_val_if_fail(gconf_client, def);
value=gconf_client_get(gconf_client, path, NULL);
if (value) {
	r=gconf_value_get_bool(value);
	gconf_value_free(value);
} else {
	r=def;
}
return r;
}

/**
 *
 */
gint
mapper_gconf_get_bound_int(GConfClient *gconf_client, const gchar *path, gint def, gint min, gint max)
{
gint r;

g_return_val_if_fail(gconf_client, def);
r=mapper_gconf_get_int(gconf_client, path, def);
return CLAMP(r, min, max);
}

gfloat
mapper_gconf_get_float(GConfClient *gconf_client, const gchar *path, gfloat def)
{
GConfValue *value;
gfloat v;

g_return_val_if_fail(gconf_client, def);
value=gconf_client_get(gconf_client, path, NULL);
if (value) {
	v=gconf_value_get_float(value);
	gconf_value_free(value);
} else {
	v=def;
}
return v;
}
