#ifndef _MAPPER_BLUETOOTH_SCAN_H
#define _MAPPER_BLUETOOTH_SCAN_H

#include <dbus/dbus-glib.h>

#include "config.h"
#include "gps.h"

typedef struct _GpsScanInfo GpsScanInfo;
struct _GpsScanInfo {
	GtkWidget *window;
	GtkWidget *txt_rcvr_mac;
	GtkWidget *dialog;
	GtkWidget *banner;
	GtkListStore *store;
	DBusGConnection *dbus_conn;
	DBusGProxy *req_proxy;
	DBusGProxy *sig_proxy;
	guint sid;
	gboolean scanning:1;
	gboolean done:1;
	gboolean fail:1;
};

typedef enum {
	GPS_SCAN_OK=0,
	GPS_SCAN_FAIL=1,
	GPS_SCAN_ERROR=2,
} GpsScanResult;

GpsScanResult gps_scan_start_search(GpsScanInfo *scan_info);
gboolean gps_scan_stop_search(GpsScanInfo *scan_info);
gboolean gps_scan_bluetooth(GtkWidget *widget, GpsScanInfo *scan_info);

#endif
