/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2009 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* Handle speach and graphical announcements */

#include "config.h"

#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include <libintl.h>
#include <locale.h>

#include "ui-common.h"
#include "utils.h"
#include "settings.h"
#include "announcements.h"
#include "speak.h"

static gboolean enable_speach=TRUE;
static gboolean enable_gui=TRUE;

#define SPEAK(s) { if (enable_speach) speak_text(s); }

void
announce_distance_to_destination(gdouble distance, gchar *unit, gdouble climit)
{
gchar buffer[64];
if (distance>climit) {
	g_snprintf(buffer, sizeof(buffer), _("Distance to destination: %.01f %s"), distance, unit);
} else {
	g_snprintf(buffer, sizeof(buffer), _("Distance to destination: %.02f %s"), distance, unit);
}
SPEAK(buffer);
MACRO_BANNER_SHOW_INFO(mapp.mainwindow, buffer);
}

void
announce_destination_reached(void)
{
gchar *msg=_("You have reached your destination.");
SPEAK(msg);
MACRO_BANNER_SHOW_INFO(mapp.mainwindow, msg);
}

void
announce_over_speed_limit(guint limit)
{
gchar *msg=_("Warning, you are over speed limit!");
SPEAK(msg);
MACRO_BANNER_SHOW_INFO(mapp.mainwindow, msg);
}

void
announce_waypoint(gchar *msg)
{
SPEAK(msg);
MACRO_BANNER_SHOW_INFO(mapp.mainwindow, msg);
}

#if 0

void
announce_continue(gchar *to_name, gchar *to_ref)
{
gchar buffer[64];

}

void
announce_turn(gdouble direction, gchar *to_name, gchar *to_ref, gdouble next_wpt_dist, gchar unit)
{
gchar buffer[128];
gchar *turn, *amount;

turn=(direction > 0) ? _("left") : _("right");
/* amount=(fabs(direction)<25) ? */
g_snprintf(buffer, sizeof(buffer), "Turn %s to %s, %s. Continue on %s ", 
	turn,
	to_name ? to_name : "",
	to_ref ? to_ref : "",
	to_ref ? to_ref : to_name ? );
}

#endif
